/*
 * ion/key.c
 *
 * Copyright (c) Tuomo Valkonen 1999-2001. 
 * See the included file LICENSE for details.
 */

#include <ctype.h>

#include "common.h"
#include "key.h"
#include "binding.h"
#include "global.h"
#include "wedln.h"
#include "event.h"
#include "cursor.h"
#include "objp.h"


static void adhoc_insstr(WEdln *wedln, XKeyEvent *ev)
{
	static XComposeStatus cs={NULL, 0};
	char buf[16]={0,};
	Status stat;
	int n;
	KeySym ksym;
	
	if(wedln->input.win.xic!=NULL){
		if(XFilterEvent((XEvent*)ev, ev->window))
		   return;
		n=XmbLookupString(wedln->input.win.xic, ev, buf, 16, &ksym, &stat);
	}else{
		n=XLookupString(ev, buf, 16, &ksym, &cs);
	}
	
	if(n<=0 || *(uchar*)buf<32)
		return;
	
	edln_insstr(&(wedln->edln), buf);
}


void handle_keypress(XKeyEvent *ev)
{
	WThing *thing=NULL;
	WScreen *scr;
	WBinding *binding=NULL;
	WBindmap **bindptr;
	bool topmap=TRUE;
	bool toplvl=FALSE;
	
	if(wglobal.input_mode!=INPUT_NORMAL)
		thing=wglobal.grab_holder;
	else
		thing=FIND_WINDOW(ev->window);
	
	if(thing==NULL || !WTHING_IS(thing, WWindow))
		return;
	
	bindptr=&(((WWindow*)thing)->bindmap);
	toplvl=WTHING_IS(thing, WFrame);
	
	binding=lookup_binding(*bindptr, ACT_KEYPRESS, ev->state, ev->keycode);

	if(binding==NULL && wglobal.input_mode==INPUT_SUBMAPGRAB){
		if(ismod(ev->keycode))
			return;
	}
	   
	while((*bindptr)->parent!=NULL){
		topmap=FALSE;
		*bindptr=(*bindptr)->parent;
	}
	
	if(binding!=NULL && binding->submap!=NULL){
		*bindptr=binding->submap;
		if(toplvl && wglobal.input_mode==INPUT_NORMAL){
			grab_kb_ptr(thing);
			change_grab_cursor(CURSOR_WAITKEY);
			wglobal.input_mode=INPUT_SUBMAPGRAB;
		}
		return;
	}

	if(wglobal.input_mode==INPUT_SUBMAPGRAB)
		ungrab_kb_ptr();
	
	if(binding!=NULL){
		/* Get the screen now for waitrel grab - the thing might
		 * have been destroyed when call_binding returns.
		 */
		scr=SCREEN_OF(thing);
		call_binding(binding, thing);
		if(ev->state!=0 && binding->waitrel){
			grab_kb_ptr((WThing*)scr);
			wglobal.input_mode=INPUT_WAITRELEASE;
		}
	}else{
		if(topmap && WTHING_IS(thing, WEdln))
			adhoc_insstr((WEdln*)thing, ev);
	}
}

