<?php
/**
 * $Horde: imp/thread.php,v 2.10.2.3 2005/09/01 04:47:39 slusarz Exp $
 *
 * Copyright 2004-2005 Michael M Slusarz <slusarz@mail.curecati.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

@define('IMP_BASE', dirname(__FILE__));
require_once IMP_BASE . '/lib/base.php';
require_once IMP_BASE . '/lib/MIME/Contents.php';
require_once IMP_BASE . '/lib/MIME/Headers.php';
require_once IMP_BASE . '/lib/Mailbox.php';
require_once 'Horde/Template.php';

/* Make sure we have a valid index. */
$imp_mailbox = &new IMP_Mailbox(Util::getFormData('index'));
if (!$imp_mailbox->isValidIndex()) {
    $actionID = 'message_missing';
    $from_message_page = true;
    $start = null;
    require IMP_BASE . '/mailbox.php';
    exit;
}

/* Set the current time zone. */
NLS::setTimeZone();

/* Run through action handlers. */
$actionID = Util::getFormData('actionID');
switch ($actionID) {
case 'add_address':
    $contact_link = IMP::addAddress(Util::getFormData('address'), Util::getFormData('name'));
    if (is_a($contact_link, 'PEAR_Error')) {
        $notification->push($contact_link);
    } else {
        $notification->push(sprintf(_("Entry \"%s\" was successfully added to the address book"), $contact_link), 'horde.success', array('content.raw'));
    }
    break;
}

$title = _("Thread View");
require IMP_TEMPLATES . '/common-header.inc';
$msgs = array();

require IMP_TEMPLATES . '/menu.inc';
IMP::status();

$threadob = $imp_mailbox->getThreadOb();
$thread = $threadob->getThread($imp_mailbox->getIndex());
$subject = '';
$page_label = IMP::getLabel();
$message_url = Horde::applicationUrl('message.php');
$mailbox_url = Horde::applicationUrl('mailbox.php');
foreach ($thread as $idx) {
    /* Set mailbox object to the message index. */
    $imp_mailbox->setNewIndex($idx);

    /* Get the body of the message. */
    $curr_msg = array();
    $contents = &IMP_Contents::singleton($idx);
    $mime_id = $contents->findBody();
    $mime_part = $contents->getDecodedMIMEPart($mime_id);
    if ($contents->canDisplayInline($mime_part)) {
        $curr_msg['body'] = $contents->renderMIMEPart($mime_part);
    } else {
        $curr_msg['body'] = '<em>' . _("There is no text that can be displayed inline.") . '</em>';
    }

    /* Get headers for the message. */
    $headers = &new IMP_Headers($idx);
    $headers->buildHeaders();
    $headers->buildFlags();
    $headers->setValueByFunction('date', array('nl2br', array($headers, 'addLocalTime'), 'htmlspecialchars'));
    $headers->buildAddressLinks('from', Horde::selfUrl(true), true, true);
    $curr_msg['date'] = $headers->getValue('date');
    $curr_msg['from'] = $headers->getValue('from');
    if (empty($subject)) {
        $subject = preg_replace('/^re:\s*/i', '', $headers->getValue('subject'));
    }

    /* Create links to current message and mailbox. */
    $curr_msg['link'] = Horde::widget(Util::addParameter($message_url, array('index' => $idx)), _("Go to Message"), 'widget', '', '', _("Go to Message"), true);
    $curr_msg['link'] .= ' | ' . Horde::widget(Util::addParameter($mailbox_url, array('start' => $imp_mailbox->getMessageIndex())), sprintf(_("Back to %s"), $page_label), 'widget', '', '', sprintf(_("Back to %s"), $page_label), true);

    $msgs[] = $curr_msg;
}

$template = &new Horde_Template();
$template->set('date_string', _("Date"), true);
$template->set('from_string', _("From"), true);
$template->set('messages', $msgs, true);

require IMP_TEMPLATES . '/thread/top.inc';
echo $template->fetch(IMP_TEMPLATES . '/thread/thread.html');
require IMP_TEMPLATES . '/thread/bottom.inc';

require $registry->get('templates', 'horde') . '/common-footer.inc';
