<form method="post" name="compose" enctype="multipart/form-data" action="<?php echo Util::addParameter(Horde::applicationUrl('compose.php'), 'uniq', base_convert(microtime(), 10, 36)) ?>">

<?php
$count = 0;
$i = 0;

$numerrors = 0;
if (isset($error) && is_array($error)) {
    $numerrors = count($error);
}
$errorsleft = $numerrors;

if ($numerrors > 0) {
    for ($k = 0; $k < count($error); $k++) {
        if (in_array(String::lower($error[$k][0], true), $ignoreall)) {
            $errorsleft--;
        }
    }
}
?>
<table width="100%" border="0" cellspacing="0" cellpadding="1">
  <tr class="header">
    <td colspan="8" class="header">
      <b>
<?php if ($errorsleft > 0): ?>
        <?php echo _("Spell Checker") ?> - <i><?php echo $errorsleft ?> <?php if ($errorsleft > 1) echo _("spelling errors"); else echo _("spelling error"); ?></i>
<?php else: ?>
        <?php echo _("Spell check complete") ?> - <?php echo _("No spelling errors") ?>
<?php endif; ?>
      </b>
    </td>
  </tr>
<?php
while (($count < $prefs->getValue('num_words')) && ($i < $numerrors)) {
    if (!isset($error) || !is_array($error)) {
        echo _("Spell check complete");
        break;
    }

    if (!in_array(String::lower($error[$i][0], true), $ignoreall)):
?>

  <tr class="item">
    <td class="item"><?php echo _("Correct") ?></td>
    <td colspan="3" nowrap="nowrap">
<?php

    $offset = $error[$i][1];
    $word = $error[$i][0];
    $alt = $error[$i][2];
    echo '<span style="color:#ff0000">"' . htmlspecialchars($word) . '"</span>';
    echo _(" in ");
    $context = _highlightError(htmlspecialchars($word), htmlspecialchars($f_currmsg), htmlspecialchars($offset));

    if (!empty($context)) {
        echo "<span class=\"fixed\">$context</span>";
    } else {
        echo _("none");
    }

?>

    </td>
    <td><b><i><?php echo _("Change"); ?></i></b></td>
    <td><b><i><?php echo _("Change All"); ?></i></b></td>
    <td><?php echo _("Ignore") ?></td>
    <td><?php echo _("Ignore All") ?></td>
  </tr>
  <tr>
    <td class="item"><b><?php echo _("Suggestions") ?></b></td>
    <td class="item">
      <input type="hidden" name="oldword[<?php echo $count ?>]" value="<?php echo htmlspecialchars($word) ?>" />
      <input type="hidden" name="wordoffset[<?php echo $count ?>]" value="<?php echo htmlspecialchars($offset) ?>" />
      <select name="subs[<?php echo $count ?>]" onchange="change_selected(<?php echo $count ?>);">
<?php

    if (!empty($alt)) {
        $checkedval = 3;
        $altwords = explode(', ', $alt);
        for ($j = 0; $j < count($altwords); $j++) {
            echo '<option value="' . htmlspecialchars($altwords[$j]) . '">' . htmlspecialchars($altwords[$j]) . '</option>';
        }
    } else {
        $checkedval = 3;
        echo '<option value="0">' . _("No suggestions") . '</option>';
    }

?></select>
    </td>
    <td class="item"><b><?php echo (!empty($alt)) ? _("or") : _("Replace with:"); ?></b></td>
    <td class="item"><input type="text" name="subtext[<?php echo $count ?>]" size="12" onchange="change_selected(<?php echo $count ?>);" /></td>
    <td class="item"><input type="radio" value="1" name="opt[<?php echo $count ?>]" <?php if ($checkedval == 1) echo 'checked="checked"'; ?> /></td>
    <td class="item"><input type="radio" value="2" name="opt[<?php echo $count ?>]" <?php if ($checkedval == 2) echo 'checked="checked"'; ?> /></td>
    <td class="item"><input type="radio" value="3" name="opt[<?php echo $count ?>]" <?php if ($checkedval == 3) echo 'checked="checked"'; ?> /></td>
    <td class="item"><input type="radio" value="4" name="opt[<?php echo $count ?>]" <?php if ($checkedval == 4) echo 'checked="checked"'; ?> /></td>
  </tr>
<?php
    $count++;
    endif;

    $i++;
}
?>
  <tr class="item">
    <td colspan="8" class="item">
      <input type="button" class="button" onclick="document.compose.actionID.value='spell_check_cancel'; document.compose.submit();" value="<?php echo _("Cancel") ?>" /><i>&nbsp;<?php echo _("(Discard all changes and return to the compose screen.)") ?></i>
    </td>
  </tr>
<?php if (($actionID == 'spell_check_forward') || ($errorsleft == 0)): ?>
  <tr class="item">
    <td colspan="8" class="item">
      <input type="button" class="button" onclick="document.compose.actionID.value='<?php echo $spell_check_done_action; ?>'; document.compose.submit();" value="<?php echo _("Done") ?>" /><i>&nbsp;<?php echo $spell_check_done_caption; ?></i>
    </td>
  </tr>
<?php endif; ?>
<?php if ($errorsleft > 0): ?>
  <tr class="item">
    <td colspan="8" class="item">
      <input type="button" class="button" onclick="document.compose.actionID.value='spell_check_forward'; document.compose.submit();" value="<?php echo _("Next") ?>" /><i>&nbsp;<?php echo _("(Apply these changes and move to next screen.)") ?></i>
    </td>
  </tr>
<?php endif; ?>
  <tr><td colspan="8">&nbsp;</td></tr>
  <tr class="header"><td colspan="8" class="header"><b><?php echo _("Corrected Text") ?></b></td></tr>
  <tr><td colspan="8" class="item">
    <div class="fixed"><?php echo $display_msg ?></div>
  </td></tr>
</table>

<!-- Maintain lots of state -->
<input type="hidden" name="actionID" value="" />
<input type="hidden" name="spellcheck" value="" />
<input type="hidden" name="done_action" value="<?php echo $f_done_action; ?>" />
<input type="hidden" name="messageCache" value="<?php echo Util::getFormData('messageCache') ?>" />
<input type="hidden" name="rtemode" value="<?php echo $rtemode ?>" />
<input type="hidden" name="popup" value="<?php echo htmlspecialchars(Util::getFormData('popup', '')); ?>" />
<input type="hidden" name="index" value="<?php if (isset($index)) echo htmlspecialchars($index) ?>" />
<?php if ($reply_type = Util::getFormData('reply_type')): ?>
<input type="hidden" name="reply_type" value="<?php echo $reply_type ?>" />
<?php endif; ?>
<?php if ($reply_type == 'reply'): ?>
<input type="hidden" name="in_reply_to" value="<?php echo htmlspecialchars($header['inreplyto']) ?>" />
<input type="hidden" name="references" value="<?php echo htmlspecialchars($header['references']) ?>" />
<?php endif; ?>
<input type="hidden" name="message" value="<?php echo htmlspecialchars($f_message) ?>" />
<input type="hidden" name="oldmsg" value="<?php echo htmlspecialchars($f_oldmsg) ?>" />
<input type="hidden" name="currmsg" value="<?php echo htmlspecialchars($f_currmsg) ?>" />
<input type="hidden" name="newmsg" value="<?php echo htmlspecialchars($f_newmsg) ?>" />
<input type="hidden" name="ignoreall" value="<?php echo htmlspecialchars(serialize($f_ignoreall)) ?>" />
<input type="hidden" name="changeall" value="<?php echo htmlspecialchars(Util::getFormData('changeall')) ?>" />
<input type="hidden" name="identity" value="<?php echo htmlspecialchars(Util::getFormData('identity')) ?>" />
<input type="hidden" name="from" value="<?php echo htmlspecialchars(Util::getFormData('from')) ?>" />
<input type="hidden" name="charset" value="<?php echo htmlspecialchars(Util::getFormData('charset')) ?>" />
<input type="hidden" name="subject" value="<?php echo htmlspecialchars($header['subject']) ?>" />
<?php if ($x_priority = Util::getFormData('x_priority')): ?>
<input type="hidden" name="x_priority" value="<?php echo htmlspecialchars($x_priority) ?>" />
<?php endif; ?>
<input type="hidden" name="reloaded" value="1" />
<?php if (($save_sent_mail = Util::getFormData('save_sent_mail')) == 'on'): ?>
<input type="hidden" name="save_sent_mail" value="on" />
<input type="hidden" name="sent_mail_folder" value="<?php echo htmlspecialchars($sent_mail_folder) ?>" />
<?php endif; ?>
<?php if (Util::getFormData('request_return_receipt') == 'on'): ?>
<input type="hidden" name="request_return_receipt" value="on" />
<?php endif; ?>

<!-- To: addresses -->
<?php if (!empty($f_to)): ?><input type="hidden" name="to" value="<?php echo htmlspecialchars(Util::getFormData('to')) ?>" /><?php endif; ?>
<?php if (!empty($f_to_new)): ?><input type="hidden" name="to_new" value="<?php echo htmlspecialchars(Util::getFormData('to_new')) ?>" /><?php endif; ?>
<?php if (!empty($f_to_list) && is_array($f_to_list)): ?>
<?php foreach ($f_to_list as $search => $found): ?>
<input type="hidden" name="to_list[<?php echo htmlspecialchars($search) ?>]" value="<?php echo htmlspecialchars($found) ?>" />
<?php if (isset($f_to_field) && isset($f_to_field[$search])): ?>
<input type="hidden" name="to_field[<?php echo htmlspecialchars($search) ?>]" value="<?php echo htmlspecialchars($f_to_field[$search]) ?>" />
<?php endif; ?>
<?php endforeach; ?>
<?php endif; ?>

<!-- Cc: addresses -->
<?php if (!empty($f_cc)): ?><input type="hidden" name="cc" value="<?php echo htmlspecialchars(Util::getFormData('cc')) ?>" /><?php endif; ?>
<?php if (!empty($f_cc_new)): ?><input type="hidden" name="cc_new" value="<?php echo htmlspecialchars(Util::getFormData('cc_new')) ?>" /><?php endif; ?>
<?php if (!empty($f_cc_list) && is_array($f_cc_list)): ?>
<?php foreach ($f_cc_list as $search => $found): ?>
<input type="hidden" name="cc_list[<?php echo htmlspecialchars($search) ?>]" value="<?php echo htmlspecialchars($found) ?>" />
<?php if (isset($f_cc_field) && isset($f_cc_field[$search])): ?>
<input type="hidden" name="cc_field[<?php echo htmlspecialchars($search) ?>]" value="<?php echo htmlspecialchars($f_cc_field[$search]) ?>" />
<?php endif; ?>
<?php endforeach; ?>
<?php endif; ?>

<!-- Bcc: addresses -->
<?php if (!empty($f_bcc)): ?><input type="hidden" name="bcc" value="<?php echo htmlspecialchars(Util::getFormData('bcc')) ?>" /><?php endif; ?>
<?php if (!empty($f_bcc_new)): ?><input type="hidden" name="bcc_new" value="<?php echo htmlspecialchars(Util::getFormData('bcc_new')) ?>" /><?php endif; ?>
<?php if (!empty($f_bcc_list) && is_array($f_bcc_list)): ?>
<?php foreach ($f_bcc_list as $search => $found): ?>
<input type="hidden" name="bcc_list[<?php echo htmlspecialchars($search) ?>]" value="<?php echo htmlspecialchars($found) ?>" />
<?php if (isset($f_bcc_field) && isset($f_bcc_field[$search])): ?>
<input type="hidden" name="bcc_field[<?php echo htmlspecialchars($search) ?>]" value="<?php echo htmlspecialchars($f_bcc_field[$search]) ?>" />
<?php endif; ?>
<?php endforeach; ?>
<?php endif; ?>

</form>
