<?php
/**
 * The IMP_Browser:: class provides capability information for the current
 * web client. It is adapted from horde/lib/Browser.php (version 1.87) for
 * use with IMP 3.2.
 *
 * $Horde: imp/lib/Browser.php,v 1.1.2.1 2003/02/04 21:33:12 slusarz Exp $
 *
 * Copyright 1999-2003 Chuck Hagenbuch <chuck@horde.org>
 * Copyright 1999-2003 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Chuck Hagenbuch <chuck@horde.org>
 * @author  Jon Parise <jon@horde.org>
 * @version $Revision: 1.1.2.1 $
 * @since   IMP 3.2
 * @package imp
 */
class IMP_Browser {

    /**
     * Outputs the headers for a browser download.
     * This version is updated from the function in horde/lib/Browser.php
     * (version 2.2+) to work better with more browsers.
     *
     * @access public
     *
     * @param optional string $filename  The filename of the download.
     * @param optional string $cType     The content-type description of the
     *                                   file.
     * @param optional boolean $inline   True if inline, false if attachment.
     * @param optional string $cLength   The content-length of this file.
     */
    function downloadHeaders($filename = 'unknown', $cType = null,
                             $inline = false, $cLength = null)
    {
        global $browser;

        /* Some browsers don't like spaces in the filename. */
        if ($browser->hasQuirk('no_filename_spaces')) {
            $filename = strtr($filename, ' ', '_');
        }

        /* MSIE doesn't like multiple periods in the file name. Convert
           all periods (except the last one) to underscores. */
        if ($browser->isBrowser('msie')) {
            if (($pos = strrpos($filename, '.'))) {
                $filename = strtr(substr($filename, 0, $pos), '.', '_') . substr($filename, $pos);
            }
        }

        /* Content-Type/Content-Disposition Header. */
        if ($inline) {
            if (!is_null($cType)) {
                header('Content-Type: ' . trim($cType));
            } elseif ($browser->isBrowser('msie')) {
                header('Content-Type: application/x-msdownload');
            } else {
                header('Content-Type: application/octet-stream');
            }
            header('Content-Disposition: inline; filename=' . $filename);
        } else {
            if ($browser->isBrowser('msie')) {
                header('Content-Type: application/x-msdownload');
            } elseif (!is_null($cType)) {
                header('Content-Type: ' . trim($cType));
            } else {
                header('Content-Type: application/octet-stream');
            }

            if ($browser->hasQuirk('break_disposition_header')) {
                header('Content-Disposition: filename=' . $filename);
            } else {
                header('Content-Disposition: attachment; filename=' . $filename);
            }
        }

        /* Content-Length Header. Don't send Content-Length for HTTP/1.1
           servers. */
        if (!is_null($cLength)) {
            if (!empty($_SERVER['SERVER_PROTOCOL'])) {
                $pos = strrpos($_SERVER['SERVER_PROTOCOL'], '/');
                if ($pos &&
                    substr($_SERVER['SERVER_PROTOCOL'], $pos + 1) != '1.1') {
                    header('Content-Length: ' . $cLength);
                }
            }
        }

        /* Overwrite Pragma: and other caching headers for IE. */
        if ($browser->hasQuirk('cache_ssl_downloads')) {
            header('Expires: 0');
            header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
            header('Pragma: public');
        }
    }

    /**
     * Returns a URL to be used for downloading, that takes into account
     * any special browser quirks (i.e. IE's broken filename handling).
     *
     * @access public
     *
     * @param string $filename        The filename of the download data.
     * @param optional array $params  Any additional parameters needed.
     *
     * @return string  The download URL.
     */
    function downloadUrl($filename, $params = array())
    {
        global $browser;
 
        $url = Horde::applicationUrl('download/');

        /* Add the filename to the end of the URL. Although not necessary
           for many browsers, this should allow every browser to download
           correctly. */
        $url = IMP::addParameter($url, 'fn=/' . rawurlencode($filename));

        /* Add other parameters. */
        if (!is_null($params)) {
            foreach ($params as $key => $val) {
                $url = IMP::addParameter($url, $key . '=' . $val);
            }
        }

        return $url;
    }

}
