<?php
// $Horde: imp/lib/Maintenance/Task/purge_trash.php,v 1.1.2.3 2002/06/05 22:47:24 jan Exp $

/**
* Maintenance module that purges old messages in the Trash folder.
*
* @author  Michael Slusarz <slusarz@bigworm.colorado.edu>
* @version $Revision: 1.1.2.3 $
* @since   IMP 2.3.7
* @package horde.maintenance
*/
class Maintenance_Task_purge_trash extends Maintenance_Task {

    /**
     * Purge old messages in the Trash folder.
     *
     * @access public
     *
     * @return boolean $status  Whether any messages were purged from the
     *                          Trash folder.
     */
    function doMaintenance()
    {
        global $imp, $prefs;

        /* Check to make sure Trash folder is being used by IMP. */
        if ($prefs->getValue('use_trash')) {

            /* Make sure the Trash folder exists. */
            require_once IMP_BASE . '/lib/Folder.php';
            if (IMP_Folder::exists($imp['stream'], IMP::addPreambleString($prefs->getValue('trash_folder')))) {

                /* Initialize purged messages counter. */
                $purge_count = 0;

                /* Get the current UNIX timestamp minus the number of days
                     specified in 'purge_trash_keep'.
                   If a message has a timestamp prior to this value, it
                     will be deleted. */
                $del_time = date("r", time() - ($prefs->getValue('purge_trash_keep') * 86400));

                /* Open the Trash mailbox and get the list of messages older
                   than 'purge_trash_keep' days. */
                $trash_stream = @imap_open(IMP::serverString() . IMP::addPreambleString($prefs->getValue('trash_folder')), $imp['user'], Secret::read(Secret::getKey('imp'), $imp['pass']));
                $msg_ids = imap_search($trash_stream, "BEFORE \"$del_time\"", SE_UID);

                /* Go through the message list and set the delete flag on all
                     messages. */
                if (!empty($msg_ids)) {
                    foreach ($msg_ids as $val) {
                        imap_delete($trash_stream, $val, FT_UID);
                        $purge_count++;
                    }
                }

                /* Only continue if there are messages to delete. */
                if ($purge_count) {

                    /* Output information message to user. */
                    Horde::raiseMessage(sprintf(_("Purging %d message(s) from Trash folder."), $purge_count), HORDE_MESSAGE);

                    /* Expunge messages from the mailbox now. */
                    imap_close($trash_stream, CL_EXPUNGE);

                    return true;

                }

                imap_close($trash_stream);

            }

        }

       return false;
    }

    /**
     * Return information for the maintenance function.
     *
     * @access public
     *
     * @return string $info  Description of what the operation is going to do
     *                       during this login.
     */
    function describeMaintenance()
    {
        global $prefs;

        return sprintf(_("All messages in your \"%s\" folder older than %s days will be permanently deleted."), $prefs->getValue('trash_folder'), $prefs->getValue('purge_trash_keep'));
    }

}
?>
