-- |This module is merely a test for the IDoc tool.
--

{- Even the header looks a bit strange
 - to see whether IDoc works well.
 -}

-- |Here we test some comment block formatting.  Comments can have different
-- types of paragraphs:
--
-- * Vanilla text
--
-- * Displays, which come in three flavours:
--
--   (1) ordered and unorder lists,
--
--   (2) verbatim code displays, and
--
--   (3) quoted  text
--

module Foo (
  Length
) where


-- |We represent length values by integers
--
type Length = Int

-- A useful local type declaration
--
type Bar = Int

-- |This is a cool function with quite a number of sophisticated arguments
--
myMostImpressiveFunctionEver :: (Ord a, Show a)		-- the context
			     => Int			-- the ID number
			     -> InputData
			     -> Bool			-- strict checking?
			     -> OutputData

-- |A well known data type
--
data Maybe a = Nothing	-- in case that there is no `a'
	     | Just a	-- when there is a value available

-- |This is the data structure that we process
--
data InputData
    --
    -- |The first variant is quite secret
    --
  = SecretData SomeSuperSecretData
    --
    -- |In comparison, this one is boring
    --
  | BoringData Int
    --
    -- |And somtimes, we just read a string
    --
  | StringData String

-- |Some overloading of our own
--
class MyClass a where

  -- |Transforms stuff
  --
  transform :: a -> a


-- |A large example taking from a C AST
-- ------------------------------------

-- |C declarator (K&R A8.5) and abstract declarator (K&R A8.8)
--
-- * We have one type qualifer list `[CTypeQual]' for each indirection (ie,
--   each occurrence of `*' in the concrete syntax).
--
-- * We unfold K&R's direct-declarators nonterminal into declarators.  Note
--   that `*(*x)' is equivalent to `**x'.
--
-- * Declarators (A8.5) and abstract declarators (A8.8) are represented in the 
--   same structure.  In the case of a declarator, the identifier in
--   `CVarDeclr' must be present; in an abstract declarator it misses.
--   `CVarDeclr Nothing ...' on its own is meaningless, it may only occur as
--   part of a larger type (ie, there must be a pointer, an array, or function
--   declarator around).
--
-- * The qualifiers list in a `CPtrDeclr' may not be empty.
--
-- * Old and new style function definitions are merged into a single case
--   `CFunDeclr'.  In case of an old style definition, the parameter list is
--   empty and the variadic flag is `False' (ie, the parameter names are not
--   stored in the tree).  Remember, a new style definition with no parameters 
--   requires a single `void' in the argument list (according to the standard).
--
-- * We unfold K&R's parameter-type-list nonterminal into the declarator
--   variant for functions.
--
data CDeclr = CVarDeclr (Maybe Ident)		-- declared identifier
		        Attrs
	    | CPtrDeclr [[CTypeQual]]		-- indirections (non-empty)
		        CDeclr
		        Attrs
            | CArrDeclr CDeclr
			(Maybe CExpr)		-- array size
			Attrs
	    | CFunDeclr CDeclr
			[CDecl]			-- *parameter* declarations
			Bool			-- is variadic?
			Attrs
