/* static.c
 * - Functions for sending static files
 * Copyright (c) 1999 Jack Moffitt, Barath Raghavan, and Alexander Havng
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#ifdef _WIN32
#include <win32config.h>
#else
#include <config.h>
#endif
#endif

#include "definitions.h"

#include <stdio.h>

#ifndef __USE_BSD
# define __USE_BSD
#endif
#include <string.h>

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <fcntl.h>

#ifdef _WIN32
#include <winsock.h>
#include <io.h>
#define read _read
#define write _write
#define close _close
#else
#include <dirent.h>
#include <sys/socket.h>
#include <netinet/in.h>
#endif 

#include "avl.h"
#include "threads.h"
#include "icetypes.h"
#include "icecast.h"
#include "utility.h"
#include "ice_string.h"
#include "static.h"
#include "log.h"
#include "match.h"
#include "sock.h"
#include "memory.h"
#include "http.h"
#include "avl_functions.h"
#include "vars.h"
#include "dir.h"

extern server_info_t info;

void
list_directory (connection_t *con, char *directory)
{
	int i = 0;
	dir_t *od = NULL;
	char *filename = get_template ("list_directory.html");
	char fullfilename[BUFSIZE*2], fullpath[BUFSIZE];
	struct stat st;
	avl_tree *variables = NULL;

	if (!directory || (ice_strlen (directory) < 6))
	{
		write_http_code_page (con, 400, "Bad Request");
		return;
	}

	sprintf (fullpath, "%s%c%s", info.staticdir ? info.staticdir : "", *directory ? '/' : '\0', &directory[6]);
	
	xa_debug (1, "DEBUG: [%s] Listing directory [%s]", con_host (con), fullpath);
	
	if (!(od = dir_findfirst (fullpath)))
	{
	    write_http_code_page (con, 404, "Not Found");
	    return;
	}

	if (filename)
	{
		xa_debug (1, "DEBUG: list_directory(): using template %s", filename);
		dir_findclose (od);
		variables = avl_create (compare_vars, &info);
		add_varpair2 (variables, nstrdup ("LISTED_DIRECTORY"), nstrdup (fullpath));
		write_template_parsed_html_page (con, NULL, filename, -1, variables);
		nfree (filename);
		return;
	} else {
		
		write_http_header (con->sock, 200, "OK");

		sock_write_line (con->sock, "Connection: close");
		sock_write_line (con->sock, "Content-Type: text/html\r\n");
		
		sock_write_line (con->sock, "<html><head><title>icecast server, version %s, running on %s</title></head>", VERSION, info.server_name);
		sock_write_line (con->sock, "<body bgcolor=black text=white link=lightblue alink=lightblue vlink=lightblue>");
		
		sock_write_line (con->sock, "<font face=\"sans-serif\" size=+2>Files in directory %s:</font><br>", directory);
		
		sock_write_line (con->sock, "<table border=0 cellspacing=0 cellpadding=3><tr><td><font face=\"sans-serif\" size=+2>Filename</font></td><td><font face=\"sans-serif\" size=+2>Filesize</font></td></tr><br>");
	}

	while (dir_findnext (od))
	{
		sprintf (fullfilename, "%s/%s", fullpath, od->filename);
		if ((stat (fullfilename, &st) == 0) && wild_match ((unsigned char *)"*.mp3", (unsigned char *)od->filename))
		{
			i % 2 ? sock_write_line (con->sock, "<tr bgcolor=#000000>") : sock_write_line (con->sock, "<tr bgcolor=#333333>");
			sock_write_line (con->sock, "<td><tt><a href=\"/playlist.pls?mount=/file/%s&file=dummy.pls\">%s</a></tt><td><tt>%d</tt></td></tr>", od->filename, od->filename,
					 st.st_size);
			i++;
		}
	}
	
	dir_findclose (od);
	
	sock_write_line (con->sock, "</table><br>");

	sock_write_line (con->sock, "Total files in directory: %d<br>", i);
	
	sock_write_line (con->sock, "</body></html>");
}

void 
send_file (connection_t *con, request_t *req)
{
	struct stat buf;
	int mp3file;
	char *filename;
	char *suffix;
	long length;
	char buff[BUFSIZE];
	char *decoded=url_decode(&req->path[6]);
#ifdef HAVE_LSEEK
	const char *startpos;
	int pos;
	vartree_t *req_vars = avl_create(compare_vars, &info);
	extract_vars(req_vars, req->path);
	startpos = get_variable(req_vars, "pos");
#endif

	memset(buff, 0, BUFSIZE);

	filename = strncpy(buff, info.staticdir, BUFSIZE);

#ifdef _WIN32
	if (info.staticdir[ice_strlen(info.staticdir) - 1] != '\\')
		filename = safe_strcat(buff, "\\", BUFSIZE);
#else
	if (info.staticdir[ice_strlen(info.staticdir) - 1] != '/')
		filename = safe_strcat(buff, "/", BUFSIZE);
#endif
	filename = safe_strcat(buff, decoded, BUFSIZE);
	nfree(decoded);
	xa_debug (1, "DEBUG: Static filename: %s...", filename);
	suffix = strrchr(filename, '.');

	if ((ice_strlen(filename) > 3) && (suffix && (ice_strcasecmp(suffix, ".mp3") == 0)) && (stat(filename, &buf) == 0)) {
		length = buf.st_size;

		/* Can't use fopen anymore.. it breaks with too many open files */
		if ((mp3file = open_for_reading (filename))) {
#ifdef HAVE_LSEEK
		    if (is_number(startpos)) { 
			   /* added by david@neongoat.com, 6/6/2000
			    *   http://localhost:8000/files/bigfile.mp3?pos=12345
			    *   will now start static file stream at offset 12345 in song
			    *   it is up to client to translate song hh:mm:ss into offset in bytes */
			   pos = atoi(startpos);
			   xa_debug (1, "DEBUG: send_file() startpos=%d, filelen=%d", pos, length);
			   lseek (mp3file, pos, SEEK_SET);
			   length -= pos;
		    }  
#endif
			  
			write_log(LOG_DEFAULT, "Sending static file %s to %d [%s]", filename, con->id, con_host(con));
			write_http_header(con->sock, 200, "OK");
			sock_write_line (con->sock, "Connection: close");
			sock_write_line (con->sock, "Content-type: audio/mpeg");
			sock_write_line (con->sock, "Content-length: %i\r\n", length);

			while ((length = read(mp3file, buff, BUFSIZE)) > 0)
			{
				sock_write_bytes(con->sock, buff, length);
				info.hourly_stats.write_bytes += length;
			}
			
			fd_close(mp3file);

		} else {
			xa_debug (1, "DEBUG: Static file doesn't exist");
			
			write_http_code_page (con, 404, "Not found");
			sock_write_line (con->sock, "Connection: close");
		}
	} else {
		xa_debug (1, "DEBUG: Static file [%s] invalid", filename);
		write_http_code_page (con, 404, "Not found");
		sock_write_line (con->sock, "Connection: close");
	}

#ifdef HAVE_LSEEK
	free_variables(req_vars);
#endif
}
