/* source.h
 * - Source Function Headers
 *
 * Copyright (c) 1999 Jack Moffitt, Barath Raghavan, and Alexander Havng
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __ICECAST_SOURCE_H
#define __ICECAST_SOURCE_H

source_t *create_source();
void source_login(connection_t *con, char *line);
void kick_source(source_t *sor, char *why);
void *source_func(void *con);
void put_source(connection_t *con);
void add_source ();
void del_source ();
connection_t *find_mount_with_req (request_t *req);
connection_t *get_default_mount();
void add_chunk (connection_t *sourcecon);
void write_chunk (source_t *source, connection_t *clicon);
void kick_clients_on_cid (source_t *source);
void kick_dead_clients (source_t *source);
void move_clients_to_default_mount (connection_t *con);
int originating_id (connection_t *sourcecon, char *dshost);
int write_data (connection_t *clicon, source_t *source);
int write_data_with_metadata (connection_t *clicon, source_t *source, int justnull);
void move_client (connection_t *clicon, source_t *source, int meta_at);
int finish_meta_frame (connection_t *clicon);
connection_t *get_source_with_mount (const char *mount);
connection_t *get_source_from_host (connection_t *con);
void describe_source (const com_request_t *req, const connection_t *sourcecon);
const char *sourceproto_to_string (protocol_t proto);
const char *sourcetype_to_string (source_type_t type);
int start_chunk (source_t *source);
connection_t *get_twin_mount (source_t *scon);
connection_t *get_twin_mount_wl (source_t *scon);
void move_to_smaller_twin (source_t *source, connection_t *clicon);
void source_sleep (source_t *source);
void source_write_to_client (source_t *source, connection_t *clicon);
void source_get_new_clients (source_t *source);
int source_get_id (char *arg);
#endif

