/* icecast.h
 * - Configuration Information
 *
 * Copyright (c) 1999 Jack Moffitt, Barath Raghavan, and Alexander Havng
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __ICECAST_CONFIG_H
#define __ICECAST_CONFIG_H

#ifdef _WIN32
#include "win32config.h"
#else
#include "config.h"
#endif

#define DEFAULT_TOUCH_FREQ 5
#define TIMEOUT 1

#define SERVER_RUNNING 1
#define SERVER_INITIALIZING 2
#define SERVER_DYING 0

/* Flags for the client_login() */
#define LIST_STREAMS -2

/* Flags for the console */
#define CONSOLE_ADMIN_TAIL 0
#define CONSOLE_ADMIN 1
#define CONSOLE_LOG 2
#define CONSOLE_BACKGROUND 3

/* Flags for the admin */
#define NONE 0
#define TAILING 1
#define OPER 2
#define OPER_TAILING 4

/* General return flags */
#define OK 1
#define UNKNOWN -1
#define ICE_ERROR_CONNECT -1
#define ICE_ERROR_INVALID_SYNTAX -2
#define ICE_ERROR_ARGUMENT_REQUIRED -3
#define ICE_ERROR_HEADER -4
#define ICE_ERROR_TRANSMISSION -5
#define ICE_ERROR_DUPLICATE -6
#define ICE_ERROR_FILE -7
#define ICE_ERROR_INVALID_PASSWORD -8
#define ICE_ERROR_NO_SUCH_MOUNT -9
#define ICE_ERROR_NULL -10
#define ICE_ERROR_NOT_FOUND -11
#define ICE_ERROR_INIT_FAILED -12
#define ICE_ERROR_INSERT_FAILED -13
#define ICE_ERROR_NOT_INITIALIZED -14

#define DEFAULT_THROTTLE 1.2
#define DEFAULT_SLEEP_RATIO 0.25
#define DEFAULT_MOUNT_FALLBACK 1
#define DEFAULT_FORCE_SERVERNAME 0
#define DEFAULT_SOURCE_OPTS "istphecyocdrlumnagbUMDRWCT"
#define DEFAULT_BODY_TAG "<body bgcolor=black text=white link=blue alink=red>" /* This is just for the internally created pages.. use templates instead */
#define DEFAULT_ICE_ROOT "."
#define DEFAULT_METADATA_INTERVAL 8192
#define DEFAULT_UDP_UPDATE_TIME 10
#define DEFAULT_STREAM_TITLE ""
#define DEFAULT_USE_META_DATA 0
#define DEFAULT_STREAM_URL "http://www.icecast.org/"
#define DEFAULT_ACL_POLICY 1 /* 1 means allow, 0 deny */
#define DEFAULT_ALLOW_HTTP_ADMIN 1
#define DEFAULT_CLIENT_TIMEOUT 30
#define DEFAULT_LOOKUPS 1 /* Always reverse lookup hostnames */
#define DEFAULT_PORT 8000

#ifdef SOMAXCONN
#define LISTEN_QUEUE SOMAXCONN
#else
#define LISTEN_QUEUE 50
#endif

#define DEFAULT_MAX_CLIENTS 800
#define DEFAULT_MAX_CLIENTS_PER_SOURCE 800
#define DEFAULT_MAX_SOURCES 5
#define DEFAULT_MAX_ADMINS 5
#define DEFAULT_MAX_DIRECTORIES 50
#define DEFAULT_ENCODER_PASSWORD "letmein"
#define DEFAULT_OPER_PASSWORD "breakin"
#define DEFAULT_CLIENT_PASSWORD "prettyplease"
#define DEFAULT_DIRECTORY_SERVER "yp.icecast.org"
#define DEFAULT_YP_TOUCH "cgi-bin/touch"
#define DEFAULT_LOGFILE "icecast.log"
#define DEFAULT_USAGE_FILE "usage.log"
#define DEFAULT_ACCESS_FILE "access.log"
#define DEFAULT_REMOTE_ADMIN_PASSWORD "letmein"
#define DEFAULT_REDIRECTION 0
#define DEFAULT_REDIRECTION_HOST "ike.linuxpower.org"
#define DEFAULT_REDIRECTION_PORT 8000
#define DEFAULT_REDIRECTION_RETRIES 5
#define DEFAULT_STATIC_DIR ICECAST_STATICDIR
#define DEFAULT_LOG_DIR ICECAST_LOGDIR
#define DEFAULT_ETC_DIR ICECAST_ETCDIR
#define DEFAULT_TEMPLATE_DIR ICECAST_TEMPLATEDIR
#define DEFAULT_CONFIG_FILE "icecast.conf"
#define DEFAULT_USER_FILE "users.aut"
#define DEFAULT_GROUP_FILE "groups.aut"
#define DEFAULT_MOUNT_FILE "mounts.aut"
#define DEFAULT_STATSFILE "stats.log"
#define DEFAULT_STATSHTMLFILE "stats.html"
#define DEFAULT_STATSTIME 120
#define DEFAULT_STATUSTIME 120
#define DEFAULT_LOCATION "Tellus, Sol, Milkyway"
#define DEFAULT_RP_EMAIL "unset@unset.org"
#define DEFAULT_SERVER_URL "http://www.icecast.org"
#define DEFAULT_TRANSPARENT_PROXY 0
#define DEFAULT_KICK_RELAYS 10    /* Kick relays after this many seconds without clients */
#define DEFAULT_RELAY_RECONNECT_TIME 90
#define DEFAULT_RELAY_RECONNECT_TRIES -1
#define DEFAULT_KICK_CLIENTS 0

/* Default values for what resolv method to use */
#if defined (SOLARIS) && defined (HAVE_GETHOSTBYNAME_R) && defined (HAVE_GETHOSTBYADDR_R)
# define DEFAULT_RESOLV_TYPE solaris_gethostbyname_r_e
# define SOLARIS_RESOLV_OK 1
#elif defined (LINUX) && defined (HAVE_GETHOSTBYNAME_R) && defined (HAVE_GETHOSTBYADDR_R)
# define DEFAULT_RESOLV_TYPE linux_gethostbyname_r_e
# define LINUX_RESOLV_OK 1
#else
# define DEFAULT_RESOLV_TYPE standard_gethostbyname_e
# define DEFAULT_RESOLV_OK 1
#endif

#define DEFAULT_STREAMTITLE_TEMPLATE "%s"
#define DEFAULT_NAME_TEMPLATE "%s"
#define DEFAULT_DESC_TEMPLATE "%s"

#define SOCK_UNUSED -1
#define SOCK_SIGNOFF -2

/* Flags for source->connected */
#define SOURCE_KILLED 0
#define SOURCE_CONNECTED 1
#define SOURCE_UNUSED 2
#define SOURCE_PAUSED 3
#define SOURCE_PENDING 4

#define CLIENT_ALIVE 1
#define CLIENT_DEAD 0
#define CLIENT_PAUSED 3
#define CLIENT_UNPAUSED 4
#define CLIENT_MOVE 5

/* Define these if you want a mess on the screen */
#undef DEBUG_MEMORY
#undef DEBUG_MEMORY_MCHECK 
#undef DEBUG_MUTEXES
#undef DEBUG_SOCKETS
#undef DEBUG_SLEEP
#undef DEBUG_FULL 

/* Optimization flags */
#undef OPTIMIZE
#undef SAVE_CPU

/* Flags for write_log () */
#define LOG_DEFAULT 0
#define LOG_USAGE 1
#define LOG_ACCESS 2

#endif
