/* directory.h
 * - Directory Server Function Headers
 *
 * Copyright (c) 1999 Jack Moffitt, Barath Raghavan, and Alexander Havng
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef _ICECAST_DIRECTORY_H
#define _ICECAST_DIRECTORY_H

void directory_add(directory_server_t *ds);
void directory_touch(directory_server_t *ds);
void directory_touch_xa (directory_server_t *ds);
void directory_remove(directory_server_t *ds);
void avl_touch_directory(void *data, void *param);
void update_stream_id (char *dshost, char *mountpoint, int id);
void free_directory_servers ();
#endif
