/* dir.c
 * - Directory Functions
 *
 * Copyright (c) 1999 Jack Moffitt, Barath Raghavan, and Alexander Havng
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#ifdef _WIN32
#include <win32config.h>
#else
#include <config.h>
#endif
#endif

#include "definitions.h"

#include <stdio.h>
#include <stdlib.h>
#ifndef __USE_BSD
#define __USE_BSD
#endif
#ifndef __EXTENSIONS__
#define __EXTENSIONS__
#endif
#include <string.h>
#include <sys/types.h>
#include <ctype.h>
#include <time.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef _WIN32
#include <io.h>
#else
#include <dirent.h>
#endif

#include "dir.h"
#include "memory.h"

dir_t *
dir_findfirst (const char *name)
{
	dir_t *dir;
	
	dir = (dir_t *)nmalloc(sizeof(dir_t));
#ifdef _WIN32
	dir->HDIR = _findfirst("*.*", dir->directory);
	dir->first = 1;

	if (dir->HDIR == -1) { 
		nfree(dir);
		dir = NULL;
	}
#else
	dir->directory = opendir(name);

	if (dir->directory == NULL) {
		nfree(dir);
		dir = NULL;
	}
#endif
	return dir;
}

int 
dir_findnext (dir_t *dir)
{
	int result = 1;

#ifdef _WIN32
	if (dir->first) {
		dir->filename = dir->directory->name;
		dir->first = 0;
	} else {
		if (_findnext(dir->HDIR, dir->directory)) {
			dir->filename = dir->directory->name;
		} else {
			result = 0;
		}
	}
#else
	dir->entry = readdir(dir->directory);
	dir->filename = dir->entry->d_name;
	if (dir->entry == NULL) 
		result = 0;
#endif

	return result;
}

int 
dir_findclose (dir_t *dir)
{
	int result;

#ifdef _WIN32
	result = _findclose(dir->HDIR);
#else
	result = closedir(dir->directory);
#endif
	nfree(dir);

	return result;
}


