/*
** WARNING!!! Don't muck with this file unless you know what you are
**            getting yourself into!!!!!!
*/

/* 
** Below are the messages used within hypermail that 
** are for user consumption. There are differences
** between user message strings and strings used in
** the HTML and SMTP protocols. Beware not to get
** confused with which is which.
** 
** What follows are a set of defines that act as indices 
** into the specific language array that is setup for
** this list archive. They need to point to the right
** messages in the language arrays or things get interesting.
**
** To add a new language, simply copy an existing language
** array and make the appropriate translations. For example,
** the Spanish language message array has the English message
** as the comment on the side of the message. (It is hoped
** this makes for easier translations... Also make sure and
** add the language to the supported_languages array.
**
** Currently this does not support wide-characters but it is
** a start in the right direction.  
*/

struct language_entry {
    char     *langcode;
    char     **mtable;
    char     *locale_code;
};

/* print.c */
#define MSG_NEW_MESSAGE            0
#define MSG_REPLY                  1
#define MSG_ABOUT_THIS_LIST        2
#define MSG_END_OF_MESSAGES        3
#define MSG_START_OF_MESSAGES      4
#define MSG_DATE_VIEW              5
#define MSG_THREAD_VIEW            6
#define MSG_SUBJECT_VIEW           7
#define MSG_AUTHOR_VIEW            8
#define MSG_OTHER_GROUPS           9
#define MSG_MESSAGES              10
#define MSG_STARTING              11
#define MSG_ENDING                12
#define MSG_ABOUT_THIS_ARCHIVE    13
#define MSG_SORTED_BY             14
#define MSG_OTHER_MAIL_ARCHIVES   15
#define MSG_BY_DATE               16
#define MSG_MOST_RECENT_MESSAGES  17
#define MSG_AUTHOR                18
#define MSG_DATE                  19
#define MSG_THREAD                20
#define MSG_SUBJECT               21
#define MSG_FOR_OPTIONS           22
#define MSG_WRITING_ARTICLES      23
#define MSG_WRITING_DATE_INDEX    24
#define MSG_WRITING_THREAD_INDEX  25
#define MSG_WRITING_SUBJECT_INDEX 26
#define MSG_WRITING_AUTHOR_INDEX  27
#define MSG_LAST_MESSAGE_DATE     28
#define MSG_ARCHIVED_ON           29
#define MSG_CANNOT_CHMOD          30
#define MSG_COULD_NOT_WRITE       31
#define MSG_NEXT_MESSAGE          32
#define MSG_PREVIOUS_MESSAGE      33
#define MSG_MAYBE_IN_REPLY_TO     34
#define MSG_IN_REPLY_TO           35
#define MSG_NEXT_IN_THREAD        36
#define MSG_MAYBE_REPLY           37
#define MSG_BY_THREAD             38
#define MSG_BY_SUBJECT            39
#define MSG_BY_AUTHOR             40

/* file.c */
#define MSG_CANNOT_CREATE_DIRECTORY   41
#define MSG_CREATING_DIRECTORY        42
#define MSG_CONFIGURATION_VALUES      43
#define MSG_PATH                      44

/* mem.c */
#define MSG_RAN_OUT_OF_MEMORY         45

/* printfile.c */
#define MSG_ARCHIVE_GENERATED_BY      46

/* struct.c */
#define MSG_ELEMENTS                  47
#define MSG_NO_ELEMENTS               48

/* parse.c */
#define MSG_CANNOT_OPEN_MAIL_ARCHIVE  49
#define MSG_READING_NEW_HEADER        50
#define MSG_LOADING_MAILBOX           51
#define MSG_ENCODING_IS_NOT_SUPPORTED 52
#define MSG_ARTICLES                  53

/* hypermail.c */
#define MSG_VERSION                              54
#define MSG_PATCHLEVEL                           55
#define MSG_DOCS                                 56
#define MSG_COMMAND_AND_CONTROL_VARIABLES        57
#define MSG_YES                                  58
#define MSG_NO                                   59
#define MSG_ABOUT_THE_ARCHIVE_NOT_USED           60
#define MSG_OTHER_ARCHIVES_NOT_USED              61
#define MSG_ADDRESS_NOT_USED                     62
#define MSG_BUILTIN_BODY_STATEMENT_USED          63
#define MSG_CANNOT_READ_FROM_BOTH_FILE_AND_STDIN 64
#define MSG_OPTIONS                              65
#define MSG_OPTION_A                             66
#define MSG_OPTION_B                             67
#define MSG_OPTION_C                             68
#define MSG_OPTION_D                             69
#define MSG_OPTION_I                             70
#define MSG_OPTION_L                             71
#define MSG_OPTION_M                             72
#define MSG_OPTION_P                             73
#define MSG_OPTION_VERBOSE                       74
#define MSG_OPTION_VERSION                       75
#define MSG_OPTION_U                             76
#define MSG_OPTION_X                             77
#define MSG_OPTION_LANG                          78
#define MSG_USAGE                                79
#define MSG_LANGUAGE_NOT_SUPPORTED               80
#define MSG_NOT_SET                              81
#define MSG_NOT_USED                             82
#define MSG_CREATED_ATTACHMENT_FILE              83
#define MSG_ATTACHMENT                           84
#define MSG_MODE                                 85
#define MSG_READING_OLD_HEADERS                  86
#define MSG_OPTIONS_STRING2                      87
#define MSG_ERROR                                88
#define MSG_OPTION_N                             89
#define MSG_OPTION_1                             90
#define MSG_CAUTHOR                		 91
#define MSG_CDATE                  		 92
#define MSG_CSUBJECT               		 93

/* print.c This belong in the first list, but it's quite a lot of work
   to move all the numbers to add them there :-/ How can we simplify
   this work? Jose */
#define MSG_MAIL_ACTIONS                         94
#define MSG_MA_NEW_MESSAGE                       95
#define MSG_MA_REPLY                             96

#define MSG_MONTHLY_INDEX                        97
#define MSG_YEARLY_INDEX                         98

#define MSG_OPTION_G                             99
#define MSG_OPTION_G_NOT_BUILD_IN                100
#define MSG_CREATING_GDBM_INDEX                  101
#define MSG_CANT_CREATE_GDBM_INDEX               102
#define MSG_OPTION_ARCHIVE                       103
#define MSG_CANNOT_BOTH_READ_AND_WRITE_TO_MBOX   104

/* XXX Move these up with the others */
#define MSG_ATTACHMENT_VIEW			 105
#define MSG_BY_ATTACHMENT			 106
#define MSG_WRITING_ATTACHMENT_INDEX  		 107
#define MSG_BYTES                                108

#define MSG_CANNOT_CREATE_SYMLINK                109
#define MSG_CANNOT_UNLINK                        110
#define MSG_PREV_DIRECTORY                       111
#define MSG_NEXT_DIRECTORY                       112
#define MSG_FOLDERS_INDEX                        113
#define MSG_DELETED                              114
#define MSG_EXPIRED                              115
#define MSG_DEL_SHORT                            116
#define MSG_TXT_VERSION                          117
#define MSG_FILTERED_OUT                         118
#define MSG_FROM                                 119

#define MSG_OPTION_XML				 120
#define MSG_WRITING_HAOF			 121

#ifdef MAIN_FILE

/*
** German version of the language table
** Translation by Martin Schulze <joey@kuolema.Infodrom.North.DE> 
*/

char *de[] = {       /* German */
  "Neue Nachricht",                       /* New Message        -HTML*/
  "Antwort",                              /* Reply              -HTML*/
  "ber diese Liste",                  /* About this list    -HTML*/
  "Ende der Nachricht",                   /* End of Messages    -HTML*/
  "Anfang der Nachricht",                 /* Start of Messages  -HTML*/
  "Datumsansicht",                         /* Date view          -HTML*/
  "Themenansicht",                         /* Thread view        -HTML*/
  "Titelansicht",                        /* Subject view       -HTML*/
  "Autorenansicht",                          /* Author view        -HTML*/
  "Weitere Gruppen",                      /* Other groups       -HTML*/
  "Nachrichten",                          /* Messages           -HTML*/
  "Anfang",                               /* Starting           -HTML*/
  "Ende",                                 /* Ending             -HTML*/
  "ber dieses Archiv",                /* About this archive -HTML*/
  "sortiert nach",            /* sorted by -HTML*/
  "Weitere Mail-Archive",                 /* Other mail archives -HTML*/
  "Datum",                                /* By Date             -HTML*/
  "Neueste Nachrichten",                  /* Most recent messages-HTML*/
  "Autor",                                /* author              -HTML*/
  "Datum",                                /* date                -HTML*/
  "Themenstrang",                               /* thread              -HTML*/
  "Titel",                              /* subject             -HTML*/
  "fr Optionen",                      /* for options       -STDOUT*/
  "Schreibe Nachrichten in",              /* Writing messages to-STDOUT*/
  "Schreibe Datums-Index in",             /* Writing date index to-STDOUT*/
  "Schreibe Themenstrang-Index in",       /* Writing thread index to -STDOUT*/
  "Schreibe Titel-Index in",            /* Writing subject index to-STDOUT*/
  "Schreibe Autoren-Index in",            /* Writing author index to-STDOUT*/
  "Letztes Datum",                        /* Last message date   -HTML*/
  "Archiviert auf",                       /* Archived on         -HTML*/
  "Kann Dateimodus nicht ndern",      /* Can not chmod     -STDERR*/
  "Kann nicht schreiben",                 /* Could not write   -STDERR*/
  "Nchste Nachricht",                 /* Next message        -HTML*/
  "Vorherige Nachricht",                  /* Previous message    -HTML*/
  "Vielleicht als Antwort auf",           /* Maybe in reply to   -HTML*/
  "Als Antwort auf",                      /* In reply to         -HTML*/
  "Nchste zum Thema",           	  /* Next in thread      -HTML*/
  "Eventuelle Antwort",                   /* Maybe reply         -HTML*/
  "Nach Thread",                          /* By Thread           -HTML*/
  "Nach Titel",                         /* By Subject          -HTML*/
  "Nach Autor",                           /* By Author           -HTML*/
  "Kann das Verzeichnis nicht erstellen", /* Can not create directory -STDERR*/
  "Erstelle Verzeichnis",                 /* Creating directory -STDOUT*/
  "Konfiguration",                        /* Configuration Values -STDOUT*/
  "Pfad",                                 /* path              -STDOUT*/
  "Kein Speicher mehr!",                  /* Ran out of memory!-STDERR*/
  "Dieses Archiv wurde generiert von",    /* This archive was generated by-HTML*/
  "Elemente",                             /* Elements          -STDOUT*/
  "Keine Elemente",                       /* No Elements       -STDOUT*/
  "Kann E-Mail-Archiv nicht ffnen",     /* Cannot open mail archive */
  "Lese neue Kopfzeilen...",                  /* Reading new header...-STDOUT*/
  "Lade Mailbox",                         /* Loading mailbox      -STDOUT*/
  "Kodierung wird nicht untersttzt, speichere so", 
                        /* encoding is not supported, stored as-is -HTML*/
  "Nachrichten",                          /* messages             -HTML*/
  "Version",                              /* Version            -STDOUT*/
  "Patchlevel",                           /* Patchlevel         -STDOUT*/
  "Dokus",                                /* Docs               -STDOUT*/
  "Befehls- und Kontrollvariablen",       /* Command and Control Variables-STDOUT*/
  "Ja",                                   /* Yes                -STDOUT*/
  "Nein",                                 /* No                 -STDOUT*/
  "ber das Archiv: nicht benutzt",    /* About the archive: not used-STDOUT */
  "Andere Archive: nicht benutzt",        /* Other archives: not used-STDOUT*/
  "Adresse nicht benutzt",                /* address not used        -STDOUT*/
  "Eingebautes <BODY> benutzt",           /* Builtin <BODY> statement used-STDOUT*/
  "Kann nicht gleichzeitig von Datei und Standardeingabe lesen.", 
  			   /* Cannot read from both file and stdin. -STDERR*/
  "Optionen",                             /* Options                -STDOUT*/
  "URL fr weitere Archive",              /* URL to other archives  -STDOUT*/
  "URL fr Informationen ber Archiv",  
                                      /* URL to archive information -STDOUT*/
  "Konfigurationsdatei zum Einlesen", 
                                    /* Configuration file to read in -STDOUT*/
  "Das Verzeichnis, um die HTML-Dateien zu speichern", 
                              /* The directory to save HTML files in -STDOUT*/
  "Lese Nachrichten von der Standardeingabe",
                                /* Read messages from standard input -STDOUT*/
  "Wie soll das Archiv genannt werden",   
                                  /* What to name the output archive -STDOUT*/
  "Mail-Archive zum Einlesen",            /* Mail archive to read in -STDOUT*/
  "Zeige Zwischenbericht",                /* Show progress           -STDOUT*/
  "Zeigt nur die Konfigurationsvariablen", /* Show configuration variables only -STDOUT*/
  "Zeigt Version und beende",             /* Show version information and exit -STDOUT*/
  "Jeweils einen Artikel hinzufgen",  /* Update archive by one article -STDOUT*/
  "Vorherige Nachrichten berschreiben", /* Overwrite previous messages -STDOUT*/
  "Sprache angeben",                      /* Specify language to use -STDOUT*/
  "Anleitung",                                /* Usage -STDOUT*/
  "Die Sprache wird nicht untersttzt",/* Language not supported  -STDERR*/
  "Nicht gesetzt",                        /* Not set               -STDOUT*/
  "Nicht benutzt",                        /* Not used              -STDOUT*/
  "Anhang in Datei gespeichert",           /* Created attachment file -STDOUT*/
  "Anhang",                          /* attachment           -HTML*/
  "Modus",                                 /* mode                 -STDOUT*/
  "Lese alte Kopfzeilen",                     /* Reading old headers  -STDOUT*/
  "",       /* for alignment only -STDOUT*/
  "FEHLER",                       /* ERROR                       -STDERR*/
  "Einsendeadresse fr die Liste", 
                           /* The submission address of the list-STDERR*/
  "Lese nur eine E-Mail aus der Eingabe",
  "Autor",                                /* author              -HTML*/
  "Datum",                                /* date                -HTML*/
  "Titel",                                /* subject             -HTML*/
  "Aktionsmglichkeiten",                 /* Mail actions (MA) header -HTML*/
  "Sende E-Mail mit neuen Titel",         /* MA New Message      -HTML*/
  "Antworte auf die E-Mail",              /* MA Reply            -HTML*/
  "Zusammenfassung der monatlichen Index-Dateien", 
  					  /* monthly             -HTML*/
  "Zusammenfassung der jhrlichen Index-Dateien",        
  					  /* yearly              -HTML*/
  "Lege GDBM-Zwischenspeicher fr Kopfzeilen an", 
  				/* Build a GDBM header cache   -STDOUT*/
  "GDBM-Zwischenspeicher-Option nicht eingebaut",  
  		     /* GDBM header cache option not build in  -STDERR*/
  "Erstelle Gdbm Index... ",    /* Creating gdbm index         -STDOUT*/
  "Kann Gdbm Datei nicht erstellen... ",  
  				/* Can't create gdbm index     -STDOUT*/
  "Pflege ein zustzliches mbox-Archiv", /* Maintain an mbox archive -STDOUT*/
  "Can't both read from and write to an mbox.", 
  	       /* "Can't both read from and write to an mbox." -STDOUT*/
  "Anhnge-bersicht",                      /* Attachment view       -HTML*/
  "Nach Nachtrichten mit Anhang",/* By messages with attachments -HTML*/
  "Schreibe Anhang-Index in",	/* Writing attachment index to -STDOUT*/
  "Bytes",		    /* file size, so far only for attachments  -HTML */
  "Kann symoblischen Verweis nicht erstellen.", 
  			     /* MSG_CANNOT_CREATE_SYMLINK     -STDOUT */
  "Kann Datei nicht entfernen", /* MSG_CANNOT_UNLINK          -STDOUT */
  "Vorheriges Verzeichnis",              /* MSG_PREV_DIRECTORY  -HTML */
  "Nchsts Verzeichnis",                 /* MSG_NEXT_DIRECTORY  -HTML */
  "Verzeichnisliste",  /* MSG_FOLDERS_INDEX                     -HTML */
  "Dies Nachricht wurde auf dem Archiv entfernt",/* MSG_DELETED -HTML */
  "Diese Nachricht ist abgelaufen",              /* MSG_EXPIRED -HTML */
  "(gelschte Nachricht)",          /* MSG_DEL_SHORT            -HTML */
  "Ursprnglicher Text dieser Nachricht", /* MSG_TXT_VERSION    -HTML */
  "Diese Nachricht wurde herausgefiltert",  /* MSG_FILTERED_OUT -HTML */
  "Autor",                              /* MSG_FROM              -HTML*/
  "Erstelle haof XML Dateien",  /* Write hoaf XML files       -STDOUT */
  "Schreibe Hoaf in",           /* Writing haof to               -HTML*/
  NULL,                              /* End Of Message Table - NOWHERE*/
};

/*
** Polish version of the language table (Polska wersja tabeli jzykowej)
** Translation by Adam T. Tkocz <adam@storm.pl>
*/

char *pl[] = {                      /* English */
  "Nowa wiadomo",                 /* New Message        -HTML*/
  "Odpowiedz",                      /* Reply              -HTML*/
  "O tej licie",                   /* About this list    -HTML*/
  "D strony",                     /* End of Messages    -HTML*/
  "Gra strony",                    /* Start of Messages  -HTML*/
  "Wg daty",                        /* Date view          -HTML*/
  "Wg wtkw",                      /* Thread view        -HTML*/
  "Wg tematw",                     /* Subject view       -HTML*/
  "Wg autorw",                     /* Author view        -HTML*/
  "Inne grupy",                     /* Other groups       -HTML*/
  "Wiadomoci",                     /* Messages           -HTML*/
  "Pocztek",                       /* Starting           -HTML*/
  "Koniec",                         /* Ending             -HTML*/
  "O tym archiwum",                 /* About this archive -HTML*/
  "sortowane wg",                   /* Messages sorted by -HTML*/
  "Inne archiwa maili",             /* Other mail archives -HTML*/
  "Wg daty",                        /* By Date             -HTML*/
  "Najwiesze wiadomoci",         /* Most recent messages-HTML*/
  "autora",                         /* author              -HTML*/
  "datay",                          /* date                -HTML*/
  "wtku",                          /* thread              -HTML*/
  "tematu",                         /* subject             -HTML*/
  "Dla opcji",                      /* for options       -STDOUT*/
  "Zapisywanie wiadomoci do",      /* Writing messages to-STDOUT*/
  "Zapisywanie indeksu dat do",     /* Writing date index to-STDOUT*/
  "Zapisywanie indeksu wtkw do",  /* Writing thread index to -STDOUT*/
  "Zapisywanie indeksu tematw do", /* Writing subject index to-STDOUT*/
  "Zapisywanie indeksu autorw do", /* Writing author index to-STDOUT*/
  "Data ostatniej wiadomoci",      /* Last message date   -HTML*/
  "Zarchiwizowane w",               /* Archived on         -HTML*/
  "Niedozwolone chmod",             /* Can not chmod     -STDERR*/
  "Nie mona zapisa",              /* Could not write   -STDERR*/
  "Nastpna wiadomo",             /* Next message        -HTML*/
  "Poprzednia wiadomo",           /* Previous message    -HTML*/
  "Przypuszczalnie w odpowiedzi na",/* Maybe in reply to   -HTML*/
  "W odpowiedzi na",                /* In reply to         -HTML*/
  "Nastpna w wtku",               /* Next in thread      -HTML*/
  "Prawdopodobna odpowied",        /* Maybe reply         -HTML*/
  "Wg wtku",                       /* By Thread           -HTML*/
  "Wg tematu",                      /* By Subject          -HTML*/
  "Wg autora",                      /* By Author           -HTML*/
  "Nie mona stworzy katalogu",    /* Can not create directory -STDERR*/
  "Tworzenie katalogu",             /* Creating directory -STDOUT*/
  "Parametry konfiguracji",         /* Configuration Values -STDOUT*/
  "cieka",                        /* path              -STDOUT*/
  "Przekroczona pami!",           /* Ran out of memory!-STDERR*/
  "To archiwum zostao wygenerowane przez",  /* This archive was generated by -HTML*/
  "Elementy",                       /* Elements          -STDOUT*/
  "adnych elementw",              /* No Elements       -STDOUT*/
  "Nie mona otworzy archiwum",    /* Cannot open mail archive */
  "Czytanie nowego nagwka",       /* Reading new header... -STDOUT   */
  "adowanie mailboxa",             /* Loading mailbox      -STDOUT  */
  "kodowanie nie jest obsugiwane", /* encoding is not supported, stored as-is -HTML*/
  "wiadomoci",                     /* messages             -HTML*/
  "Wersja",                         /* Version            -STDOUT*/
  "Wersja aty",                    /* Patchlevel         -STDOUT*/
  "Dokumentacja",                   /* Docs               -STDOUT*/
  "Polecenia i zmienne",            /* Command and Control Variables-STDOUT*/
  "Tak",                            /* Yes                -STDOUT*/
  "Nie",                            /* No                 -STDOUT*/
  "O tym archiwum: nie uywane",    /* About the archive: not used-STDOUT */
  "Inne archiwa: nie uywane",      /* Other archives: not used-STDOUT*/
  "adres nie zosta uyty",         /* address not used -STDOUT*/
  "Wbudowane <BODY> zostao uyte", /* Builtin <BODY> statement used-STDOUT*/
  "Nie mona odczyta pliku ani stdin.", /* Cannot read from both file and stdin. -STDERR*/
  "Opcje",                          /* Options                -STDOUT*/
  "URL do innych arciww",          /* URL to other archives  -STDOUT*/
  "URL do informacji o archiwum",   /* URL to archive information -STDOUT*/
  "Plik konfiguracyjny do wczytania", /* Configuration file to read in -STDOUT*/
  "Katalog do zapisu plikw HTML",  /* The directory to save HTML files in -STDOUT*/
  "Czytaj wiadomoci z stdin",      /* Read messages from standard input -STDOUT*/
  "Podaj nazw archiwum",           /* What to name the output archive -STDOUT*/
  "Archiwum do wczytania",          /* Mail archive to read in -STDOUT*/
  "Poka postpy",                  /* Show progress           -STDOUT*/
  "Poka tylko zmienne konfiguracyjne", /* Show configuration variables only -STDOUT*/
  "Poka wersj i wyjd",           /* Show version information and exit -STDOUT*/
  "Uzupelnij archiwum o jedn wiadomo", /* Update archive by one article -STDOUT*/
  "Zastp poprzednia wiadomo",    /* Overwrite previous messages -STDOUT*/
  "Wybierz uywany jzyk",          /* Specify language to use     -STDOUT*/
  "Uycie",                         /* Usage                       -STDOUT*/
  "Jzyk nie jest wspierany",       /* Language not supported  -STDERR*/
  "Nie ustawione",                  /* Not set     -STDOUT*/
  "Nie uywane",                    /* Not used  -STDOUT*/
  "Stworzono zacznik",            /* Created attachment file     -STDOUT*/
  "zacznik",                      /* attachment                    -HTML*/
  "tryb",                           /* mode                        -STDOUT*/
  "Czytanie starych nagwkw",     /* Reading old headers      -STDOUT*/
  "",                               /* tylko do wyrwnania       -STDOUT*/
  "BD",                           /* ERROR                       -STDERR*/
  "Adres wypisujcy z listy",       /* The submission address of the list-STDERR*/
  "Czytaj tylko jedn wiadomo",
  "Autor",                          /* author              -HTML*/
  "Data",                           /* date                -HTML*/
  "Temat",                          /* subject             -HTML*/
  "Wybierz",                        /* Mail actions (MA) header -HTML*/
  "wylij nowy temat",              /* MA New Message      -HTML*/
  "odpowiedz na t wiadomo",      /* MA Reply            -HTML*/
  "Zestawienie miesicy",           /* monthly             -HTML*/
  "Zestawienie lat",                /* yearly              -HTML*/
  "Utwrz cache nagowkw GDBM",    /* Build a GDBM header cache -STDOUT*/
  "GDBM header cache option not build in",
  		      /* GDBM header cache option not build in  -STDERR*/
  "Tworzenie indeksu GDBM... ",     /* Creating gdbm index -STDOUT*/
  "Nie mona utworzy pliku GDBM... ",  /* Can't create gdbm index     -STDOUT*/
  "Zachowaj archiwum mbox",         /* Maintain an mbox archive    -STDOUT*/
  "Nie mona odczyta ani zapisa mailboxa.", /* "Can't both read from and write to an mbox." -STDOUT*/
  "Wg zacznikw",                  /* Attachment view -HTML*/
  "Wg wiadomoci z zacznikami",    /* By messages with attachments -HTML*/
  "Zapisywanie indeksu zacznikw", /* Writing attachment index to -STDOUT*/
  "bajtw",                          /* file size, so far only for attachments  -HTML */
  "Nie mona stworzy aliasa",       /* MSG_CANNOT_CREATE_SYMLINK -STDOUT */
  "Nie mona usun pliku",          /* MSG_CANNOT_UNLINK      -STDOUT */
  "Poprzedni katalog",               /* MSG_PREV_DIRECTORY  -HTML */
  "Nastpny katalog",                /* MSG_NEXT_DIRECTORY    -HTML */
  "Lista Katalogw",                 /* MSG_FOLDERS_INDEX   -HTML */
  "Ta wiadomo zostaa usunita z archiwum", /* MSG_DELETED  -HTML */
  "Ta wiadomo jest przedawniona",  /*MSG_EXPIRED -HTML */
  "(usunita wiadomo)",            /* MSG_DEL_SHORT     -HTML */
  "Tekst tej zawartoci",            /* MSG_TXT_VERSION     -HTML */
  "Ta wiadomo zostaa odfiltrowana",        /* MSG_FILTERED_OUT -HTML */
  "Autor",                          /* MSG_FROM              -HTML*/
  "Write haof XML files",       /* Write hoaf XML files       -STDOUT */
  "Writing haof to",            /* Writing haof to               -HTML*/
  NULL,                              /* End Of Message Table      - NOWHERE*/
};


/*
** English version of the language table
*/

char *en[] = {       /* English */
  "New Message",                 /* New Message        -HTML*/
  "Reply",                       /* Reply              -HTML*/
  "About this list",             /* About this list    -HTML*/
  "End of Messages",             /* End of Messages    -HTML*/
  "Start of Messages",           /* Start of Messages  -HTML*/
  "Date view",                   /* Date view          -HTML*/
  "Thread view",                 /* Thread view        -HTML*/
  "Subject view",                /* Subject view       -HTML*/
  "Author view",                 /* Author view        -HTML*/
  "Other groups",                /* Other groups       -HTML*/
  "Messages",                    /* Messages           -HTML*/
  "Starting",                    /* Starting           -HTML*/
  "Ending",                      /* Ending             -HTML*/
  "About this archive",          /* About this archive -HTML*/
  "sorted by",                   /* Messages sorted by -HTML*/
  "Other mail archives",         /* Other mail archives -HTML*/
  "By Date",                     /* By Date             -HTML*/
  "Most recent messages",        /* Most recent messages-HTML*/
  "author",                      /* author              -HTML*/
  "date",                        /* date                -HTML*/
  "thread",                      /* thread              -HTML*/
  "subject",                     /* subject             -HTML*/
  "for options",                 /* for options       -STDOUT*/
  "Writing messages to",         /* Writing messages to-STDOUT*/
  "Writing date index to",       /* Writing date index to-STDOUT*/
  "Writing thread index to",     /* Writing thread index to -STDOUT*/
  "Writing subject index to",    /* Writing subject index to-STDOUT*/
  "Writing author index to",     /* Writing author index to-STDOUT*/
  "Last message date",           /* Last message date   -HTML*/
  "Archived on",                 /* Archived on         -HTML*/
  "Can not chmod",               /* Can not chmod     -STDERR*/
  "Could not write",             /* Could not write   -STDERR*/
  "Next message",                /* Next message        -HTML*/
  "Previous message",            /* Previous message    -HTML*/
  "Maybe in reply to",           /* Maybe in reply to   -HTML*/
  "In reply to",                 /* In reply to         -HTML*/
  "Next in thread",              /* Next in thread      -HTML*/
  "Maybe reply",                 /* Maybe reply         -HTML*/
  "By Thread",                   /* By Thread           -HTML*/
  "By Subject",                  /* By Subject          -HTML*/
  "By Author",                   /* By Author           -HTML*/
  "Can not create directory",    /* Can not create directory -STDERR*/
  "Creating directory",          /* Creating directory -STDOUT*/
  "Configuration Values",        /* Configuration Values -STDOUT*/
  "path",                        /* path              -STDOUT*/
  "Ran out of memory!",          /* Ran out of memory!-STDERR*/
  "This archive was generated by",  /* This archive was generated by-HTML*/
  "Elements",                    /* Elements          -STDOUT*/
  "No Elements",                 /* No Elements       -STDOUT*/
  "Cannot open mail archive",    /* Cannot open mail archive */
  "Reading new header...",       /* Reading new header...-STDOUT   */
  "Loading mailbox",             /* Loading mailbox      -STDOUT   */
  "encoding is not supported, stored as-is", /* encoding is not supported, stored as-is -HTML*/
  "messages",                    /* messages             -HTML*/
  "Version",                     /* Version            -STDOUT*/
  "Patchlevel",                  /* Patchlevel         -STDOUT*/
  "Docs",                        /* Docs               -STDOUT*/
  "Command and Control Variables",       /* Command and Control Variables-STDOUT*/
  "Yes",                         /* Yes                -STDOUT*/
  "No",                          /* No                 -STDOUT*/
  "About the archive: not used", /* About the archive: not used-STDOUT */
  "Other archives: not used",    /* Other archives: not used-STDOUT*/
  "address not used",            /* address not used        -STDOUT*/
  "Builtin <BODY> statement used", /* Builtin <BODY> statement used-STDOUT*/
  "Cannot read from both file and stdin.", /* Cannot read from both file and stdin. -STDERR*/
  "Options",                     /* Options                -STDOUT*/
  "URL to other archives",       /* URL to other archives  -STDOUT*/
  "URL to archive information",  /* URL to archive information -STDOUT*/
  "Configuration file to read in", /* Configuration file to read in -STDOUT*/
  "The directory to save HTML files in", /* The directory to save HTML files in -STDOUT*/
  "Read messages from standard input",/* Read messages from standard input -STDOUT*/
  "What to name the output archive", /* What to name the output archive -STDOUT*/
  "Mail archive to read in",     /* Mail archive to read in -STDOUT*/
  "Show progress",               /* Show progress           -STDOUT*/
  "Show configuration variables only", /* Show configuration variables only -STDOUT*/
  "Show version information and exit", /* Show version information and exit -STDOUT*/
  "Update archive by one article", /* Update archive by one article -STDOUT*/
  "Overwrite previous messages", /* Overwrite previous messages -STDOUT*/
  "Specify language to use",     /* Specify language to use     -STDOUT*/
  "Usage",                       /* Usage                       -STDOUT*/
  "Language not supported",      /* Language not supported      -STDERR*/
  "Not set",                     /* Not set                     -STDOUT*/
  "Not used",                    /* Not used                    -STDOUT*/
  "Created attachment file",     /* Created attachment file     -STDOUT*/
  "attachment",                  /* attachment                    -HTML*/
  "mode",                        /* mode                        -STDOUT*/
  "Reading old headers",         /* Reading old headers         -STDOUT*/
  "", /* for alignment only       -STDOUT*/
  "ERROR",                       /* ERROR                       -STDERR*/
  "The submission address of the list", 
                           /* The submission address of the list-STDERR*/
  "Read only one mail from input",
  "Author",                      /* author              -HTML*/
  "Date",                        /* date                -HTML*/
  "Subject",                     /* subject             -HTML*/
  "Mail actions",                /* Mail actions (MA) header -HTML*/
  "mail a new topic",            /* MA New Message      -HTML*/
  "respond to this message",     /* MA Reply            -HTML*/
  "Summary of Monthly Index Files",       /* monthly             -HTML*/
  "Summary of Yearly Index Files",        /* yearly              -HTML*/
  "Build a GDBM header cache",   /* Build a GDBM header cache   -STDOUT*/
  "GDBM header cache option not build in",
  		      /* GDBM header cache option not build in  -STDERR*/
  "Creating gdbm index... ",     /* Creating gdbm index         -STDOUT*/
  "Can't create gdbm file... ",  /* Can't create gdbm index     -STDOUT*/
  "Maintain an mbox archive",    /* Maintain an mbox archive    -STDOUT*/
  "Can't both read from and write to an mbox.", /* "Can't both read from and write to an mbox." -STDOUT*/
  "Attachment view",			  /* Attachment view       -HTML*/
  "By messages with attachments",	  /* By messages with attachments -HTML*/
  "Writing attachment index to",	  /* Writing attachment index to -STDOUT*/
  "bytes",		    /* file size, so far only for attachments  -HTML */
  "Cannot create symbolic link", /* MSG_CANNOT_CREATE_SYMLINK     -STDOUT */
  "Cannot remove file", /* MSG_CANNOT_UNLINK                       -STDOUT */
  "Previous Folder",  /* MSG_PREV_DIRECTORY                     -HTML */
  "Next Folder",      /* MSG_NEXT_DIRECTORY                     -HTML */
  "List of Folders",  /* MSG_FOLDERS_INDEX                      -HTML */
  "This message has been deleted from the archive", /* MSG_DELETED -HTML */
  "This message has expired",                       /* MSG_EXPIRED -HTML */
  "(deleted message)", /* MSG_DEL_SHORT                            -HTML */
  "Original text of this message", /* MSG_TXT_VERSION                          -HTML */
  "This message has been filtered out",        /* MSG_FILTERED_OUT -HTML */
  "From",                       /* MSG_FROM                    	 -HTML*/
  "Write haof XML files",       /* Write hoaf XML files       -STDOUT */
  "Writing haof to",            /* Writing haof to               -HTML*/
  NULL,                         /* End Of Message Table      - NOWHERE*/
};

/*
** Spanish version of the language table
** Translation by Francisco Iacobelli <fiacobelli@ibersis.cl>.
*/

char *es[] = {       /* Espanol/Spanish */
  "Nuevo mensaje",                    /* New Message 		      - HTML  */
  "Responder",                        /* Reply  		      - HTML  */
  "Acerca de la lista",               /* About this list  	      - HTML  */
  "Fin de los Mensajes",              /* End of Messages  	      - HTML  */
  "Inicio de mensajes",               /* Start of Messages  	      - HTML  */
  "Por fecha",                        /* Date view  		      - HTML  */
  "Por conversacin",         	      /* Thread view  		      - HTML  */
  "Por tema",                         /* Subject view  		      - HTML  */
  "Por autor",                        /* Author view  		      - HTML  */
  "Otros grupos",                     /* Other groups  		      - HTML  */
  "Mensajes",                         /* Messages  		      - HTML  */
  "Inicio",                           /* Starting		      - HTML  */
  "Fin",                              /* Ending  		      - HTML  */
  "Acerca de este archivo",           /* About this archive           - HTML  */
  "Ordenados por",                    /* Messages sorted by           - HTML  */
  "Otros archivos de correo",         /* Other mail archives  	      - HTML  */
  "Por fecha",                        /* By Date  		      - HTML  */
  "ltimos mensajes",                 /* Most recent messages 	      - HTML  */
  "autor",                            /* author 		      - HTML  */
  "fecha",                            /* date 			      - HTML  */
  "Hilo de conversacin",             /* thread 		      - HTML  */
  "tema",                             /* subject 		      - HTML  */
  "para las opciones",                /* for options 	 	      - STDOUT*/
  "Escribiendo mensajes en",          /* Writing articles to 	      - STDOUT*/
  "Escribiendo ndice de fechas en",  /* Writing date index to        - STDOUT*/
  "Escribiendo ndice de conversaciones en",
  				      /* Writing thread index to      - STDOUT*/
  "Escribiendo ndice de temas en",   /* Writing subject index to     - STDOUT*/
  "Escribiendo ndice de autores en", /* Writing author index to      - STDOUT*/
  "Fecha del ltimo mensaje",         /* Last message date 	      - HTML  */
  "Archivado el ",                    /* Archived on  		      - HTML  */
  "No se puede ejecutar chmod",       /* Can not chmod 		      - STDERR*/
  "No se pudo escribir",              /* Could not write 	      - STDERR*/
  "Siguiente mensaje",                /* Next message		      - HTML  */
  "Mensaje anterior",                 /* Previous message             - HTML  */
  "Posiblemente en respuesta a ",     /* Maybe in reply to  	      - HTML  */
  "En Respuesta a",                   /* In reply to  		      - HTML  */
  "Siguiente en conversacin",        /* Next in thread 	      - HTML  */
  "Posible respuesta",                /* Maybe reply  		      - HTML  */
  "Por conversacin",                 /* By Thread  		      - HTML  */
  "Por tema",                         /* By Subject  		      - HTML  */
  "Por autor",                        /* By Author  		      - HTML  */
  "No se puede crear el directorio",  /* Can not create directory     - STDERR*/
  "Creando el directorio",            /* Creating directory 	      - STDOUT*/
  "Parmetros de configuracn",       /* Configuration Values         - STDOUT*/
  "ruta",                             /* path 			      - STDOUT*/
  "No hay suficiente memoria!",      /* Ran out of memory! 	      - STDERR*/
  "Este archivo fue generado por",    /* This archive was generated by- HTML  */
  "Elementos",                        /* Elements 		      - STDOUT*/
  "No existen elementos",             /* No Elements 		      - STDOUT*/
  "No se puede abrir el archivo de correo",
  				      /* Cannot open mail archive     - STDERR*/
  "Leyendo el encabezado nuevo...",   /* Reading new header... 	      - STDOUT*/
  "Cargando la casilla",              /* Loading mailbox 	      - STDOUT*/
  "codificacin no soportada, grabado -tal cual-", 
	                     /* encoding is not supported, stored as-is - HTML*/

  "mensajes",                         /* articles */
  "Versin",                          /* Version 		      - STDOUT*/
  "Parche No.",                       /* Patchlevel 		      - STDOUT*/
  "Docs",                             /* Docs 			      - STDOUT*/
  "Variables de comandos y control",  /* Command and Control Variables- STDOUT*/
  "Si",                               /* Yes			      - STDOUT*/
  "No",                               /* No 			      - STDOUT*/
  "Acerca del archivo: no utilizado", /* About the archive: not used  - STDOUT*/
  "Otros archivos: no utilizado",     /* Other archives: not used     - STDOUT*/
  "direccin no utilizada",           /* address not used 	      - STDOUT*/
  "Utilizado <BODY> predefinido",   /* Builtin <BODY> statement used  - STDOUT*/
  "No se puede leer de archivo y de stdin a la vez.", 
                            /* Cannot read from both file and stdin.  - STDERR*/
  "Opciones",                         /* Options 		      - STDOUT*/
  "URL de otros archivos",            /* URL to other archives 	      - STDOUT*/
  "URL de informacin de archivos",   /* URL to archive information   - STDOUT*/
  "Archivo de conf. para leer",     /* Configuration file to read in  - STDOUT*/
  "Directorio donde grabar archivos HTML", 
                              /* The directory to save HTML files in  - STDOUT*/
  "Leer mensajes de la entrada por defecto",   
                                /* Read messages from standard input  - STDOUT*/
  "Nombre del archivo de salida", /* What to name the output archive  - STDOUT*/
  "Archivo de correo para leer",      /* Mail archive to read in      - STDOUT*/
  "Mostrar progreso",                 /* Show progress 		      - STDOUT*/
  "Mostrar solamente variables de conf.",   
                                 /* Show configuration variables only - STDOUT*/
  "Mostrar informacin de versin y salir",   
				 /* Show version information and exit - STDOUT*/
  "Actualizar archivo con un mensaje",/*Update archive by one article - STDOUT*/
  "Sobreescribir mensajes anteriores",/* Overwrite previous messages  - STDOUT*/
  "Especifique idioma utilizar",      /* Specify language to use      - STDOUT*/
  "Modo de uso",                      /* Usage                        - STDOUT*/
  "Idioma no soportado",              /* Language not supported       - STDERR*/
  "No establecido",                   /* Not set                      - STDOUT*/
  "No utilizado",                     /* Not used                     - STDOUT*/
  "Archivo adjunto creado",           /* Created attachment file      - STDOUT*/
  "adjunto",                          /* attachment                   - HTML  */
  "modo",                             /* mode                         - STDOUT*/
  "Leyendo encabezados antiguos",     /* Reading old headers          - STDOUT*/
  "",                                 /* (for alignment only)         - STDOUT*/
  "ERROR",                            /* ERROR                        - STDERR*/
  "Direccin de correo de la lista",  
  				/* The submission address of the list - STDERR*/
  "Leer slo un mensaje de la entrada",
  			       /* Read only one mail from input		      */
  "Autor",                            /* author	 		      - HTML  */
  "Fecha",                            /* date 			      - HTML  */
  "Tema",                             /* subject		      - HTML  */
  "Cabecera MA (Mail actions)",       /* Mail actions (MA) header     - HTML  */
  "Enviar un nuevo tema",             /* MA New Message     	      - HTML  */
  "responder a este mensaje",         /* MA Reply       	      - HTML  */
  "Resumen de ndices mensuales",     /* monthly            	      - HTML  */
  "Resumen de ndices anuales",       /* yearly              	      - HTML  */
  "Costruir cabecera para cach GDBM",/* Build a GDBM header cache    - STDOUT*/
  "Creando ndice gdbm... ",          /* Creating gdbm index          - STDOUT*/
  "No pudo crearse fichero gdbm... ", /* Can't create gdbm index      - STDOUT*/
  "Mantener un archivo mbox",         /* Maintain an mbox archive     - STDOUT*/
  "No se puede leer y escribir al tiempo de un fichero mbox.",
		      /* "Can't both read from and write to an mbox." - STDOUT*/
  "Por adjuntos",                     /* Attachment view  	      - HTML  */
  "Por mensajes con adjuntos",	      /* By messages with attachments - HTML  */
  "Escribiendo ndice de adjuntos en",/* Writing attachment index to  - STDOUT*/
  "bytes",		    /* file size, so far only for attachments - HTML  */
  "No pudo crearse enlace simblico", /* MSG_CANNOT_CREATE_SYMLINK    - STDOUT*/
  "No puede borrarse fichero",        /* MSG_CANNOT_UNLINK            - STDOUT*/
  "Carpeta anterior",  		      /* MSG_PREV_DIRECTORY           - HTML  */
  "Siguiente carpeta",                /* MSG_NEXT_DIRECTORY           - HTML  */
  "Lista de carpetas",  	      /* MSG_FOLDERS_INDEX            - HTML  */
  "El mensaje ha sido borrado del archivo",
  				      /* MSG_DELETED 		      - HTML  */
  "El mensaje ha caducado",           /* MSG_EXPIRED 		      - HTML  */
  "(mensaje borrado)",		      /* MSG_DEL_SHORT                - HTML  */
  "Texto original del mensaje",       /* MSG_TXT_VERSION   	      - HTML  */
  "El mensaje ha sido filtrado",      /* MSG_FILTERED_OUT 	      - HTML  */
  "Autor",                            /* MSG_FROM 		      - HTML  */
  "Write haof XML files",       /* Write hoaf XML files       -STDOUT */
  "Writing haof to",            /* Writing haof to               -HTML*/
  NULL,                               /* End Of Message Table */
};

/*
** Finnish version of the language table
*/

char *fi[] = {       /* Finnish */
  "Lhet uusi viesti",              /* New Message        -HTML*/
  "Kommentoi",                             /* Reply              -HTML*/
  "Tietoa listasta",                       /* About this list    -HTML*/
  "Viestien loppuun",                      /* End of Messages    -HTML*/
  "Viestien alkuun",                       /* Start of Messages  -HTML*/
  "Pivysnkym",             /* Date view          -HTML*/
  "Ketjunkym",                     /* Thread view        -HTML*/
  "Aihenkym",                      /* Subject view       -HTML*/
  "Kirjoittajankym",               /* Author view        -HTML*/
  "Muut arkistot",                         /* Other groups       -HTML*/
  "Viestit",                               /* Messages           -HTML*/
  "alkaa",                                 /* Starting           -HTML*/
  "loppuu",                                /* Ending             -HTML*/
  "Tietoa arkistosta",                     /* About this archive -HTML*/
  "lajiteltuna",                           /* Messages sorted by -HTML*/
  "Muita arkistoja",                       /* Other mail archives -HTML*/
  "Pivyksittin",               /* By Date             -HTML*/
  "Tuoreimmat viestit",                    /* Most recent messages-HTML*/
  "kirjoittajittain",                      /* author              -HTML*/
  "pivyksittin",               /* date                -HTML*/
  "ketjuittain",                           /* thread              -HTML*/
  "aiheittain",                            /* subject             -HTML*/
  "asetuksiin",                            /* for options       -STDOUT*/
  "Kirjoitan viestej",                 /* Writing messages to-STDOUT*/
  "Kirjoitan hakemistoa pivyksittin", /* Writing date index to-STDOUT*/
  "Kirjoitan hakemistoa ketjuittain",      /* Writing thread index to -STDOUT*/
  "Kirjoitan hakemistoa aiheittain",       /* Writing subject index to-STDOUT*/
  "Kirjoitan hakemistoa kirjoittajittain", /* Writing author index to-STDOUT*/
  "Viimeinen viesti pivtty",       /* Last message date   -HTML*/
  "Arkistoitu",                            /* Archived on         -HTML*/
  "Ei voi muuttaa oikeuksia ",             /* Can not chmod     -STDERR*/
  "Kirjoitus eponnistui",              /* Could not write   -STDERR*/
  "Seuraava viesti",                       /* Next message        -HTML*/
  "Edellinen viesti",                      /* Previous message    -HTML*/
  "Ehk kommentti viestiin",            /* Maybe in reply to   -HTML*/
  "Kommentti viestiin",                    /* In reply to         -HTML*/
  "Seuraava ketjussa",                     /* Next in thread      -HTML*/
  "Ehk kommentti",                     /* Maybe reply         -HTML*/
  "Ketjuittain",                           /* By Thread           -HTML*/
  "Aiheittain",                            /* By Subject          -HTML*/
  "Kirjoittajittain",                      /* By Author           -HTML*/
  "Ei voi luoda hakemistoa",               /* Can not create directory -STDERR*/
  "Luon hakemistoa",                       /* Creating directory -STDOUT*/
  "Asetukset",                             /* Configuration Values -STDOUT*/
  "polku",                                 /* path              -STDOUT*/
  "Muisti loppui!",                        /* Ran out of memory!-STDERR*/
  "Tmn arkiston loi",            /* This archive was generated by-HTML*/
  "Osaset",                                /* Elements          -STDOUT*/
  "Ei osasia",                             /* No Elements       -STDOUT*/
  "Ei voi avata postiarkistoa",            /* Cannot open mail archive */
  "Luen uusia otsikkorivej...",        /* Reading new header...-STDOUT   */
  "Lataan postilaatikkoa",                 /* Loading mailbox      -STDOUT   */
  "koodaus ei tuettu, talletettu sellaisenaan", /* encoding is not supported, stored as-is -HTML*/
  "viesti",                            /* messages             -HTML*/
  "Versio",                                /* Version            -STDOUT*/
  "Patchlevel",                            /* Patchlevel         -STDOUT*/
  "Ohjeet",                                /* Docs               -STDOUT*/
  "Komento- ja ohjausmuuttujat",       /* Command and Control Variables-STDOUT*/
  "Kyll",                              /* Yes                -STDOUT*/
  "Ei",                                    /* No                 -STDOUT*/
  "Tietoa arkistosta: ei kytss", /* About the archive: not used-STDOUT */
  "Muut arkistot: ei kytss",   /* Other archives: not used-STDOUT*/
  "osoite ei kytss",           /* address not used        -STDOUT*/
  "Kytetn oletus-<BODY>-rakennetta", /* Builtin <BODY> statement used-STDOUT*/
  "Ei voi lukea sek tiedostosta ett syttvirrasta (stdin).", /* Cannot read from both file and stdin. -STDERR*/
  "Asetukset",                             /* Options                -STDOUT*/
  "URL muihin arkistoihin",                /* URL to other archives  -STDOUT*/
  "URL arkiston tietoihin",              /* URL to archive information -STDOUT*/
  "Asetustiedosto",                   /* Configuration file to read in -STDOUT*/
  "HTML-tiedostojen talletushakemisto", /* The directory to save HTML files in -STDOUT*/
  "Lue viestit syttvirrasta (stdin)",/* Read messages from standard input -STDOUT*/
  "Talletettavan arkiston nimi",   /* What to name the output archive -STDOUT*/
  "Luettava postiarkisto",                /* Mail archive to read in -STDOUT*/
  "Nyt eteneminen",               /* Show progress           -STDOUT*/
  "Nyt vain asetusmuuttujat", /* Show configuration variables only -STDOUT*/
  "Nyt versiotieto ja lopeta ohjelma", /* Show version information and exit -STDOUT*/
  "Pivit arkistoa yhdell viestill", /* Update archive by one article -STDOUT*/
  "Korvaa aiemmat viestit", /* Overwrite previous messages -STDOUT*/
  "Mrit kytettv kieli",     /* Specify language to use     -STDOUT*/
  "Kyttohje",                    /* Usage                   -STDOUT*/
  "Kieli ei tuettu",                     /* Language not supported  -STDERR*/
  "Ei asetettu",                         /* Not set                 -STDOUT*/
  "Ei kytss",                /* Not used                -STDOUT*/
  "Luotu liitetiedosto",                 /* Created attachment file -STDOUT*/
  "liite",                               /* attachment              -HTML*/
  "suojaus",                             /* mode                    -STDOUT*/
  "Luen vanhoja otsikkorivej",       /* Reading old headers     -STDOUT*/
  "",                                    /* for alignment only      -STDOUT*/
  "VIRHE",                               /* ERROR                   -STDERR*/
  "Listan lhetysosoite",   /* The submission address of the list-STDERR*/
  "Lue vain yksi viesti",
  "Kirjoittajan mukaan",                 /* author                    -HTML*/
  "Pivyksen mukaan",             /* date                      -HTML*/
  "Aiheen mukaan",                       /* subject                   -HTML*/
  "Mail actions",                    /* Mail actions (MA) header -HTML*/
  "mail a new topic",                /* MA New Message      -HTML*/
  "respond to this message",         /* MA Reply            -HTML*/
  "Summary of Monthly Index Files",      /* monthly             -HTML*/
  "Summary of Yearly Index Files",       /* yearly              -HTML*/
  "Build a GDBM header cache",   /* Build a GDBM header cache   -STDOUT*/
  "GDBM header cache option not build in",
   		      /* GDBM header cache option not build in  -STDERR*/
  "Creating gdbm index... ",     /* Creating gdbm index         -STDOUT*/
  "Can't create gdbm file... ",  /* Can't create gdbm index     -STDOUT*/
  "Maintain an mbox archive",    /* Maintain an mbox archive    -STDOUT*/
  "Can't both read from and write to an mbox.", /* "Can't both read from and write to an mbox." -STDOUT*/
  "Attachment view",                      /* Attachment view  -HTML*/
  "By messages with attachments",	  /* By messages with attachments -HTML*/
  "Writing attachment index to",	  /* Writing attachment index to -STDOUT*/
  "bytes",		    /* file size, so far only for attachments  -HTML */
  "Cannot create symbolic link", /* MSG_CANNOT_CREATE_SYMLINK     -STDOUT */
  "Cannot remove file", /* MSG_CANNOT_UNLINK                       -STDOUT */
  "Previous Folder",  /* MSG_PREV_DIRECTORY                     -HTML */
  "Next Folder",      /* MSG_NEXT_DIRECTORY                     -HTML */
  "List of Folders",  /* MSG_FOLDERS_INDEX                      -HTML */
  "This message has been deleted from the archive", /* MSG_DELETED -HTML */
  "This message has expired",                       /* MSG_EXPIRED -HTML */
  "(deleted message)", /* MSG_DEL_SHORT                            -HTML */
  "Original text of this message", /* MSG_TXT_VERSION                          -HTML */
  "This message has been filtered out",        /* MSG_FILTERED_OUT -HTML */
  "Kirjoittajan mukaan",                 /* MSG_FROM                  -HTML*/
  "Write haof XML files",       /* Write hoaf XML files       -STDOUT */
  "Writing haof to",            /* Writing haof to               -HTML*/
  NULL,                              /* End Of Message Table      - NOWHERE*/
};

/*
** French version of the language table
** Translation by Nicolas Noble <pixels@chez.com>
*/

char *fr[] = {       /* French */
  "Nouveau Message",                       /* New Message        -HTML*/
  "R&eacute;ponse",                        /* Reply              -HTML*/
  "A propos de cette liste",               /* About this list    -HTML*/
  "Fin des Messages",                      /* End of Messages    -HTML*/
  "D&eacute;but des Messages",             /* Start of Messages  -HTML*/
  "Liste par Date",                        /* Date view          -HTML*/
  "Liste par Th&egrave;me",                /* Thread view        -HTML*/
  "Liste par Sujet",                       /* Subject view       -HTML*/
  "Liste par Auteur",                      /* Author view        -HTML*/
  "Autres groupes",                        /* Other groups       -HTML*/
  "Messages",                              /* Messages           -HTML*/
  "D&eacute;but",                          /* Starting           -HTML*/
  "Fin",                                   /* Ending             -HTML*/
  "A propos de cette archive",             /* About this archive -HTML*/
  ", class&eacute;s par",                  /* Messages sorted by -HTML*/
  "Autres archives",                       /* Other mail archives -HTML*/
  "par Date",                              /* By Date             -HTML*/
  "Messages les plus r&eacute;cents",      /* Most recent messages-HTML*/
  "auteur",                                /* author              -HTML*/
  "date",                                  /* date                -HTML*/
  "th&egrave;me",                          /* thread              -HTML*/
  "sujet",                                 /* subject             -HTML*/
  "pour les options",                      /* for options       -STDOUT*/
  "Ecriture des messages vers",            /* Writing messages to-STDOUT*/
  "Ecriture de l'index 'date' dans",       /* Writing date index to-STDOUT*/
  "Ecriture de l'index 'thme' dans",      /* Writing thread index to -STDOUT*/
  "Ecriture de l'index 'sujet' dans",      /* Writing subject index to-STDOUT*/
  "Ecriture de l'index 'auteur' dans",     /* Writing author index to-STDOUT*/
  "Date du dernier message",               /* Last message date   -HTML*/
  "Archiv&eacute; le",                     /* Archived on         -HTML*/
  "Ne peut effectuer de chmod",            /* Can not chmod     -STDERR*/
  "Ne peut crire",                        /* Could not write   -STDERR*/
  "Message suivant",                       /* Next message        -HTML*/
  "Message pr&eacute;c&eacute;dent",       /* Previous message    -HTML*/
  "Sans doute en r&eacute;ponse &agrave;", /* Maybe in reply to   -HTML*/
  "En r&eacute;ponse &agrave;",             /* In reply to         -HTML*/
  "Suivant dans le th&egrave;me",          /* Next in thread      -HTML*/
  "Sans doute en r&eacute;ponse",          /* Maybe reply         -HTML*/
  "par Thme",                      /* By Thread           -HTML*/
  "par Sujet",                             /* By Subject          -HTML*/
  "par Auteur",                            /* By Author           -HTML*/
  "Ne peut crer le rpertoire",           /* Can not create directory -STDERR*/
  "Cration du rpertoire",                /* Creating directory -STDOUT*/
  "Valeurs configures",                   /* Configuration Values -STDOUT*/
  "chemin",                                /* path              -STDOUT*/
  "Plus assez de mmoire!",                 /* Ran out of memory!-STDERR*/
  "Cette archive a &eacute;t&eacute; cr&eacute;&eacute;e par",  /* This archive was generated by-HTML*/
  "Elments",                              /* Elements          -STDOUT*/
  "Aucun Elment",                         /* No Elements       -STDOUT*/
  "Ne peut ouvrir l'archive de mail",      /* Cannot open mail archive */
  "Lecture du nouvel en-tte...",          /* Reading new header...-STDOUT   */
  "Chargement de la boite aux lettres",    /* Loading mailbox      -STDOUT   */
  "encodage non support, stock tel quel",/* encoding is not supported, stored as-is -HTML*/
  "messages",                              /* messages             -HTML*/
  "Version",                               /* Version            -STDOUT*/
  "Revision",                              /* Patchlevel         -STDOUT*/
  "Documents",                             /* Docs               -STDOUT*/
  "Variables de Commande et de Contrle",  /* Command and Control Variables-STDOUT*/
  "Oui",                                   /* Yes                -STDOUT*/
  "Non",                                   /* No                 -STDOUT*/
  "A propos de l'archive: non utilis",    /* About the archive: not used-STDOUT */
  "Autres archives: non utilis",          /* Other archives: not used-STDOUT*/
  "adresse non utilise",                  /* address not used        -STDOUT*/
  "Utilisation de la dclaration <BODY>",  /* Builtin <BODY> statement used-STDOUT*/
  "Impossible de lire simulatanment un fichier et le flot d'entre standard (stdin)", /* Cannot read from both file and stdin. -STDERR*/
  "Options",                               /* Options                -STDOUT*/
  "URL vers les autres archives",          /* URL to other archives  -STDOUT*/
  "URL vers les informations sur l'archive",  /* URL to archive information -STDOUT*/
  "Fichier de configuration  lire",       /* Configuration file to read in -STDOUT*/
  "Rpertoire o sauver les fichiers HTML",/* The directory to save HTML files in -STDOUT*/
  "Lecture des messages depuis le flot d'entre standard (stdin)", /* Read messages from standard input -STDOUT*/
  "Nom de l'archive de sortie",            /* What to name the output archive -STDOUT*/
  "Archive d'email  lire",                   /* Mail archive to read in -STDOUT*/
  "Voir la progression",                   /* Show progress           -STDOUT*/
  "Voir les variables de configuration seulement", /* Show configuration variables only -STDOUT*/
  "Afficher la version et quitter",        /* Show version information and exit -STDOUT*/
  "Mettre  jour l'archive d'un article",  /* Update archive by one article -STDOUT*/
  "Ecraser les messages prcdents",       /* Overwrite previous messages -STDOUT*/
  "Spcifier la langue  utiliser",        /* Specify language to use     -STDOUT*/
  "Utilisation",                           /* Usage           -STDOUT*/
  "Langue non supporte",                  /* Language not supported -STDERR*/
  "Non dfini",                            /* Not set        -STDOUT*/
  "Non utilis",                           /* Not used       -STDOUT*/
  "Fichier attach cr",                  /* Created attachment file -STDOUT*/
  "fichier attach&eacute;",                /* attachment     -HTML*/
  "mode",                                  /* mode           -STDOUT*/
  "Lecture des anciens en-ttes",          /* Reading old headers -STDOUT*/
  "",                                      /* for alignment only       -STDOUT*/
  "ERREUR",                                /* ERROR                    -STDERR*/
  "Adresse d'envoi  la liste", 
                                           /* The submission address of the list-STDERR*/
  "Lire seulement un mail depuis l'entre",
  "Auteur",                                /* author              -HTML*/
  "Date",                                  /* date                -HTML*/
  "Sujet",                                 /* subject             -HTML*/
  "Actions sur les mails",                 /* Mail actions (MA) header -HTML*/
  "cr&eacute;er un nouveau th&egrave;me",  /* MA New Message      -HTML*/
  "r&eacute;pondre &agrave; ce message",   /* MA Reply            -HTML*/
  "Summary of Monthly Index Files",        /* monthly             -HTML*/
  "Summary of Yearly Index Files",         /* yearly              -HTML*/
  "Creation d'un cache GDBM pour les en-ttes",  /* Build a GDBM header cache   -STDOUT*/
  "GDBM header cache option not build in",
  		      /* GDBM header cache option not build in  -STDERR*/
  "Generation de l'index GDBM... ",               /* Creating gdbm index         -STDOUT*/
  "Impossible de crer un fichier GDBM... ",    /* Can't create gdbm index     -STDOUT*/
  "Maintenance d'une archive email (mbox)",     /* Maintain an mbox archive    -STDOUT*/
  "Impossible de lire et d'crire simultanment dans une archive email (mbox)", /* "Can't both read from and write to an mbox." -STDOUT*/
  "Liste par fichier attachs",            /* Attachment view  -HTML*/
  "par messages avec fichiers attachs",    /* By messages with attachments -HTML*/
  "Ecriture de l'index 'fichiers attachs' dans",/* Writing attachment index to -STDOUT*/
  "octets",		                   /* file size, so far only for attachments  -HTML */
  "Impossible de crer un lien symbolique",/* MSG_CANNOT_CREATE_SYMLINK     -STDOUT */
  "Impossible de supprimer le fichier",    /* MSG_CANNOT_UNLINK                       -STDOUT */
  "Dossier prcdent",                     /* MSG_PREV_DIRECTORY                     -HTML */
  "Dossier suivant",                       /* MSG_NEXT_DIRECTORY                     -HTML */
  "Liste des dossiers",                    /* MSG_FOLDERS_INDEX                      -HTML */
  "Ce message a &eacute;t&eacute; supprim&eacute; de l'archive", /* MSG_DELETED -HTML */
  "Ce message est trop vieux",             /* MSG_EXPIRED -HTML */
  "(message supprim&eacute)",              /* MSG_DEL_SHORT                            -HTML */
  "Texte original de ce message",          /* MSG_TXT_VERSION                          -HTML */
  "Ce message a &eacute;t&eacute; supprim par filtrage",    /* MSG_FILTERED_OUT -HTML */
  "Auteur",                                /* MSG_FROM              -HTML*/
  "Write haof XML files",       /* Write hoaf XML files       -STDOUT */
  "Writing haof to",            /* Writing haof to               -HTML*/
  NULL,                                    /* End Of Message Table  - NOWHERE*/
};

/*
** Icelandic version of the language table
** Translation by Bjarni R. Einarsson <bre@netverjar.is>
*/

char *is[] = {       /* Icelandic */
  "Ntt brf",                   /* New Message        -HTML*/
  "Svar",                              /* Reply              -HTML*/
  "Um ennan lista",                /* About this list    -HTML*/
  "Endir safns",                       /* End of Messages    -HTML*/
  "Upphaf safns",                      /* Start of Messages  -HTML*/
  "Raa e. dagssetningum",      /* Date view          -HTML*/
  "Raa e. umrum",      /* Thread view        -HTML*/
  "Raa e. vifangsefnum",   /* Subject view       -HTML*/
  "Raa e. hfundum",        /* Author view        -HTML*/
  "Arir flokkar",                  /* Other groups       -HTML*/
  "Brfum",                         /* Messages           -HTML*/
  "Fr",                            /* Starting           -HTML*/
  "Til",                               /* Ending             -HTML*/
  "Um etta safn",                  /* About this archive -HTML*/
  "Raa eftir",                     /* Messages sorted by -HTML*/
  "nnur sfn",                  /* Other mail archives -HTML*/
  "eftir dagssetningum",               /* By Date             -HTML*/
  "Njustu brfin",              /* Most recent messages-HTML*/
  "hfundum",                       /* author              -HTML*/
  "dags.",                             /* date                -HTML*/
  "umrum",                     /* thread              -HTML*/
  "vifangsefnum",                  /* subject             -HTML*/
  "for options",                       /* for options       -STDOUT*/
  "Writing messages to",               /* Writing messages to-STDOUT*/
  "Writing date index to",             /* Writing date index to-STDOUT*/
  "Writing thread index to",           /* Writing thread index to -STDOUT*/
  "Writing subject index to",          /* Writing subject index to-STDOUT*/
  "Writing author index to",           /* Writing author index to-STDOUT*/
  "Dags. sasta brfs",      /* Last message date   -HTML*/
  "Sasta brf mtteki", /* Archived on         -HTML*/
  "Can not chmod",                     /* Can not chmod     -STDERR*/
  "Could not write",                   /* Could not write   -STDERR*/
  "Nsta brf",                  /* Next message        -HTML*/
  "Fyrra brf",                     /* Previous message    -HTML*/
  "Mgulega  frh. af",          /* Maybe in reply to   -HTML*/
  " framhaldi af",                 /* In reply to         -HTML*/
  "Nst  umru",         /* Next in thread      -HTML*/
  "Mgulegt svar",                  /* Maybe reply         -HTML*/
  "eftir umrum",               /* By Thread           -HTML*/
  "eftir vifangsefnum",            /* By Subject          -HTML*/
  "eftir hfundum",                 /* By Author           -HTML*/
  "Can not create directory",          /* Can not create directory -STDERR*/
  "Creating directory",                /* Creating directory -STDOUT*/
  "Configuration Values",              /* Configuration Values -STDOUT*/
  "path",                              /* path              -STDOUT*/
  "Ran out of memory!",                /* Ran out of memory!-STDERR*/
  "Framreitt af",                      /* This archive was generated by-HTML*/
  "Elements",                          /* Elements          -STDOUT*/
  "No Elements",                       /* No Elements       -STDOUT*/
  "Cannot open mail archive",          /* Cannot open mail archive */
  "Reading new header...",             /* Reading new header...-STDOUT   */
  "Loading mailbox",                   /* Loading mailbox      -STDOUT   */
  "framandi kun, geymt breytt", /* encoding is not supported, stored as-is -HTML*/
  "brf.",                          /* messages             -HTML*/
  "Version",                           /* Version            -STDOUT*/
  "Patchlevel",                        /* Patchlevel         -STDOUT*/
  "Docs",                              /* Docs               -STDOUT*/
  "Command and Control Variables",     /* Command and Control Variables-STDOUT*/
  "Yes",                               /* Yes                -STDOUT*/
  "No",                                /* No                 -STDOUT*/
  "About the archive: not used",       /* About the archive: not used-STDOUT */
  "Other archives: not used",          /* Other archives: not used-STDOUT*/
  "address not used",                  /* address not used        -STDOUT*/
  "Builtin <BODY> statement used",     /* Builtin <BODY> statement used-STDOUT*/
  "Cannot read from both file and stdin.", /* Cannot read from both file and stdin. -STDERR*/
  "Options",                           /* Options                -STDOUT*/
  "URL to other archives",             /* URL to other archives  -STDOUT*/
  "URL to archive information",        /* URL to archive information -STDOUT*/
  "Configuration file to read in",    /* Configuration file to read in -STDOUT*/
  "The directory to save HTML files in", /* The directory to save HTML files in -STDOUT*/
  "Read messages from standard input", /* Read messages from standard input -STDOUT*/
  "What to name the output archive",   /* What to name the output archive -STDOUT*/
  "Mail archive to read in",           /* Mail archive to read in -STDOUT*/
  "Show progress",                     /* Show progress           -STDOUT*/
  "Show configuration variables only", /* Show configuration variables only -STDOUT*/
  "Show version information and exit", /* Show version information and exit -STDOUT*/
  "Update archive by one article",    /* Update archive by one article -STDOUT*/
  "Overwrite previous messages",      /* Overwrite previous messages -STDOUT*/
  "Specify language to use",          /* Specify language to use     -STDOUT*/
  "Usage",                            /* Usage                       -STDOUT*/
  "Language not supported",           /* Language not supported      -STDERR*/
  "Not set",                          /* Not set                     -STDOUT*/
  "Not used",                         /* Not used                    -STDOUT*/
  "Created attachment file",          /* Created attachment file     -STDOUT*/
  "vihengi",                      /* attachment                    -HTML*/
  "mode",                             /* mode                        -STDOUT*/
  "Reading old headers",              /* Reading old headers         -STDOUT*/
  "",                                 /* for alignment only       -STDOUT*/
  "ERROR",                            /* ERROR                       -STDERR*/
  "The submission address of the list", 
                           /* The submission address of the list-STDERR*/
  "Read only one mail from input",
  "Hfundur",                      /* author              -HTML*/
  "Dagssetning",                      /* date                -HTML*/
  "Vifangsefni",                  /* subject             -HTML*/
  "Mail actions",                     /* Mail actions (MA) header -HTML*/
  "mail a new topic",                 /* MA New Message      -HTML*/
  "respond to this message",          /* MA Reply            -HTML*/
  "Summary of Monthly Index Files",   /* monthly             -HTML*/
  "Summary of Yearly Index Files",    /* yearly              -HTML*/
  "Build a GDBM header cache",   /* Build a GDBM header cache   -STDOUT*/
  "GDBM header cache option not build in",
  		      /* GDBM header cache option not build in  -STDERR*/
  "GDBM header cache option not build in",
  		      /* GDBM header cache option not build in  -STDERR*/
  "Creating gdbm index... ",     /* Creating gdbm index         -STDOUT*/
  "Can't create gdbm file... ",  /* Can't create gdbm index     -STDOUT*/
  "Maintain an mbox archive",    /* Maintain an mbox archive    -STDOUT*/
  "Can't both read from and write to an mbox.", /* "Can't both read from and write to an mbox." -STDOUT*/
  "Attachment view",                      /* Attachment view  -HTML*/
  "By messages with attachments",	  /* By messages with attachments -HTML*/
  "Writing attachment index to",	  /* Writing attachment index to -STDOUT*/
  "bytes",		    /* file size, so far only for attachments  -HTML */
  "Cannot create symbolic link", /* MSG_CANNOT_CREATE_SYMLINK     -STDOUT */
  "Cannot remove file", /* MSG_CANNOT_UNLINK                       -STDOUT */
  "Previous Folder",  /* MSG_PREV_DIRECTORY                     -HTML */
  "Next Folder",      /* MSG_NEXT_DIRECTORY                     -HTML */
  "List of Folders",  /* MSG_FOLDERS_INDEX                      -HTML */
  "This message has been deleted from the archive", /* MSG_DELETED -HTML */
  "This message has expired",                       /* MSG_EXPIRED -HTML */
  "(deleted message)", /* MSG_DEL_SHORT                            -HTML */
  "Original text of this message", /* MSG_TXT_VERSION                          -HTML */
  "This message has been filtered out",        /* MSG_FILTERED_OUT -HTML */
  "Hfundur",                         /* MSG_FROM              -HTML*/
  "Write haof XML files",       /* Write hoaf XML files       -STDOUT */
  "Writing haof to",            /* Writing haof to               -HTML*/
  NULL,                               /* End Of Message Table      - NOWHERE*/
};

/*
** Swedish version of the language table. Daniel Stenberg translation.
** (a little secret for free: we don't say bork ;-)
*/

char *sv[] = {
  "Nytt brev",                      /* New Message        -HTML*/
  "Svar" ,                          /* Reply              -HTML*/
  "Om den hr listan",      /* About this list    -HTML*/
  "Slut p brevlistan",          /* End of Messages    -HTML*/
  "Start p brevlistan",         /* Start of Messages  -HTML*/
  "Datumvy",                        /* Date view          -HTML*/
  "Trdvy",                      /* Thread view        -HTML*/
  "mnesvy",                     /* Subject view       -HTML*/
  "Frfattarvy",                 /* Author view        -HTML*/
  "Andra grupper",                  /* Other groups       -HTML*/
  "Brev",                           /* Messages           -HTML*/
  "Startar",                        /* Starting           -HTML*/
  "Slutar",                         /* Ending             -HTML*/
  "Om det hr arkivet", /* About this archive -HTML*/
  "sortede efter",                 /* Messages sorted by -HTML*/
  "Andra brevarkiv",                /* Other mail archives-HTML*/
  "Datumsorterat",                    /* By Date            -HTML*/
  "Nyast brev",                     /* Most recent messages-HTML*/
  "frfattare",                  /* author             -HTML*/
  "datum",                          /* date               -HTML*/
  "trd",                        /* thread             -HTML*/
  "mne",                        /* subject            -HTML*/
  "fr instllningar",        /* for options        -STDOUT*/
  "Skriver brev till",              /* Writing messages to-STDOUT*/
  "Skriver datumindex till",        /* Writing date index to-STDOUT*/
  "Skriver trdindex till",      /* Writing thread index to -STDOUT*/
  "Skriver mnesindex till",     /* Writing subject index to-STDOUT*/
  "Skriver frfattarindex till", /* Writing author index to-STDOUT*/
  "Senaste brevdatum",             /* Last message date  -HTML*/
  "Arkiverat",                      /* Archived on        -HTML*/
  "Kan inte chmod",                 /* Can not chmod      -STDERR*/
  "Kunde inte skriva",              /* Could not write    -STDERR*/
  "Nsta brev",                  /* Next message       -HTML*/
  "Tidigare brev",                  /* Previous message   -HTML*/
  "Kanske ett svar till",           /* Maybe in reply to  -HTML*/
  "Svar till",                      /* In reply to        -HTML*/
  "Nsta i trden",               /* Next in thread     -HTML*/
  "Kanske svar",                    /* Maybe reply        -HTML*/
  "Trdsorterat",                    /* By Thread          -HTML*/
  "mnessorterat",                    /* By Subject         -HTML*/
  "Frfattarsorterat",              /* By Author          -HTML*/
  "Kan inte skapa directory",       /* Can not create directory -STDERR*/
  "Skapar katalog",               /* Creating directory -STDOUT*/
  "Konfigureringsvrden",        /* Configuration Values -STDOUT*/
  "path",                           /* path               -STDOUT*/
  "Fick slut p minne!",         /* Ran out of memory!-STDERR*/
  "Det hr arkivet skapades av", /* This archive was generated by-HTML*/
  "Delar",                          /* Elements           -STDOUT*/
  "Inga delar",                     /* No Elements        -STDOUT*/
  "Kan inte ppna brevarkivet",  /* Cannot open mail archive */
  "Lser ny header...",          /* Reading new header...-STDOUT*/
  "Laddar mailbox",                 /* Loading mailbox   -STDOUT   */
  "kodformatet stds inte, sparat som det r", 
                           /* encoding is not supported, stored as-is -HTML*/
  "brev",                           /* messages          -HTML*/
  "Version",                        /* Version           -STDOUT*/
  "Patchniv",                   /* Patchlevel        -STDOUT*/
  "Dokumentation",                  /* Docs              -STDOUT*/
  "Kommando och kontrollvariabler", /* Command and Control Variables-STDOUT*/
  "Ja",                             /* Yes               -STDOUT*/
  "Nej",                            /* No                -STDOUT*/
  "Om arkivet: ej anvnd",      /* About the archive: not used-STDOUT */
  "Andra arkiv: ej anvnd",      /* Other archives: not used-STDOUT*/
  "adress ej anvnd",            /* address not used  -STDOUT*/
  "Inbyggd <BODY> anvnd",       /* Builtin <BODY> statement used-STDOUT*/
  "Kan inte lsa bde frn fil och stdin.", 
                           /* Cannot read from both file and stdin. -STDERR*/
  "Alternativ",                     /* Options           -STDOUT*/
  "URL till andra arkiv",           /* URL to other archives  -STDOUT*/
  "URL till arkivinformation",      /* URL to archive information -STDOUT*/
  "Konfigurationsfil att lsa in",   /* Configuration file to read in -STDOUT*/
  "Directory att spara HTML-filerna i", 
                            /* The directory to save HTML files in -STDOUT*/
  "Ls breven frn standard in", /* Read messages from standard input-STDOUT*/
  "Namnet p utarkivet",         /* What to name the output archive-STDOUT*/
  "Brevarkiv att lsa in",       /* Mail archive to read in -STDOUT*/
  "Visa progress",                  /* Show progress      -STDOUT*/
  "Visa konfigurationsvariabler enbart",
                                /* Show configuration variables only-STDOUT*/
  "Visa versionsinformation och sluta", 
                                /* Show version information and exit -STDOUT*/
  "Updatera arkivet med ett brev", /*Update archive by one article -STDOUT*/
  "Skriv ver tidigare brev",    /* Overwrite previous messages -STDOUT*/
  "Ange sprk att anvnda",   /* Specify language to use -STDOUT*/
  "Anvndning",                  /* Usage                   -STDOUT*/
  "Sprk ej supportat",          /* Language not supported  -STDERR*/
  "Ej angivet",                     /* Not set                 -STDOUT*/
  "Ej anvnt",                   /* Not used                -STDOUT*/
  "Skapade bilagefil",          /* Created attachment file -STDOUT*/
  "bilaga",                      /* attachment              -HTML*/
  "mode",                           /* mode                    -STDOUT*/
  "Lser gamla headers",         /* Reading old headers     -STDOUT*/
  "",                               /* for alignment only   -STDOUT*/
  "FEL",                            /* ERROR                   -STDERR*/
  "Adressen fr att posta till listan", 
                           /* The submission address of the list-STDERR*/
  "Ls bara ett brev frn in",
  "Frfattare",                  /* author             -HTML*/
  "Datum",                          /* date               -HTML*/
  "mne",                        /* subject            -HTML*/
  "E-postfunktioner",                   /* Mail actions (MA) header -HTML*/
  "snd ett nytt mne",               /* MA New Message      -HTML*/
  "svara p brevet",        /* MA Reply            -HTML*/
  "Sammanfattning ver mnatliga indexfiler", /* monthly             -HTML*/
  "Sammanfattning ver rliga indexfiler",  /* yearly              -HTML*/
  "Bygger en GDBM-headercache",   /* Build a GDBM header cache   -STDOUT*/
  "GDBM header cache option not build in",
  		      /* GDBM header cache option not build in  -STDERR*/
  "Skapar gdbm-index... ",     /* Creating gdbm index         -STDOUT*/
  "Kan inte skapa gdbm-fil... ",  /* Can't create gdbm index     -STDOUT*/
  "Underhll ett mbox-arkiv",    /* Maintain an mbox archive    -STDOUT*/
  "Kan inte bde lsa frn och skriva till en mbox.", /* "Can't both read from and write to an mbox." -STDOUT*/
  "Bilagevy",                      /* Attachment view  -HTML*/
  "Efter brev med bilaga",	  /* By messages with attachments -HTML*/
  "Skriver bilageindex till",	  /* Writing attachment index to -STDOUT*/
  "byte",		    /* file size, so far only for attachments  -HTML */
  "Kan inte skapa symbolisk lnk", /* MSG_CANNOT_CREATE_SYMLINK     -STDOUT */
  "Kan inte ta bort fil", /* MSG_CANNOT_UNLINK                       -STDOUT */
  "Fregende mapp",  /* MSG_PREV_DIRECTORY                     -HTML */
  "Nsta mapp",      /* MSG_NEXT_DIRECTORY                     -HTML */
  "Mapplista",  /* MSG_FOLDERS_INDEX                      -HTML */
  "Detta brev har tagits bort frn arkivet", /* MSG_DELETED -HTML */
  "Detta brev har utgtt",                       /* MSG_EXPIRED -HTML */
  "(borttaget brev)", /* MSG_DEL_SHORT                            -HTML */
  "Ursprunglig brevtext", /* MSG_TXT_VERSION                          -HTML */
  "This message has been filtered out",        /* MSG_FILTERED_OUT -HTML */
  "Frfattare",                     /* MSG_FROM             -HTML*/
  "Write haof XML files",       /* Write hoaf XML files       -STDOUT */
  "Writing haof to",            /* Writing haof to               -HTML*/
  NULL,                             /* End Of Message Table    - NOWHERE*/
};

/*
** Greek version of the language table
** Translation by Akis Karnouskos <akis@ceid.upatras.gr> 
**       STDOUT/STDERROR
**    ...
**         
**       update !
*/

char *gr[] = {       /* Greek */
  " ",              		/* New Message        -HTML*/
  "",                   	/* Reply              -HTML*/
  "    ",         	/* About this list    -HTML*/
  " ",                   	/* End of Messages    -HTML*/
  " ",                 	/* Start of Messages  -HTML*/
  "  ",            	/* Date view          -HTML*/
  "  thread",                	/* Thread view        -HTML*/
  "  ",                	/* Subject view       -HTML*/
  "  ",          	/* Author view        -HTML*/
  "A ",                      	/* Other groups       -HTML*/
  "",                          	/* Messages           -HTML*/
  "",                               /* Starting           -HTML*/
  "",                            	/* Ending             -HTML*/
  "    ",       	/* About this archive -HTML*/
  " ",            	/* sorted by 	      -HTML*/
  "A Mail ",                 	/* Other mail archives -HTML*/
  " ",                 	/* By Date             -HTML*/
  "   ",        	/* Most recent messages-HTML*/
  "",                        	/* author              -HTML*/
  "",          		/* date                -HTML*/
  "thread",                       	/* thread              -HTML*/
  "",                              	/* subject             -HTML*/
  " ",                      	/* for options       -STDOUT*/
  "   ",              /* Writing messages to-STDOUT*/
  "    ",    	/* Writing date index to-STDOUT*/
  "    thread",    	/* Writing thread index to -STDOUT*/
  "    ",     	/* Writing subject index to-STDOUT*/
  "    ",  	/* Writing author index to-STDOUT*/
  " ",              	/* Last message date   -HTML*/
  "",                   	/* Archived on         -HTML*/
  "    chmod",      	/* Can not chmod     -STDERR*/
  "   ",           	/* Could not write   -STDERR*/
  " ",                 	/* Next message        -HTML*/
  " ",                  /* Previous message    -HTML*/
  "   ",           	/* Maybe in reply to   -HTML*/
  "  ",               	/* In reply to         -HTML*/
  "  thread",                 /* Next in thread      -HTML*/
  " ",                   	/* Maybe reply         -HTML*/
  " Thread",                     	/* By Thread           -HTML*/
  " ",                         	/* By Subject          -HTML*/
  " ",                     	/* By Author           -HTML*/
  "     directory", /* Can not create directory -STDERR*/
  "  directory",          	/* Creating directory -STDOUT*/
  "configuration",                 	/* Configuration Values -STDOUT*/
  "path",                            	/* path              -STDOUT*/
  "    ", 	/* Ran out of memory!-STDERR*/
  "    ",  	/* This archive was generated by-HTML*/
  "",                        	/* Elements          -STDOUT*/
  " ",                	/* No Elements       -STDOUT*/
  "        ",     /* Cannot open mail archive */
  "   headers",    	/* Reading new header...-STDOUT*/
  "  mailbox",               	/* Loading mailbox      -STDOUT*/
  "   ,   ", 
                        		/* encoding is not supported, stored as-is -HTML*/
  "",                          	/* messages             -HTML*/
  "",                        	/* Version            -STDOUT*/
  "Patchlevel",               		/* Patchlevel         -STDOUT*/
  "",                          	/* Docs               -STDOUT*/
  "   ", 	/* Command and Control Variables-STDOUT*/
  "",                            	/* Yes                -STDOUT*/
  "",                         	/* No                 -STDOUT*/
  "   :  ",    /* About the archive: not used-STDOUT */
  "A :  ", 	/* Other archives: not used-STDOUT*/
  ":  ", 	/* address not used        -STDOUT*/
  "   <BODY> ",   	/* Builtin <BODY> statement used-STDOUT*/
  "         stdin.", /* Cannot read from both file and stdin. -STDERR*/
  "",                      	/* Options                -STDOUT*/
  "URL   ",           	/* URL to other archives  -STDOUT*/
  "URL      ",  
                                      	/* URL to archive information -STDOUT*/
  "     ", 
                                    	/* Configuration file to read in -STDOUT*/
  " directory     HTML  ", 
                              		/* The directory to save HTML files in -STDOUT*/
  "      ",
                                	/* Read messages from standard input -STDOUT*/
  "     ",   
                                  	/* What to name the output archive -STDOUT*/
  "  Mail-   ",            /* Mail archive to read in -STDOUT*/
  "  ",                	/* Show progress           -STDOUT*/
  "   ", 	/* Show configuration variables only -STDOUT*/
  "      ",             /* Show version information and exit -STDOUT*/
  "     ",  	/* Update archive by one article -STDOUT*/
  "     ", /* Overwrite previous messages -STDOUT*/
  "     ",                      /* Specify language to use -STDOUT*/
  "",                           	/* Usage -STDOUT*/
  "   ",		/* Language not supported  -STDERR*/
  " ",                        	/* Not set               -STDOUT*/
  " ",             	/* Not used              -STDOUT*/
  "  ",           /* Created attachment file -STDOUT*/
  "",                   	/* attachment           -HTML*/
  "",                        	/* mode                 -STDOUT*/
  "   headers",          	/* Reading old headers  -STDOUT*/
  "",       				/* for alignment only -STDOUT*/
  "",                       	/* ERROR                       -STDERR*/
  "      emails", 
                           		/* The submission address of the list-STDERR*/
  "   email   ", /* Read only one mail from input */
  "",                        	/* author              -HTML*/
  "",                      	/* date                -HTML*/
  "",                              	/* subject             -HTML*/
  "Mail ",                  	/* Mail actions (MA) header -HTML*/
  "    ",    	/* MA New Message      -HTML*/
  "    ",      	/* MA Reply            -HTML*/
  "   ",  	/* monthly             -HTML*/
  "   ",  	/* yearly              -HTML*/
  "Build a GDBM header cache",   	/* Build a GDBM header cache   -STDOUT*/
  "  gdbm ... ",   	/* Creating gdbm index         -STDOUT*/
  "     gdbm ... ",  /* Can't create gdbm index     -STDOUT*/
  "  mbox ",    	/* Maintain an mbox archive    -STDOUT*/
  "         mbox ", /* "Can't both read from and write to an mbox." -STDOUT*/
  " ",             	/* Attachment view       -HTML*/
  "   ",	/* By messages with attachments -HTML*/
  "    ",	  /* Writing attachment index to -STDOUT*/
  "bytes",		    		/* file size, so far only for attachments  -HTML */
  "      ", /* MSG_CANNOT_CREATE_SYMLINK     -STDOUT */
  "     ", 	/* MSG_CANNOT_UNLINK                       -STDOUT */
  " ",  		/* MSG_PREV_DIRECTORY                     -HTML */
  " ",      		/* MSG_NEXT_DIRECTORY                     -HTML */
  " ",  			/* MSG_FOLDERS_INDEX                      -HTML */
  "       ", /* MSG_DELETED -HTML */
  "    ",      	/* MSG_EXPIRED -HTML */
  "( )", 			/* MSG_DEL_SHORT                            -HTML */
  "   ", 	/* MSG_TXT_VERSION                          -HTML */
  "     ",  /* MSG_FILTERED_OUT -HTML */
  "",       			/* MSG_FROM              -HTML*/
  NULL,                           	/* End Of Message Table - NOWHERE*/
};




/*
** list of supported languages
*/

struct language_entry ltable[] = {
{    "de",      de,    "de_DE"   },     /* German  */
{    "en",      en,    "en_US"   },     /* English */
{    "es",      es,    "es_ES"   },     /* Spanish */
{    "fi",      fi,    "fi_FI"   },     /* Finnish */
{    "fr",      fr,    "fr_FR"   },     /* French  */
{    "is",      is,    "is_IS"   },     /* Icelandic */
{    "pl",      pl,    "pl_PL"   },     /* Polish  */
{    "sv",      sv,    "sv_SE"   },     /* Swedish */
{    "el",      gr,    "el"   	 },     /* Greek */
{    "gr",      gr,    "el_GR"   },     /* Greek */
{     NULL,     NULL 		 },     /* EOL    */
};

/*
** Default language table
*/
char **lang = en;

#else

extern char **lang;
extern struct language_entry ltable[];

#endif
