/* 
 * $smu-mark$ 
 * $name: usage.c$ 
 * $author: Salvatore Sanfilippo <antirez@invece.org>$ 
 * $copyright: Copyright (C) 1999 by Salvatore Sanfilippo$ 
 * $license: This software is under GPL version 2 of license$ 
 * $date: Fri Nov  5 11:55:50 MET 1999$ 
 * $rev: 8$ 
 */ 

#include <stdio.h>

void	show_usage(void)
{
	printf(
"usage: hping host [options]\n"
"  -h  --help      show this help\n"
"  -v  --version   show version\n"
"  -c  --count     packet count\n"
"  -i  --interval  wait (uX for X microseconds, for example -i u1000)\n"
"  -n  --numeric   numeric output\n"
"  -q  --quiet     quiet\n"
"  -I  --interface interface name (otherwise default routing interface)\n"
"  -V  --verbose   verbose mode\n"
"  -D  --debug     debugging info\n"
"  -z  --bind      bind ctrl+z to ttl           (default to dst port)\n"
"  -Z  --unbind    unbind ctrl+z\n"
"Mode\n"
"  default mode     TCP\n"
"  -0  --rawip      RAW IP mode\n"
"  -1  --icmp       ICMP mode\n"
"  -2  --udp        UDP mode\n"
"  -9  --listen     listen mode\n"
"IP\n"
"  -a  --spoof      spoof source address\n"
"  -t  --ttl        ttl (default 64)\n"
"  -N  --id         id (default random)\n"
"  -W  --winid      use win* id byte ordering\n"
"  -r  --rel        relativize id field          (to estimate host traffic)\n"
"  -f  --frag       split packets in more frag.  (may pass weak acl)\n"
"  -x  --morefrag   set more fragments flag\n"
"  -y  --dontfrag   set dont fragment flag\n"
"  -g  --fragoff    set the fragment offset\n"
"  -m  --mtu        set virtual mtu, implies --frag if packet size > mtu\n"
"  -o  --tos        type of service (default 0x00), try --tos help\n"
"  -G  --rroute     includes RECORD_ROUTE option and display the route buffer\n"
"  -H  --ipproto    set the IP protocol field, only in RAW IP mode\n"
"ICMP\n"
"  -C  --icmptype   icmp type (default echo request), try --icmptype help\n"
"  -K  --icmpcode   icmp code (default 0)\n"
"      --icmp-help  display help for others icmp options\n"
"UDP/TCP\n"
"  -s  --baseport   base source port             (default random)\n"
"  -p  --destport   [+][+]<port> destination port(default 0) ctrl+z inc/dec\n"
"  -k  --keep       keep still source port\n"
"  -w  --win        winsize (default 64)\n"
"  -O  --tcpoff     set fake tcp data offset     (instead of tcphdrlen / 4)\n"
"  -Q  --seqnum     shows only tcp sequence number\n"
"  -b  --badcksum   send packets with a bad IP checksum\n"
"  -M  --setseq     set TCP sequence number\n"
"  -L  --setack     set TCP ack\n"
"  -F  --fin        set FIN flag\n"
"  -S  --syn        set SYN flag\n"
"  -R  --rst        set RST flag\n"
"  -P  --push       set PUSH flag\n"
"  -A  --ack        set ACK flag\n"
"  -U  --urg        set URG flag\n"
"  -X  --xmas       set X unused flag (0x40)\n"
"  -Y  --ymas       set Y unused flag (0x80)\n"
"  --tcpexitcode    use last tcp->th_flags as exit code\n"
"Common\n"
"  -d  --data       data size                    (default is 0)\n"
"  -E  --file       data from file\n"
"  -e  --sign       add 'signature'\n"
"  -j  --dump       dump packets in hex\n"
"  -J  --print      dump printable characters\n"
"  -B  --safe       enable 'safe' protocol\n"
"  -u  --end        tell you when --file reached EOF and prevent rewind\n"
"  -T  --traceroute traceroute mode              (implies --bind)\n"
	);
	exit(0);
};

void tos_help(void)
{
	printf(
"tos help:\n"
"          TOS Name                Hex Value           Typical Uses\n"
"\n"
"       Minimum Delay                 10               ftp, telnet\n"
"       Maximum Throughput            08               ftp-data\n"
"       Maximum Reliability           04               snmp\n"
"       Minimum Cost                  02               nntp\n"
	);
	exit(0);
}

void icmp_help(void)
{
	printf(
"ICMP help:\n"
" ICMP concerned packet options:\n"
"  --icmp-ipver     set ip version               ( default 4 )\n"
"  --icmp-iphlen    set ip header lenght         ( default IPHDR_SIZE >> 2)\n"
"  --icmp-iplen     set ip total lengtht         ( default real lenght )\n"
"  --icmp-ipid      set ip id                    ( default random )\n"
"  --icmp-ipproto   set ip protocol              ( default IPPROTO_TCP )\n"
"  --icmp-cksum     set icmp checksum            ( default the right cksum)\n"
	);
	exit(0);
}
