<?php
/**
 * A standard Kolab user.
 *
 * $Horde: framework/Kolab_Server/lib/Horde/Kolab/Server/Object/user.php,v 1.2.2.3 2008/09/12 16:52:07 wrobel Exp $
 *
 * @package Kolab_Server
 */

/**
 * This class provides methods to deal with Kolab users stored in
 * the Kolab db.
 *
 * $Horde: framework/Kolab_Server/lib/Horde/Kolab/Server/Object/user.php,v 1.2.2.3 2008/09/12 16:52:07 wrobel Exp $
 *
 * Copyright 2008 The Horde Project (http://www.horde.org/)
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Gunnar Wrobel  <wrobel@pardus.de>
 * @package Kolab_Server
 */
class Horde_Kolab_Server_Object_user extends Horde_Kolab_Server_Object {

    /**
     * The LDAP filter to retrieve this object type
     *
     * @var string
     */
    var $filter = '(&(objectclass=kolabInetOrgPerson)(uid=*)(mail=*)(sn=*))';

    /**
     * The attributes supported by this class
     *
     * @var array
     */
    var $_supported_attributes = array(
        KOLAB_ATTR_SN,
        KOLAB_ATTR_CN,
        KOLAB_ATTR_FN,
        KOLAB_ATTR_UID,
        KOLAB_ATTR_MAIL,
        KOLAB_ATTR_DELETED,
		KOLAB_ATTR_IMAPHOST,
		KOLAB_ATTR_HOMESERVER,
		KOLAB_ATTR_IPOLICY,
        KOLAB_ATTR_FBFUTURE,
    );

    /**
     * Get the groups for this object
     *
     * @return mixed|PEAR_Error An array of group ids, false if no groups were
     *                          found.
     */
    function getGroups()
    {
        return $this->_db->getGroups($this->_dn);
    }

    /**
     * Returns the server url of the given type for this user.
     *
     * This method is used to encapsulate multidomain support.
     *
     * @return string The server url or empty on error.
     */
    function getServer($server_type)
    {
        switch ($server_type) {
        case 'imap':
            $server = $this->get(KOLAB_ATTR_IMAPHOST);
            if (!is_a($server, 'PEAR_Error') && !empty($server)) {
                return $server;
            }
        default:
            $home = $this->get(KOLAB_ATTR_HOMESERVER);
            return $home;
        }
    }
};
