<?php
// $Horde: horde/lib/Token.php,v 1.6.2.1 2002/04/05 01:24:24 jon Exp $

// Return codes
/** @constant TOKEN_OK Operation succeeded. */
define('TOKEN_OK', 0);

/** @constant TOKEN_ERROR Operation failed. */
define('TOKEN_ERROR', -1);

/** @constant TOKEN_ERROR_PARAMS Bad or missing parameters ($params). */
define('TOKEN_ERROR_PARAMS', -2);

/** @constant TOKEN_ERROR_CONNECT Connection failure. */
define('TOKEN_ERROR_CONNECT', -3);

/** @constant TOKEN_ERROR_AUTH Authentication failure. */
define('TOKEN_ERROR_AUTH', -4);

/** @constant TOKEN_ERROR_EMPTY Empty retrieval result. */
define('TOKEN_ERROR_EMPTY', -5);


/**
 * The Token:: class provides a common abstracted interface into the
 * various token generation mediums. It also includes all of the
 * functions for retrieving, storing, and checking tokens.
 *
 * @author  Max Kalika <max@horde.org>
 * @version $Revision: 1.6.2.1 $
 * @since   Horde 1.3
 * @package horde.token
 */
class Token {

    /**
     * Attempts to return a concrete Token instance based on $driver.
     *
     * @param string $driver   The type of concrete Token subclass to return.
     *                         This is based on the storage driver ($driver).  The
     *                         code is dynamically included.
     *
     * @param optional array $params  A hash containing any additional
     *                                configuration or connection parameters
     *                                a subclass might need.
     *
     * @return object Token The newly created concrete Token instance, or
     *                      false an error.
     */
    function &factory($driver, $params = array())
    {
        $driver = strtolower(basename($driver));
        if (empty($driver) || (strcmp($driver, 'none') == 0)) {
            return new Token;
        }

        if (@include_once dirname(__FILE__) . '/Token/' . $driver . '.php') {
            $class = 'Token_' . $driver;
            return new $class($params);
        } else {
            return false;
        }
    }

    function hexRemoteAddr()
    {
        global $HTTP_SERVER_VARS;

        $addr = explode('.', $HTTP_SERVER_VARS['REMOTE_ADDR']);
        return sprintf("%02x%02x%02x%02x", $addr[0], $addr[1], $addr[2], $addr[3]);
    }

    /**
     * Generates a connection id and returns it.
     *
     * @return string   The generated id string.
     */
    function generateID()
    {
        return md5(time() . '][' . Token::hexRemoteAddr());
    }

    /**
     * Checks if the given token has been previously used.  First
     * purges all expired tokens. Then retreives current tokens for
     * the given ip address. If the specified token was not found,
     * adds it.
     *
     * @param string $token  The value of the token to check.
     *
     * @return boolean       True if the token has not been used,
     *                       false otherwise.
     */
    function verify($token)
    {
        $this->purge();
        if ($this->exists($token)) {
            return false;
        }
        else {
            $this->add($token);
            return true;
        }
    }

    /**
     * This is basically an abstract method that should be overridden by a
     * subclass implementation. It's here to retain code integrity in the
     * case that no subclass is loaded ($driver == 'none').
     */
    function exists()
    {
        return false;
    }

    /**
     * This is basically an abstract method that should be overridden by a
     * subclass implementation. It's here to retain code integrity in the
     * case that no subclass is loaded ($driver == 'none').
     */
    function add()
    {
        return true;
    }

    /**
     * This is basically an abstract method that should be overridden by a
     * subclass implementation. It's here to retain code integrity in the
     * case that no subclass is loaded ($driver == 'none').
     */
    function purge()
    {
        return true;
    }
}
?>
