<?php
/*
 * $Horde: horde/prefs.php,v 2.1.2.2 2002/04/17 22:58:26 jan Exp $
 *
 * Copyright 1999-2002 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2002 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

/**
 * Call PrefsUI::groupIsEditable() here because we can rely on it being present
 * in Horde 2.1 but the prefs template still calls groupIsEditable().
 */
function groupIsEditable($group)
{
    return PrefsUI::groupIsEditable($group);
}

define('HORDE_BASE', dirname(__FILE__));
require_once HORDE_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/PrefsUI.php';
require HORDE_BASE . '/config/prefs.php';

if (!Auth::getAuth()) {
    header('Location: ' . Horde::applicationUrl('login.php'), true);
    exit;
}

/* See if we have a preferences group set. */
$group = Horde::getFormData('group');

if (PrefsUI::handleForm($group)) {
    $group = null;
    include HORDE_BASE . '/config/prefs.php';
}

if ($conf['compress_pages']) {
    ob_start('ob_gzhandler');
}

$title = _("User Options");
$js_onLoad = null;
require HORDE_TEMPLATES . '/common-header.inc';
$notification->notify();

/* Assign variables for select lists. */
if (!$prefs->isLocked('timezone')) {
    $timezone_options = &$tz;
}

/* Show the UI. */
PrefsUI::generateUI($group);

$registry->shutdown();
require HORDE_TEMPLATES . '/common-footer.inc';

?>
