<?php
// $Horde: horde/lib/base.php,v 1.3.2.3 2002/04/17 22:58:27 jan Exp $

/*
 * Horde base inclusion file.
 *
 * This file brings in all of the dependencies that Horde framework-level
 * scripts will need, and sets up objects that all scripts use.
 *
 * NB: this base file does _not_ check authentication, so as to avoid
 * an infinite loop on the Horde login page. You'll need to do it
 * yourself in framework-level pages.
 */

// Find the base file path of Horde
@define('HORDE_BASE', dirname(__FILE__) . '/..');

// Registry
require_once HORDE_BASE . '/lib/Registry.php';
$registry = &Registry::singleton();
$registry->pushApp('horde');
$conf = &$GLOBALS['conf'];
@define('HORDE_TEMPLATES', $registry->getParam('templates'));

// set error reporting according to config settings
error_reporting($conf['debug_level']);

// set max execution time according to config settings
set_time_limit($conf['max_exec_time']);

// Horde base libraries
require_once HORDE_BASE . '/lib/Horde.php';
require_once HORDE_BASE . '/lib/Auth.php';

// Browser detection object
require_once HORDE_BASE . '/lib/Browser.php';
$browser = new Browser();

// Notification System
require_once HORDE_BASE . '/lib/Notification.php';
$notification = &Notification::singleton();
$notification->attach('status');

?>
