<?php
// $Horde: horde/lib/MIME/Viewer/php.php,v 1.8.2.2 2002/04/05 01:24:30 jon Exp $

/**
 * The MIME_Viewer_php class renders out syntax-highlighted PHP
 * code in HTML format.
 *
 * @author  Anil Madhavapeddy <anil@recoil.org>
 * @version $Revision: 1.8.2.2 $
 * @since   Horde 1.3
 * @package horde.mime.viewer
 */
class MIME_Viewer_php extends MIME_Viewer {

    /**
     * Render out the currently set contents in HTML format.  The
     * $mime_part class variable has the information to render out,
     * encapsulated in a MIME_Part object.
     */
    function render($params = null)
    {
        ob_start();
        highlight_string($this->mime_part->getContents());
        $pretty = ob_get_contents();
        ob_end_clean();
        return $pretty;
    }

    /**
     * Return text/html as the content-type.
     *
     * @return string "text/html" constant
     */
    function getType()
    {
        return 'text/html';
    }

}
