<?php
// $Horde: horde/lib/MIME/Magic.php,v 1.3.2.4 2002/04/05 01:24:28 jon Exp $

/**
 * The MIME_Magic:: class provides an interface to determine a
 * MIME type for various content, if it provided with different
 * levels of information.
 *
 * Currently, it can map a file extension to a MIME type, but
 * future ideas include using Apache's mod_mime_magic (if available),
 *
 * @author  Anil Madhavapeddy <anil@recoil.org>
 * @version $Revision: 1.3.2.4 $
 * @since   Horde 1.3
 * @package horde.mime
 */
class MIME_Magic {

    /**
     * Attempt to convert a file extension to a MIME type, based
     * on the global Horde and application specific config files.
     *
     * If we cannot map the file extension to a specific type, then
     * we fall back to a custom MIME handler x-extension/type, which
     * can be used as a normal MIME type internally throughout Horde.
     *
     * @param string $ext The file extension to be mapped to a MIME type
     * @return string The MIME type of the file extension
     */
    function extToMIME($ext)
    {
        global $mime_extension_map;

        if (empty($ext)) {
           return 'text/plain';
        } else if (!isset($mime_extension_map[$ext])) {
            return "x-extension/$ext";
        } else {
            return $mime_extension_map[$ext];
        }
    }

    /**
     * Attempt to convert a MIME type to a file extension, based
     * on the global Horde and application specific config files.
     *
     * If we cannot map the type to a file extension, we return false.
     *
     * @param string $type The MIME type to be mapped to a file extension
     * @return string      The file extension of the MIME type
     */
    function MIMEToExt($type)
    {
        global $mime_extension_map;

        $map = array_flip($mime_extension_map);

        if (empty($type) || !isset($map[$type])) {
            list($major, $minor) = explode('/', $type);
            if ($major == 'x-extension') {
                return $minor;
            }
            return false;
        } else {
            return $map[$type];
        }
    }

}
?>
