<?php
/*
 * $Horde: horde/login.php,v 2.55.2.6 2002/01/02 17:05:08 jan Exp $
 *
 * Copyright 1999-2002 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2002 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 */

define('HORDE_BASE', dirname(__FILE__));
require_once HORDE_BASE . '/lib/base.php';

if (Horde::getFormData('reason') == 'logout') {
    if ($registry->hasMethod('auth/logout')) {
        $url = Horde::getFormData('url', Horde::selfURL());
        header('Location: ' . str_replace('&amp;', '&', Horde::url($registry->link('auth/logout', array('url' => Horde::url($url, true))), true)));
        exit;
    } else {
        $entry = sprintf('User %s [%s] logged out of Horde',
                         Auth::getAuth(), $HTTP_SERVER_VARS['REMOTE_ADDR']);
        Horde::logMessage($entry, __FILE__, __LINE__, LOG_NOTICE);
        Auth::clearAuth();
        session_destroy();
        @session_start();
    }
}

if (isset($HTTP_POST_VARS['horde_user']) &&
    isset($HTTP_POST_VARS['horde_pass'])) {
    $auth = &Auth::singleton($conf['auth']['driver'], $conf['auth']['params']);
    if ($auth->authenticate(Horde::getFormData('horde_user'),
                            array('password' => Horde::getFormData('horde_pass')))) {
        $entry = sprintf('Login success for %s [%s] to Horde',
                         Auth::getAuth(), $HTTP_SERVER_VARS['REMOTE_ADDR']);
        $level = LOG_INFO;
    } else {
        $entry = sprintf('FAILED LOGIN for %s [%s] to Horde',
                         Horde::getFormData('horde_user'), $HTTP_SERVER_VARS['REMOTE_ADDR']);
        $level = LOG_ERR;
    }
    Horde::logMessage($entry, __FILE__, __LINE__, $level);
}

if (Auth::getAuth()) {
    if (Horde::getFormData('url')) {
        header('Location: ' . Horde::url(Horde::getFormData('url'), true));
        exit;
    }
}

if ($browser->hasFeature('wml')) {
    $registry->applications['horde']['templates'] .= '/wml';
}

$title = _("Horde Login");
if (Auth::getAuth()) {
    include_once HORDE_BASE . '/lib/Menu.php';
    $fullname = ucfirst(Auth::getAuth());
    $template = 'user.inc';
    $columns = array();
    foreach ($registry->applications as $app => $info) {
        if (isset($registry->services[$app]['horde']['summary'])) {
            $summary = $registry->callByPackage($app, 'horde/summary');
            if (!PEAR::isError($summary)) {
                $columns[] = $summary;
            }
        }
    }
    if (count($columns) > 0) {
        $width = round(100 / count($columns));
    }
} elseif ($registry->hasMethod('auth/login')) {
    $url = Horde::getFormData('url', Horde::selfURL());
    header('Location: ' . Horde::url($registry->link('auth/login', array('url' => Horde::url($url, true))), true));
    exit;
} else {
    $js_onLoad = 'setFocus()';
    $template = 'login.inc';
}
require $registry->getTemplatePath("horde") . '/common-header.inc';
require $registry->getTemplatePath("horde") . '/login/' . $template;
require $registry->getTemplatePath("horde") . '/common-footer.inc';

?>
