<?php
// $Horde: horde/lib/MIME/Viewer/enscript.php,v 1.7.2.1 2001/12/23 20:19:07 chuck Exp $

/**
 * The MIME_Viewer_enscript class renders out various content
 * in HTML format by using GNU Enscript.
 *
 * @author  Anil Madhavapeddy <anil@recoil.org>
 * @version $Revision: 1.7.2.1 $
 * @since   Horde 1.3
 * @package horde.mime.viewer
 */
class MIME_Viewer_enscript extends MIME_Viewer {

    /**
     * Render out the currently set contents using Enscript
     * The $mime_part class variable has the information to render
     * out, encapsulated in a MIME_Part object.
     * @return string HTML pretty-print of the content
     */
    function render($params = null)
    {
        global $mime_drivers;

        /* Create temporary files for both input and output to Enscript */
        /* Note that we cannot use a pipe, since enscript must have access to 
         * the whole file to determine its type for coloured syntax highlighting */
        $tmpin = Horde::getTempFile();
        $tmpout = Horde::getTempFile();

        /* Write the contents of our buffer to the temporary input file */
        $fout = fopen($tmpin, 'wb');
        $contents = $this->mime_part->getContents();
        fwrite($fout, $contents, strlen($contents));
        fclose($fout);

        /* Execute the enscript command */ 
        exec(escapeShellCmd($mime_drivers['horde']['enscript']['location'] . " -Ec --color -Whtml -p$tmpout $tmpin"));
        $fin = fopen($tmpout, 'r');
        $results = '';
        while ($chunk = fread($fin, 4096)) {
            $results .= $chunk;
        }

        /* Strip out the extraneous HTML from Enscript, and output it.
         * TODO: figure out why this doesn't work with preg_replace! - avsm */
        $res_arr = preg_split('/\<\/?PRE\>/', $results);
        if (sizeof($res_arr) == 3) { 
            return '<pre>' . $res_arr[1] . '</pre>';
        }
    }

    function getType()
    {
        return 'text/html';
    }

}
