<?php
// $Horde: horde/lib/Cache.php,v 1.2 2001/08/22 04:27:07 jon Exp $

/** @constant CACHE_IMS If Modified Since Cache request */
define('CACHE_IMS', -1);

/**
 * The Cache:: class provides a common abstracted interface into the
 * various caching backends.  It also provides functions for checking
 * in, retrieving, and flushing a cache.
 *
 * @author  Anil Madhavapeddy <anil@recoil.org>
 * @version $Revision: 1.2 $
 * @since   Horde 1.3
 * @package horde.cache
 */
class Cache {
    
    /**
     * Attempts to return a concrete Cache instance based on $driver.
     * 
     * @param string $driver    The type of concrete Cache subclass to return.
     *                          This is based on the storage driver ($driver).
     *                          The code is dynamically included.
     * @param array $params     (optional) A hash containing any additional
     *                          configuration or connection parameters a
     *                          subclass might need.
     *
     * @return object Cache     The newly created concrete Cache instance, or
     *                          false on error.
     */
    function &factory($driver, $params = array())
    {
        /* Return a base Cache object if no driver is specified. */
        $driver = strtolower(basename($driver));
        if (empty($driver) || (strcmp($driver, 'none') == 0)) {
            return new Cache;
        }

        @include_once dirname(__FILE__) . '/Cache/' . $driver . '.php';
        $class = 'Cache_' . $driver;
        if (class_exists($class)) {
            return new $class($params);
        } else {
            return false;
        }
    }

    /**
     * Attempts to store an object in the cache.
     *
     * @param string $oid  Object ID used as the caching key.
     * @param mixed $data  Data to store in the cache.
     * @return boolean     True on success, false on failure.
     */
    function store($oid, &$data)
    {
        return true;
    }

    /**
     * Attempts to retrieve a cached object.
     *
     * @param string $oid  Object ID to query.
     * @param enum $type   Expiration heuristic.
     *                      CACHE_IMS: Expire if supplied value is greater than
     *                      cached time
     * @param int $val     Value to supply for the expiration heuristic.
     * @return mixed       Cached data, or false if none was found.
     */
    function query($oid, $type = CACHE_IMS, $val = 0)
    {
        return false;
    }

}

?>
