#Plugin Name: Highlight
#Plugin URI: http://www.andre-simon.de
#Description: Plugin which uses the highlight utility to generate coloured source code
#Author: André  Simon
#Version: 1.1
#Author URI: http://www.andre-simon.de/

package MT::Plugin::Highlight;

use strict;
use IPC::Open3;
use MT;
use MT::Entry;
use MT::Plugin;
use MT::Template::Context;
use MT::WeblogPublisher;

my $plugin = new MT::Plugin();
$plugin->name("MT Highlight");
$plugin->description('Source code highlighter using highlight (http://www.andre-simon.de)');
$plugin->doc_link('http://wiki.andre-simon.de/');
$plugin->author_name('Andre Simon');
$plugin->author_link('http://www.andre-simon.de/');
$plugin->plugin_link('http://wiki.andre-simon.de/');
$plugin->version('1.1');

MT->add_callback("BuildPage", 1, $plugin, \&highlight_callback);
MT->add_plugin($plugin);


#my %hl_options= ();
#$hl_options{'hl_binary'}='highlight';  # path to the highlight binary
#$hl_options{'linenumbers'}=0;
#$hl_options{'linenumber-start'}=1;
#$hl_options{'linenumber-zeroes'}=1;  # set to 1 if line numbers should be padded with zeros
#$hl_options{'linenumber-length'}=2;
#$hl_options{'reformat-style'}="gnu"; # possible values for C, C++ and Java Code: ansi, gnu, java, kr, linux
#$hl_options{'replace-tabs'}=4;       # number of spaces which replace a tab
#$hl_options{'wrap-style'}=2;         # 0 -> disable, 1-> wrap, 2-> wrap and indent function names
#$hl_options{'wrap-line-length'}=80;  # if wrap-style <>0, this defines the line length before wrapping takes place


sub highlight_callback
{
   my ($cb, %args) = @_;
   use Data::Dumper;
   my $html = ${$args{'Content'}};
   $html =~ s/<highlight([^>]*?)lang="([^"]+?)"([^>]*?)>(.*?)<\/highlight>/highlight_code($2,$4)/ges;
   ${$args{'Content'}} = $html;
   return 1;
}

sub highlight_code
{
   my ($lang, $source) = @_;

   $lang =~ s/[^a-zA-Z]//g;   #delete special chars in user input
   $source =~ s/\<br \/\>//g; #get rid of <br> Tags inserted by MT
   $source =~ s/\<\/?p\>//g;  # MT inserts <p> Tags if <, > are present in input code

   #return "SOURCE:<br><pre>".$source."</pre>";

   local(*HIS_IN, *HIS_OUT, *HIS_ERR);

   my @hl_args = ('-f', "-S$lang");
  # if ($hl_options{'linenumbers'}==1) 
   push (@hl_args, '-l'); # linenumbers
   push (@hl_args, '-j2'); # linenumber length
   push (@hl_args, '-z'); # linenumber zeroes
   push (@hl_args, '-Fgnu'); # reformat
   push (@hl_args, '-t4'); # replace tabs
   my $childpid = IPC::Open3::open3(*HIS_IN, *HIS_OUT, *HIS_ERR, 'highlight', @hl_args);
   print HIS_IN $source;
   close(HIS_IN);            # Give end of file to kid.
   my @outlines = <HIS_OUT>; # Read till EOF.

   close HIS_OUT;
   close HIS_ERR;
   waitpid($childpid, 0);

   my $htext = join "", @outlines;

   return "<pre class=\"hl\">".$htext."</pre>";
}



