#ifndef _CLIENT_H
#define _CLIENT_H

#include <stdbool.h>
#include "global.h"
#include "libip.h"
#include "serverconfig.h"
#include "session.h"

#define ca_TOOMUCH_PERIP  -1
#define ca_TOOMUCH_TOTAL  -2
#define ca_BANNED         -3

void init_client_module(void);
int  add_client(t_session *session);
int  mark_client_for_removal(t_session *session, int delay);
void check_delayed_remove_timers(t_config *config);
int  remove_client(t_session *session, bool free_session);
int  connection_allowed(t_ip_addr *ip, int maxperip, int maxtotal);
int  disconnect_clients(t_config *config);
bool client_is_flooding(t_session *session);
void check_flooding(t_config *config);

int  kick_client(int id);
int  kick_ip(t_ip_addr *ip);

int  ban_ip(t_ip_addr *ip, int timer, bool kick_on_ban);
int  reban_ip(t_ip_addr *ip);
void check_ban_list(t_config *config);
int  unban_ip(t_ip_addr *ip);

int  register_wrong_password(t_session *session);
void remove_wrong_password_list(t_config *config);

#ifdef HAVE_COMMAND
void print_client_list(FILE *fp);
int number_of_clients(void);
void print_ban_list(FILE *fp);
int number_of_bans(void);
#endif

#endif
