#ifndef _LIBCGI_H
#define _LIBCGI_H

#include <stdbool.h>
#include "liblist.h"
#include "session.h"

#define cgi_TIMEOUT              -3
#define cgi_FORCE_QUIT           -2
#define cgi_ERROR                -1
#define cgi_OKE                   0
#define cgi_END_OF_DATA           1

#define FCGI_VERSION_1           1

#define FCGI_BEGIN_REQUEST       1
#define FCGI_ABORT_REQUEST       2
#define FCGI_END_REQUEST         3
#define FCGI_PARAMS              4
#define FCGI_STDIN               5
#define FCGI_STDOUT              6
#define FCGI_STDERR              7
#define FCGI_DATA                8
#define FCGI_GET_VALUES          9
#define FCGI_GET_VALUES_RESULT  10
#define FCGI_UNKNOWN_TYPE       11
#define FCGI_MAXTYPE (FCGI_UNKNOWN_TYPE)

#define FCGI_REQUEST_COMPLETE    0
#define FCGI_CANT_MPX_CONN       1
#define FCGI_OVERLOADED          2
#define FCGI_UNKNOWN_ROLE        3

#define FCGI_HEADER_LENGTH       8

typedef struct type_cgi_info {
	int timer;
	struct timeval select_timeout;

	int to_cgi, from_cgi, cgi_error, highest_fd;

	char *input_buffer, *error_buffer;
	int input_buffer_size, input_len;
	int error_buffer_size, error_len;

	/* Normal CGI
	 */
	bool wrap_cgi;

	/* FastCGI
	 */
	bool read_header;
	char header[FCGI_HEADER_LENGTH];
	int fcgi_data_len;
} t_cgi_info;

void init_load_balancer(t_fcgi_server *fcgi_server);
t_connect_to *select_connect_to(t_fcgi_server *fcgi_server, unsigned long client_ip);
t_fcgi_server *fcgi_server_match(t_fcgi_server *fcgi_server, t_charlist *fastcgi, char *cgi_script);
void check_load_balancer(t_config *config);

pid_t fork_cgi_process(t_session *session, t_cgi_info *cgi_info);
int read_from_cgi_process(t_session *session, t_cgi_info *cgi_info);

int connect_to_fcgi_server(t_connect_to *connect_to);
int send_fcgi_request(t_session *session, int sock);
int read_from_fcgi_server(t_session *session, t_cgi_info *cgi_info);

#endif
