#include "config.h"

#ifndef _LIBSTR_H
#define _LIBSTR_H

#include <stdbool.h>

int str2int(const char *str);
char *remove_spaces(char *str);
char *strip_line(char *str);
char *strlower(char *line);
int split_string(const char *str, char **key, char **value, char c);
bool valid_uri(char *uri);
int parse_special_chars(char *line, int length);
int prevent_CMDi(char *line);
int prevent_SQLi(char *line, int length, char **newline);
int prevent_XSS(char *line);
const char *errorstr(int code);
bool decode_base64(char *base64);
char *file_extension(char *filename);
char *str_replace(char *line, char *from, char *to);
#ifndef HAVE_STRCASESTR
char *strcasestr(char *haystack, char *needle);
#endif

#endif
