#ifndef _LIBLIST_H
#define _LIBLIST_H

#include <stdbool.h>

typedef enum { deny, allow, pwd, unknown } t_access;

typedef struct type_charlist {
	int  size;
	char **item;
} t_charlist;

typedef struct type_accesslist {
	unsigned long ip;
	int netmask;
	t_access access;

	struct type_accesslist *next;
} t_accesslist;

typedef struct type_keyvalue {
	char *key;
	char *value;

	struct type_keyvalue *next;
} t_keyvalue;

typedef struct type_denybotlist {
	char *bot;
	t_charlist uri;

	struct type_denybotlist *next;
} t_denybotlist;

void sfree(void* ptr);

void init_charlist(t_charlist *list);
int parse_charlist(char *value, t_charlist *list);
bool in_charlist(char *item, t_charlist *list);

int parse_ip(char *line, unsigned long *l_ip);
t_accesslist *parse_accesslist(char *line, bool pwd_allowed, t_accesslist *list);
t_accesslist *remove_accesslist(t_accesslist *list);
t_access ip_allowed(unsigned long ip, t_accesslist *list);

t_keyvalue *parse_keyvaluelist(char *line, t_keyvalue *kvlist, char seperator);
t_keyvalue *remove_keyvaluelist(t_keyvalue *list);

#endif
