DESCRIPTION="Advanced and secure webserver"
HOMEPAGE="http://hiawatha.leisink.org/"
LICENSE="GPL"
KEYWORDS="x86"
SRC_URI="http://projects.leisink.org/files/${P}.tar.gz"
SLOT="0"
IUSE="ssl"
DEPEND="virtual/libc"

src_unpack() {
	unpack ${P}.tar.gz
	cd ${P}
}

src_compile() {
	./configure --sbindir=/usr/sbin --mandir=/usr/share/man --sysconfdir=/etc --localstatedir=/var --enable-ssl --enable-cache --enable-lfs || die
	make
}

src_install() {
	into /usr
	dosbin hiawatha

	doman doc/hiawatha.1

	exeinto /etc/init.d
	doexe ${S}/extra/gentoo/hiawatha

	insinto /etc/hiawatha
	doins  ${S}/etc/hiawatha/httpd.conf
	doins  ${S}/etc/hiawatha/mime.types
	doins  ${S}/etc/hiawatha/throttle.conf

	insinto /var/www
	doins ${S}/doc/hiawatha.html
}
