#ifndef _SESSION_H
#define _SESSION_H

#include "config.h"
#include <time.h>
#ifdef HAVE_SSL
#include "libssl.h"
#endif
#include "liblist.h"
#include "serverconfig.h"

#define MAX_CHILD_ID 30000
#define OUTPUT_BUFFER_SIZE 2000

typedef enum { none, program, script, fastcgi} t_cgi_type;
#ifdef HAVE_SSL
typedef enum { missing_slash, require_ssl } t_cause_of_301;
#endif

typedef struct type_headerfield {
	char *data;
	int  value_offset;

	struct type_headerfield *next;
} t_headerfield;

typedef struct type_session {
	t_config        *config;

	int             client_id;
	int             client_socket;
	t_binding       *binding;
	bool            socket_open;
	bool            head_request;
	bool            keep_alive;
	int             kept_alive;
	t_cgi_type      cgi_type;
	char            *cgi_handler;
	t_fcgi_server   *fcgi_server;
	char            *request, *method, *uri, *path_info, *vars, *http_version, *body, *file_on_disk;
	long            header_length, content_length, buffer_size, bytes_in_buffer;
#ifdef HAVE_REWRITE
	char            *script_url;
#endif
	int             uri_len;
	bool            data_sent;
	char            *local_user;
	bool            force_quit;
	bool            uri_is_dir;
	bool            accept_gzip;
	bool            encode_gzip;
	bool            alias_used;
	t_headerfield   *headerfields;
	t_ipv4          ip_address;
	bool            ip_resolved;
	char            *mimetype;
	char            *hostname;
	t_host          *host;
	bool            host_copied;
	char            *remote_user;
	t_directory     *directory;
	bool            handling_error;
	char            *reason_for_403;
	char            *cookie;
	off_t           bytes_sent;
	int             return_code;
	int             error_code;
	t_tempdata      *tempdata;
	bool            put_method;
	char            *uploaded_file;
	long            uploaded_size;

	/* Throttling: send_buffer() in send.c
	 */
	long            throttle;
	long            bytecounter;
	int             throttle_timer;
	bool            part_of_dirspeed;

	/* Flooding protection
	 */
	time_t          flooding_timer;

	/* SSL
	 */
#ifdef HAVE_SSL
	SSL             *ssl_data;
	t_cause_of_301  cause_of_301;
#endif

	/* Output buffer
	 */
	char            output_buffer[OUTPUT_BUFFER_SIZE];
	int             output_size;

#ifdef DEBUG
	char            *status;
#endif
} t_session;

void init_session(t_session *session);
void reset_session(t_session *session);
void destroy_session(t_session *session);

void set_403_reason(t_session *session, int reason);
t_headerfield *parse_headerfields(char *line);
char *get_headerfield(char *key, t_headerfield *headerfields);
void remove_headerfields(t_session *session);

int  get_homedir(t_session *session, char *username);
bool duplicate_host(t_session *session);
bool is_volatile_object(t_session *session);
int  copy_directory_settings(t_session *session);
char *file_in_chroot(t_session *session, char *file);
bool client_is_rejected_bot(t_session *session);
void close_socket(t_session *session);

#ifdef DEBUG
void set_client_status(t_session *session, char *status);
#endif

#endif
