#ifndef _SEND_H
#define _SEND_H

#include <stdbool.h>
#include "session.h"

#define FCGI_BUFFER_SIZE 65535

typedef struct {
	int           sock;
	unsigned char data[FCGI_BUFFER_SIZE + 8];
	int           size;
	unsigned char mode;
} t_fcgi_buffer;

int send_buffer(t_session *session, const char *buffer, int size);
int send_header(t_session *session, int code);
int send_chunk(t_session *session, const char *chunk, int size);
int send_code(t_session *session, int code);
int send_directly(int sock, const char *buffer, int size);
int send_fcgi_buffer(t_fcgi_buffer *fcgi_buffer, const char *buffer, int size);

void send_basic_auth(t_session *session);
void send_digest_auth(t_session *session);

int write_buffer(int handle, const char *buffer, int size);

#endif
