#ifndef _LIBSSL_H
#define _LIBSSL_H

#include <stdbool.h>
#include <openssl/bio.h>
#include <openssl/ssl.h>

void ssl_init(char *buffer, int size);
SSL_CTX *ssl_binding(char *keyfile, char *CA_cert, int verify_depth, char *dh_file, char *ciphers);
bool ssl_accept(int sock, SSL **ssl, SSL_CTX *context);
int  ssl_receive(SSL *ssl, char *buffer, unsigned int maxlength);
int  ssl_send(SSL *ssl, char *buffer, unsigned int length);
int  ssl_close(SSL *ssl);
void ssl_cleanup(SSL_CTX *sslContext);
int  get_client_certificate(SSL *ssl_data, int size, char *subject, char *issuer);

#endif
