#ifndef _LIBLIST_H
#define _LIBLIST_H

#include <stdbool.h>
#include "global.h"

typedef enum { deny, allow, pwd, unknown } t_access;
typedef enum { tc_data, tc_charlist, tc_accesslist, tc_keyvalue } t_tempdata_type;

typedef struct type_charlist {
	int  size;
	char **item;
} t_charlist;

typedef struct type_accesslist {
	t_ipv4 ip;
	int netmask;
	t_access access;

	struct type_accesslist *next;
} t_accesslist;

typedef struct type_keyvalue {
	char *key;
	char *value;

	struct type_keyvalue *next;
} t_keyvalue;

typedef struct type_denybotlist {
	char *bot;
	t_charlist uri;

	struct type_denybotlist *next;
} t_denybotlist;

typedef struct type_tempdata {
	void *content;
	t_tempdata_type type;

	struct type_tempdata *next;
} t_tempdata;

void sfree(void* ptr);

void init_charlist(t_charlist *list);
int parse_charlist(char *value, t_charlist *list);
void copy_charlist(t_charlist *dest, t_charlist *src);
bool in_charlist(char *item, t_charlist *list);
void remove_charlist(t_charlist *list);

int parse_ip(char *line, t_ipv4 *l_ip);
t_accesslist *parse_accesslist(char *line, bool pwd_allowed, t_accesslist *list);
t_accesslist *remove_accesslist(t_accesslist *list);
t_access ip_allowed(t_ipv4 ip, t_accesslist *list);

int parse_keyvaluelist(char *line, t_keyvalue **kvlist, char *seperator);
t_keyvalue *remove_keyvaluelist(t_keyvalue *list);

int register_tempdata(t_tempdata **tempdata, void *data, t_tempdata_type type);
void remove_tempdata(t_tempdata *tempdata);

#endif
