#ifndef _LIBCGI_H
#define _LIBCGI_H

#include <stdbool.h>
#include "liblist.h"
#include "session.h"

#define FCGI_VERSION_1           1

#define FCGI_BEGIN_REQUEST       1
#define FCGI_ABORT_REQUEST       2
#define FCGI_END_REQUEST         3
#define FCGI_PARAMS              4
#define FCGI_STDIN               5
#define FCGI_STDOUT              6
#define FCGI_STDERR              7
#define FCGI_DATA                8
#define FCGI_GET_VALUES          9
#define FCGI_GET_VALUES_RESULT  10
#define FCGI_UNKNOWN_TYPE       11
#define FCGI_MAXTYPE (FCGI_UNKNOWN_TYPE)

#define FCGI_HEADER_LENGTH       8

typedef enum { cgi_TIMEOUT = -3, cgi_FORCE_QUIT, cgi_ERROR, cgi_OKE, cgi_END_OF_DATA } t_cgi_result;

typedef struct type_cgi_info {
	int timer;
	struct timeval select_timeout;

	int to_cgi, from_cgi, cgi_error, highest_fd;

	char *input_buffer, *error_buffer;
	int input_buffer_size, input_len;
	int error_buffer_size, error_len;

	/* Normal CGI
	 */
	bool wrap_cgi;

	/* FastCGI
	 */
	bool read_header;
	char header[FCGI_HEADER_LENGTH];
	int fcgi_data_len;
} t_cgi_info;

/* FastCGI server loadbalancer
 */
void init_load_balancer(t_fcgi_server *fcgi_server);
t_connect_to *select_connect_to(t_fcgi_server *fcgi_server, t_ipv4 client_ip);
t_fcgi_server *fcgi_server_match(t_fcgi_server *fcgi_server, t_charlist *fastcgi, char *cgi_script);
void check_load_balancer(t_config *config);

/* Normal CGI
 */
pid_t fork_cgi_process(t_session *session, t_cgi_info *cgi_info);
t_cgi_result read_from_cgi_process(t_session *session, t_cgi_info *cgi_info);

/* FastCGI server
 */
int connect_to_fcgi_server(t_connect_to *connect_to);
int send_fcgi_request(t_session *session, int sock);
t_cgi_result read_from_fcgi_server(t_session *session, t_cgi_info *cgi_info);

#endif
