#ifndef _CACHE_H
#define _CACHE_H

#include <stdbool.h>
#include "config.h"
#include "global.h"

#define TIME_IN_CACHE     60
#define MAX_CACHE_TIMER 3600

typedef struct type_cached_object {
	char          *file;
	char          *data;
	off_t         size;
	int           timer;
	time_t        last_changed;
	volatile int  in_use;
	t_ipv4        last_ip;

	struct type_cached_object *prev;
	struct type_cached_object *next;
} t_cached_object;

void init_cache_module(void);
t_cached_object *add_to_cache(t_session *session, char *file);
t_cached_object *search_cache(t_session *session, char *file);
void done_with_cached_object(t_cached_object *object, bool remove_object);
void check_cache(void);
#ifdef HAVE_COMMAND
void print_cache_list(FILE *fp);
int clear_cache(void);
off_t size_of_cache(void);
#endif

#endif
