%{
#define YYSTYPE int
%}

%token NUMBER
%left '&' '|' '^'
%left '>' '<'
%left '+' '-' 
%left '*' '/' '%'
%left '~' UMINUS
%%
list:		/* null */
	|	list '\n'
	|	list expr '\n' 		{ output($2); }
	| 	list error '\n'		{ yyerrok; }
	;
expr:		NUMBER			{ $$ = $1; }
	|	expr '+' expr		{ $$ = $1 + $3; }
	|	expr '-' expr		{ $$ = $1 - $3; }
	|	expr '*' expr		{ $$ = $1 * $3; }
	|	expr '/' expr		{ if ($3 == 0) 
						execerror("divide by zero\
error", "");
					$$ = $1 / $3; }
	|	expr '%' expr		{ if ($3 == 0) 
						execerror("divide by zero\
						error", "");
					$$ = $1 % $3; }
	|	expr '&' expr		{ $$ = $1 & $3; }
	|	expr '|' expr		{ $$ = $1 | $3; }
	|	expr '^' expr		{ $$ = $1 ^ $3; }
	|	'(' expr ')'		{ $$ = $2; }
	| 	'-' expr %prec UMINUS	{ $$ = -$2; }
	|	'~' expr 		{ $$ = ~$2; }
	|	'h'			{ printf("hex mode\n"); mode =\
kHex; }
	|	'd'			{ printf("decimal mode \n");
					mode = kDec; }
|	expr '>' expr		{ $$ = $1 >> $3; }
|	expr '<' expr		{ $$ = $1 << $3; }
	|	'o'			{ printf("octal mode \n");
					mode = kOct; }
	|	'q'			{ printf("Bye.\n"); exit(0); }
	|	'?'			{ help(); }
	|	'a'			{ aboutbox(); }
	|	'v'			{ vrs(); }
	;
%%
#include <stdio.h>
#include <ctype.h>
#include <signal.h>
#include <setjmp.h>

typedef enum {
	kDec,
	kHex,
	kOct,
	kBin
} outmode;

/*char progname[];*/
jmp_buf begin;
int lineno = 1;
outmode mode;

void output(int i) {
	switch (mode) {
		case kHex:
			printf("\t0x%x\n",i);
			break;
		case kOct:
			printf("\t0%o\n",i);
			break;
		case kDec:
			printf("\t%d\n",i);
			break;
		default:
			printf("hc panic: unrecognized output mode\n");
			exit(0);
	}
}

void execerror(char s[], char t[]) {
	warning(s,t);
	longjmp(begin, 0);
}

void yyerror(char s[]) {
	warning(s, "");
}

int warning(char s[], char t[]) {
	fprintf(stderr, "hc: %s\n", s);
	return 0;
}

void aboutbox() {
	printf("\thc -- the Hacker's Calculator\n");
	printf("\n\t(c)1998-2000 Brian Connors\n");
	vrs();
	printf("\tBased on hoc1 by Brian Kernighan and Rob Pike\n");
	printf("\tType ? to view the online help system.\n");
}

int vrs() {
	printf("\tv1.1 -- 15 September 2000\n");
	return 0;
}

void help() {
	printf("hc commands\n");
	printf("\th -- output in hexadecimal\n");
	printf("\to -- output in octal\n");
	printf("\td -- output in decimal\n");
	printf("\ta -- display about box\n");
	printf("\tv -- display version number\n");
	printf("\t? -- display this help screen\n");
	printf("\tq -- quit hc\n");
	printf("see man page for more information\n\n");
}

int yylex() {
	int c;

	while ((c = getchar()) == ' ' || c == '\t')
		;
	if (c == EOF)
		return 0;
	
	/* The following clause is subject to change, at least as
	 * soon as I figure out how to do mixed-radix entry. 
	 */
	
	if (isdigit(c)) {
		ungetc(c, stdin);
		scanf("%li",&yylval);
		return NUMBER;
	}
	if (c == '\n') 
		lineno++;
	return c;
}

int main (int argc, char *argv[]) {
	/*progname = argv[0];*/
	setjmp(begin);
	printf("hc ready. Type ? for help.\n\n");
	yyparse();
}
