#include <xterm.h>

#if OPT_HANGUL
#include "hfont.h"

/* ħ   ()     ʼ    */

static const int 
fcon_map1[] =
{
    0, 0,
    0, 0, 0, 0, 0, 0,		/* (ä),,,,, */
    0, 0,
    0, 0, 0, 1, 3, 3,		/* ,,,,Ǥ,Ǥ */
    0, 0,
    3, 1, 2, 4, 4, 4,		/* Ǥ,,,̤,̤,̤ */
    0, 0,
    2, 1, 3, 0			/* ,,Ѥ, */
};

/* ħ   ()     ʼ    */

static const int 
fcon_map2[] =
{
    0, 0,
    5, 5, 5, 5, 5, 5,		/* (ä),,,,, */
    0, 0,
    5, 5, 5, 6, 8, 8,		/* ,,,,Ǥ,Ǥ */
    0, 0,
    8, 6, 7, 9, 9, 9,		/* Ǥ,,,̤,̤,̤ */
    0, 0,
    7, 6, 8, 5			/* ,,Ѥ, */
};

/* ()   font index */

static const int 
vow_base[] =
{
    0, 0,
    0, 311, 314, 317, 320, 323,	/* (ä),,,,, */
    0, 0,
    326, 329, 332, 335, 339, 343,	/* ,,,,Ǥ,Ǥ */
    0, 0,
    347, 351, 355, 358, 361, 364,	/* Ǥ,,,̤,̤,̤ */
    0, 0,
    367, 370, 374, 378		/* ,,Ѥ, */
};

/* ()    ƴ  */

static const int 
vow_kind[] =
{
    0, 0,
    0, 0, 0, 0, 0, 0,		/* (ä),,,,, */
    0, 0,
    0, 0, 0, 1, 1, 1,		/* ,,,,Ǥ,Ǥ */
    0, 0,
    1, 1, 0, 0, 0, 0,		/* Ǥ,,,̤,̤,̤ */
    0, 0,
    0, 1, 1, 0			/* ,,Ѥ, */
};

/* (ħ)    翡  */

static const int 
lcon_kind[] =
{
    0, 0, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
};

/* ()   ħ   */

static const int 
lcon_map[] =
{
    0, 0,
    0, 0, 2, 0, 2, 1,
    0, 0,
    2, 1, 2, 3, 0, 0,
    0, 0,
    0, 3, 3, 1, 1, 1,
    0, 0,
    3, 3, 0, 1
};

/*  ڸ 3 Ʈ  ٲ۴. */

static void 
convert_johab_to_3(Char *src, int *f, int *m, int *l)
{
    if (src[0] >= 0x84 && src[0] <= 0xd3) {	/*  ѱ */
	*f = (src[0] >> 2) & 0x1f;
	*m = ((src[0] << 3) | (src[1] >> 5)) & 0x1f;
	*l = src[1] & 0x1f;
    } else {			/* Ư  */
	*f = 0xff;
	if (src[0] >= 0xd9 && src[0] <= 0xde) {		/* ɹ */
	    *m = (src[0] - 0xd9) * 2 + 0xa1;
	} else if (src[0] >= 0xe0 && src[0] <= 0xf9) {	/*  */
	    *m = (src[0] - 0xe0) * 2 + 0xca;	/* good */
	} else if (src[0] == 0xd8) {
	    *m = 0xc9;
	}
	if (src[1] >= 0x31 && src[1] <= 0x7e) {
	    *l = src[1] - 0x31 + 0xa1;
	} else if (src[1] >= 0x91 && src[1] <= 0xa0) {
	    *l = src[1] - 0x91 + (0x7f - 0x31) + 0xa1;
	} else if (src[1] >= 0xa1 && src[1] <= 0xfe) {
	    *l = src[1];
	    if (src[0] == 0xd8) {
		*m = 0xfe;
	    } else {
		(*m)++;
	    }
	} else {
	    *l = 0;
	}
    }
}

static int 
convert_3_to_johabfont(int f, int m, int l, XChar2b *des)
{
    int ind;
    int i;

    i = 0;
    if (f == 0xff) {		/* ׷ ڵ */
	ind = (m - 0xa1) * 94 + l - 0xa1 + 0x211;
	des[i].byte1 = ind / 256;
	des[i].byte2 = ind % 256;
	return 1;
    }
    if (f < 1 || f > 20 || m < 2 || m > 29 || l < 1 || l > 29) {
	des[i].byte1 = 0;	/*  */
	des[i].byte2 = 0;
	return 1;
    }
    if (f != 1) {		/* ä ƴϸ ... */
	ind = f * 10 + (l > 1 ? fcon_map2[m] : fcon_map1[m]) - 19;
	des[i].byte1 = ind >> 8;
	des[i].byte2 = ind;
	i++;
    }
    if (m != 2) {		/* ä ƴϸ ... */
	ind = vow_base[m];
	switch (vow_kind[m]) {
	case 0:		/*  迭 ƴϸ ... */
	    ind += lcon_kind[l];
	    break;
	case 1:		/* , Ǥ, Ǥ, ... 迭 */
	    ind += ((f == 2 || f == 17) ? 0 : 1) + (l > 1 ? 2 : 0);
	    /* , ϶ Ưó */
	    break;
	}
	des[i].byte1 = ind >> 8;
	des[i].byte2 = ind;
	i++;
    }
    if (l != 1) {
	ind = l * 4 + lcon_map[m] + (l < 18 ? 397 : 393);
	/* l == 18 ϶ ƹħ ƴϱ⶧
	   Ư ó */
	des[i].byte1 = ind >> 8;
	des[i].byte2 = ind;
	i++;
    }
    if (f != 1 && m == 2 && l == 1) {	/* initial sound only? */
	des[i].byte1 = 0;	/* dummy for no zero width */
	des[i].byte2 = 0;
	i++;
    }
    return i;
}

static int 
convert_3_to_jo844font(int f, int m, int l, XChar2b *des)
{
    int ind;
    int i = 0;

    unsigned h1, h2, h3, type1, type2, type3;
    static char index1[] =
    {
	0, 0, 1, 2, 3, 4, 5, 6,
	7, 8, 9, 10, 11, 12, 13, 14,
	15, 16, 17, 18, 19, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0
    };
    static char index2[] =
    {
	0, 0, 0, 1, 2, 3, 4, 5,
	0, 0, 6, 7, 8, 9, 10, 11,
	0, 0, 12, 13, 14, 15, 16, 17,
	0, 0, 18, 19, 20, 21, 0, 0
    };
    static char index3[] =
    {
	0, 0, 1, 2, 3, 4, 5, 6,
	7, 8, 9, 10, 11, 12, 13, 14,
	15, 16, 0, 17, 18, 19, 20, 21,
	22, 23, 24, 25, 26, 27, 0, 0
    };
    static char type1_no[] =
    {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3,
	3, 3, 1, 2, 4, 4, 4, 2, 1, 3, 0
    };
    static char type1_yes[] =
    {
	5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 7,
	7, 7, 6, 6, 7, 7, 7, 6, 6, 7, 5,
    };
    static char _type3[] =
    {
	0, 0, 2, 0, 2, 1, 2, 1, 2, 3, 0,
	2, 1, 3, 3, 1, 2, 1, 3, 3, 1, 1
    };


    if (f == 0xff || f < 1 || f > 20 || m < 2 || m > 29 || l < 1 || l > 29) {
	des[i].byte1 = 0;	/*  */
	des[i].byte2 = 0;
	return 1;
    }
    h1 = index1[f];
    h2 = index2[m];
    h3 = index3[l];
    /* ʼ :
       ħִ Ϳ ߼ : ħ Ϳ 
     */
    type1 = h3 ? type1_yes[h2] : type1_no[h2];
    /* ߼ :
       ʼ ų   ̸  ϰ (Ÿ 1),
       ħ  2 ϰ (ƴ 0) */
    type2 = ((h1 == 0 || h1 == 1 || h1 == 16) ? 0 : 1) + (h3 ? 2 : 0);
    type3 = _type3[h2];


    i = 0;
    if (h1) {
	ind = type1 * 20 + h1;
	des[i].byte1 = ind >> 8;
	des[i].byte2 = ind;
	i++;
    }
    if (h2) {
	ind = type2 * 22 + h2 + 160;
	des[i].byte1 = ind >> 8;
	des[i].byte2 = ind;
	i++;
    }
    if (h3) {
	ind = type3 * 28 + h3 + 160 + 88;
	des[i].byte1 = ind >> 8;
	des[i].byte2 = ind;
	i++;
    }
    if (f != 1 && m == 2 && l == 1) {
	des[i].byte1 = 0;
	des[i].byte2 = 0;
	i++;
    }
    return i;
}


static int 
convert_johab_to_ks1font(Char *src, XChar2b *des, int len)
{
    XChar2b *desorg = des;
    Char tmp[400];
    johab_to_wansung_str(tmp, src, len);
    src = tmp;
    while (len > 0) {
	des->byte1 = (*src++);
	des++->byte2 = (*src++);
	len -= 2;
    }
    return (int) (des - desorg);
}

static int 
convert_ks_to_ks1font(Char *src, XChar2b *des, int len)
{
    XChar2b *desorg = des;
    while (len > 0) {
	des->byte1 = (*src++);
	des++->byte2 = (*src++);
	len -= 2;
    }
    return (int) (des - desorg);
}

static int 
convert_johab_to_ksfont(Char *src, XChar2b *des, int len)
{
    XChar2b *desorg = des;
    Char tmp[400];
    johab_to_wansung_str(tmp, src, len);
    src = tmp;
    while (len > 0) {
	des->byte1 = (*src++) & 0x7f;
	des++->byte2 = (*src++) & 0x7f;
	len -= 2;
    }
    return (int) (des - desorg);
}

static int 
convert_ks_to_ksfont(Char *src, XChar2b *des, int len)
{
    XChar2b *desorg = des;
    while (len > 0) {
	des->byte1 = (*src++) & 0x7f;
	des++->byte2 = (*src++) & 0x7f;
	len -= 2;
    }
    return (int) (des - desorg);
}

static int 
convert_johab_to_johabfont(Char *src, XChar2b *des, int len)
{
    int n, f, m, l;
    XChar2b *desorg = des;
    while (len > 0) {
	convert_johab_to_3(src, &f, &m, &l);
	n = convert_3_to_johabfont(f, m, l, des);
	src += 2;
	len -= 2;
	des += n;
    }
    return (int) (des - desorg);
}

static int 
convert_ks_to_johabfont(Char *src, XChar2b *des, int len)
{
    int n, f, m, l;
    XChar2b *desorg = des;
    char *johabs;
    if (len < 0)
	len = strlen(src);
    johabs = malloc(len+1);
    len = johab_from_wansung_str(johabs, src, len);
    len = convert_johab_to_johabfont(johabs, des, len);
    free(johabs);
    return len;
}

static int 
convert_johab_to_jo844font(Char *src, XChar2b *des, int len)
{
    int n, f, m, l;
    XChar2b *desorg = des;
    while (len > 0) {
	convert_johab_to_3(src, &f, &m, &l);
	n = convert_3_to_jo844font(f, m, l, des);
	src += 2;
	len -= 2;
	des += n;
    }
    return (int) (des - desorg);
}

static int 
convert_ks_to_jo844font(Char *src, XChar2b *des, int len)
{
    int n, f, m, l;
    char *johabs;
    if (len < 0)
	len = strlen(src);
    johabs = malloc(len+1);
    len = johab_from_wansung_str(johabs, src, len);
    len = convert_johab_to_jo844font(johabs, des, len);
    free(johabs);
    return len;
}

ConvertCodeToFontFunction
kscode_to_font[] = 
{
    convert_ks_to_ksfont,
    convert_ks_to_ks1font,
    convert_ks_to_johabfont,
    convert_ks_to_jo844font
};

ConvertCodeToFontFunction
johabcode_to_font[] = 
{
    convert_johab_to_ksfont,
    convert_johab_to_ks1font,
    convert_johab_to_johabfont,
    convert_johab_to_jo844font
};

#endif
