/*
 * hangul
 */
#ifndef __HANGUL_H
#define __HANGUL_H 1
#if OPT_HANGUL

#include <stdio.h>
#include "proto.h"

#define H_STRINGIFY_ARG(a) #a
#define H_STRINGIFY(a) H_STRINGIFY_ARG(a)

#define S_HANGUL	"[ѱ]"
#define S_ENGLISH	"[]"
#define S_WANSUNG	"[ϼ]"
#define S_JOHAB	        "[]"
#define S_UTF8		"[UTF8]"
#define S_2BULSIK	"[ι]"
#define S_3BULSIK	"[]"
#define S_CODEINPUT     "ڵ>"

#define C_WANSUNG	0		     /* Hangul Code  */
#define C_JOHAB		1
#define C_UTF8		2
#define	TEXT_BUF_SIZE	256

extern Char han_compose_buf[];
extern int hanja_mode;
extern int hangul_state;
extern int han_in_seq;
extern int han_eng_lift;
extern int han_eng_ascent;
extern int han_eng_descent;
extern int han_no_status_line;
extern int han_font_width_check;

#define XtNhangulFont  "hangulFont"
#define XtNhangulBoldFont  "hangulBoldFont"
#define XtNhangulCode  "hangulCode"
#define XtNallowShuffle  "allowShuffle"
#define XtNhangulKeyboard "hangulKeyboard"
#define XtNhangulFontType "hangulFontType"
#define XtNescHangulToggle "escHangulToggle"
#define XtNkeepBaseLine "keepBaseLine"
#define XtNnoStatusKbd     "noStatusKbd"
#define XtNnoStatusCode     "noStatusCode"
#define XtNnowChatScroll   "nowChatScroll"
#define XtNdubyolKeyboardFile	"dubyolKeyboardFile"
#define XtNsebyolKeyboardFile	"sebyolKeyboardFile"
#define XtNstatusEnglishLabel "statusEnglishLabel"
#define XtNstatusHangulLabel "statusHangulLabel"
#define XtNstatusEnglishLabel "statusEnglishLabel"
#define XtNstatusDubyolLabel "statusDubyolLabel"
#define XtNstatusSebyolLabel "statusSebyolLabel"
#define XtNstatusWansungLabel "statusWansungLabel"
#define XtNstatusJohabLabel "statusJohabLabel"
#define XtNlineSpace        "lineSpace"
#define XtNforceLineDraw "forceLineDraw"
#define XtNhanCursorColor "hanCursorColor"

#define XtCHangulFont  "HangulFont"
#define XtCHangulBoldFont  "HangulBoldFont"
#define XtCHangulCode   "HangulCode"
#define XtCAllowShuffle "AllowShuffle"
#define XtCHangulKeyboard "HangulKeyboard"
#define XtCHangulFontType "HangulFontType"
#define XtCEscHangulToggle "EscHangulToggle"
#define XtCKeepBaseLine    "KeepBaseLine"
#define XtCNoStatusCode    "NoStatusCode"
#define XtCNoStatusKbd    "NoStatusKbd"
#define XtCNowChatScroll   "NowChatScroll"
#define XtCDubyolKeyboardFile	"DubyolKeyboardFile"
#define XtCSebyolKeyboardFile	"SebyolKeyboardFile"
#define XtCStatusHangulLabel "StatusHangulLabel"
#define XtCStatusEnglishLabel "StatusEnglishLabel"
#define XtCStatusDubyolLabel "StatusDubyolLabel"
#define XtCStatusSebyolLabel "StatusSebyolLabel"
#define XtCStatusWansungLabel "StatusWansungLabel"
#define XtCStatusJohabLabel "StatusJohabLabel"
#define XtCLineSpace    "LineSpace"
#define XtCForceLineDraw "ForceLineDraw"

#if OPT_COLOR_CLASS
#define XtCHanCursorColor "HanCursorColor"
#else
#define XtCHanCursorColor XtCForeground
#endif

#define TextWindow(screen) VWindow(screen)

extern void HandleExecEvent PROTO_XT_ACTIONS_ARGS;
extern GC updatedXtermHGC(TScreen *screen, int flags, int fg_bg, Bool hilite);
extern void set_default_color(TScreen *screen);

/* hangul.c */
extern void HandleToggleHangul PROTO_XT_ACTIONS_ARGS;
extern void HandleToggleChat PROTO_XT_ACTIONS_ARGS;
extern void HandleChangeCode PROTO_XT_ACTIONS_ARGS;
extern void HandleChangeKeyboard PROTO_XT_ACTIONS_ARGS;
extern void HandleCodeInput PROTO_XT_ACTIONS_ARGS;
extern void HandleHanjaInput PROTO_XT_ACTIONS_ARGS;
extern void HDrawImageString(Display *, Window, GC, GC, int, int,
			     Char *, int);
extern void HDrawString(Display *, Window, GC, GC, int, int,
			Char *, int);
extern void han_show_status(TScreen *screen, int leftcol, int ncols);
extern int  length_of_statusline(void);
extern int  han_is_mode_button(int);
extern int  han_is_code_button(int);
extern int  han_is_kbd_button(int);
extern int han_adjust_string(Char *str, int n);

/* chat.c */
#if OPT_CHAT
extern int chat_mode;
extern int (*chat_callback)(int f, Char *data, int len);

extern void chat_flush(int ret);
extern void chat_mode_input(KeySym keysym, XKeyEvent *event,
			    Char *str, int nbytes);
extern void chat_hide_cursor(void);
extern void toggle_chat_mode(Char *str);
extern void show_chat_buf(void);
extern void chat_input(Char *str, int len);
extern void chat_show_cursor(void);
#else
#define chat_mode (0)
#endif /* OPT_CHAT */

/* hanja.c */
extern void hanja_mode_input(KeySym keysym, XKeyEvent *event,
			     Char *str, int nbytes);
extern void hanja_show_buf(void);
extern void hanja_clear_line(int x, int n);
extern void toggle_hanja_mode(unsigned int);

/* automata.c */
void hangul_set_code(int code);
void hangul_set_keyboard(int keyboard);
void hangul_automata_clear(void);
int hangul_automata(int c, Char *buf);
void hangul_automata_init();
int hangul_automata_flush(Char *buf);
int hangul_automata_toggle(Char *buf);

/* hanutil.c */
extern int han_split_font_name(char *fontname, char *efontname, char *hfontname);
extern char *han_composite_font_name(char *efontname, char *hfontname);
extern int han_set_font_encoding(char *hfontname, XFontStruct *hfs);
extern void han_correct_font_width(XFontStruct *hfs);
extern int han_check_font_ratio(XFontStruct *nfs, char *name, XFontStruct *hfs,
				char *hname);
extern int han_conv_ksc_to_ct(Char *str, int len, Char *dest);

extern void HandleExecEvent(Widget w, XEvent *event, String *params,
			    Cardinal *nparams);

#endif /* OPT_HANGUL */
#endif /* __HANGUL_H */

