/*
 *  Copyright (C) 2006-2007  Anders Gavare.  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright  
 *     notice, this list of conditions and the following disclaimer in the 
 *     documentation and/or other materials provided with the distribution.
 *  3. The name of the author may not be used to endorse or promote products
 *     derived from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE   
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *  SUCH DAMAGE.
 *
 *
 *  $Id: dev_mk48txx.c,v 1.4 2007/02/03 20:14:23 debug Exp $
 *
 *  Mostek MK48Txx Real Time Clock.
 *
 *  TODO: Actually implement it. This is just enough to fool NetBSD/mvmeppc
 *        into thinking that the clock exists.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "cpu.h"
#include "device.h"
#include "emul.h"
#include "machine.h"
#include "memory.h"
#include "misc.h"


#include "mk48txxreg.h"


#define	MK48TXX_LEN		16

struct mk48txx_data {
	unsigned char	reg[MK48TXX_LEN];
};


/*
 *  dev_mk48txx_access():
 */
DEVICE_ACCESS(mk48txx)
{
	struct mk48txx_data *d = (struct mk48txx_data *) extra;
	uint64_t idata = 0, odata = 0;

	if (writeflag == MEM_WRITE)
		idata = memory_readmax64(cpu, data, len);

	switch (relative_addr) {

	case MK48TXX_ICSR:
		if (writeflag == MEM_READ)
			odata = d->reg[relative_addr];
		else
			d->reg[relative_addr] = idata;
		break;

	case MK48TXX_ISEC:
{
/*  TODO: this is just a hack for NetBSD/mvmeppc mkclock detection :(  */
static int x = 0;
odata = x >> 1;
x++;
}
		break;

	default:if (writeflag == MEM_READ)
			fatal("[ mk48txx: unimplemented READ from offset %i ]"
			    "\n", (int)relative_addr);
		else
			fatal("[ mk48txx: unimplemented WRITE to offset %i: "
			    "0x%x ]\n", (int)relative_addr, (int)idata);
	}

	if (writeflag == MEM_READ)
		memory_writemax64(cpu, data, len, odata);

	return 1;
}


DEVINIT(mk48txx)
{
	struct mk48txx_data *d = malloc(sizeof(struct mk48txx_data));
	if (d == NULL) {
		fprintf(stderr, "out of memory\n");
		exit(1);
	}
	memset(d, 0, sizeof(struct mk48txx_data));

	memory_device_register(devinit->machine->memory, devinit->name,
	    devinit->addr, MK48TXX_LEN, dev_mk48txx_access, (void *)d,
	    DM_DEFAULT, NULL);

	return 1;
}

