// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKSOURCEVIEWMM_SOURCESTYLESCHEMEMANAGER_H
#define _GTKSOURCEVIEWMM_SOURCESTYLESCHEMEMANAGER_H


#include <glibmm.h>

/* sourcestyleschememanager.hg
 * 
 * Copyright (C)2008 Jonathon Jongsma
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/// \file
/// \brief SourceStyleSchemeManager class

#include <gtksourceviewmm/sourcestylescheme.h>
#include <gtksourceview/gtksourcestyleschememanager.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkSourceStyleSchemeManager GtkSourceStyleSchemeManager;
typedef struct _GtkSourceStyleSchemeManagerClass GtkSourceStyleSchemeManagerClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace gtksourceview
{ class SourceStyleSchemeManager_Class; } // namespace gtksourceview
namespace gtksourceview
{


class SourceStyleSchemeManager : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef SourceStyleSchemeManager CppObjectType;
  typedef SourceStyleSchemeManager_Class CppClassType;
  typedef GtkSourceStyleSchemeManager BaseObjectType;
  typedef GtkSourceStyleSchemeManagerClass BaseClassType;

private:  friend class SourceStyleSchemeManager_Class;
  static CppClassType sourcestyleschememanager_class_;

private:
  // noncopyable
  SourceStyleSchemeManager(const SourceStyleSchemeManager&);
  SourceStyleSchemeManager& operator=(const SourceStyleSchemeManager&);

protected:
  explicit SourceStyleSchemeManager(const Glib::ConstructParams& construct_params);
  explicit SourceStyleSchemeManager(GtkSourceStyleSchemeManager* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~SourceStyleSchemeManager();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkSourceStyleSchemeManager*       gobj()       { return reinterpret_cast<GtkSourceStyleSchemeManager*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkSourceStyleSchemeManager* gobj() const { return reinterpret_cast<GtkSourceStyleSchemeManager*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkSourceStyleSchemeManager* gobj_copy();

private:


protected:
  SourceStyleSchemeManager();

public:
  
  static Glib::RefPtr<SourceStyleSchemeManager> create();


  /** Returns: a Gtk::SourceStyleSchemeManager. Return value is owned
   * @return A Gtk::SourceStyleSchemeManager. Return value is owned
   * by GtkSourceView library and must not be unref'ed.
   */
  static Glib::RefPtr<SourceStyleSchemeManager> get_default();

  
  /** Sets the list of directories where the @a manager looks for
   * style scheme files.
   * If @a dirs is <tt>0</tt>, the search path is reset to default.
   * @param path A <tt>0</tt>-terminated array of strings or <tt>0</tt>.
   */
  void set_search_path(const Glib::StringArrayHandle& path);

  /** Set the search path to the default.
   */
  void reset_search_path();

 
  /** Returns: a <tt>0</tt>-terminated array of string containing the search path.
   * @return A <tt>0</tt>-terminated array of string containing the search path.
   * The array is owned by the @a manager and must not be modified.
   */
  Glib::StringArrayHandle get_search_path() const;


  /** Appends @a path to the list of directories where the @a manager looks for
   * style scheme files.
   * See set_search_path() for details.
   * @param path A directory or a filename.
   */
  void append_search_path(const Glib::ustring& path);
  
  /** Prepends @a path to the list of directories where the @a manager looks
   * for style scheme files.
   * See set_search_path() for details.
   * @param path A directory or a filename.
   */
  void prepend_search_path(const Glib::ustring& path);

  
  /** Looks up style scheme by id.
   * @param scheme_id Style scheme id to find.
   * @return A Gtk::SourceStyleScheme object. Returned value is owned by
   *  @a manager and must not be unref'ed.
   */
  Glib::RefPtr<SourceStyleScheme> get_scheme(const Glib::ustring& scheme_id);
  
  /** Looks up style scheme by id.
   * @param scheme_id Style scheme id to find.
   * @return A Gtk::SourceStyleScheme object. Returned value is owned by
   *  @a manager and must not be unref'ed.
   */
  Glib::RefPtr<const SourceStyleScheme> get_scheme(const Glib::ustring& scheme_id) const;
  
  /** Mark any currently cached information about the available style scehems
   * as invalid. All the available style schemes will be reloaded next time
   * the @a manager is accessed.
   */
  void force_rescan();

  
  /** Returns: a <tt>0</tt>-terminated array of string containing the ids of the
   * @return A <tt>0</tt>-terminated array of string containing the ids of the
   * available style schemes or <tt>0</tt> if no style scheme is available. The array
   * is owned by the @a manager and must not be modified.
   */
  Glib::StringArrayHandle get_scheme_ids() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};//end class SourceStyleSchemeManager

}//end namespace gtksourceview


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates gtksourceview::SourceStyleSchemeManager
   */
  Glib::RefPtr<gtksourceview::SourceStyleSchemeManager> wrap(GtkSourceStyleSchemeManager* object, bool take_copy = false);
}


#endif /* _GTKSOURCEVIEWMM_SOURCESTYLESCHEMEMANAGER_H */

