#include <gtk/gtk.h>
#include "application.hh"
#include "options.hh"

GtkWidget *open_opt_dlg(Application *app)
{
	GtkWidget *opt_dlg = gtk_dialog_new();
	GtkWidget *button;
	GtkWidget *spin_button;
	GtkWidget *table;;
	GtkWidget *label;
//	GtkWidget *hbox;
	GtkWidget *frame;
	GtkWidget *btn_box;
	GSList *group;
	gtk_window_set_title(GTK_WINDOW(opt_dlg), "GtkPool Options");
	
	// setup table
	table = gtk_table_new(5, 3, FALSE);
	label = gtk_label_new("Friction");
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 0, 1);
	gtk_widget_show(label);
	label = gtk_label_new("Bumper Drag");
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 1, 2);
	gtk_widget_show(label);
	label = gtk_label_new("Collision Drag");
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 2, 3);
	gtk_widget_show(label);
	spin_button = gtk_spin_button_new(GTK_ADJUSTMENT(app->friction_adjustment),
	                                  0.2, 2);
	gtk_table_attach_defaults(GTK_TABLE(table), spin_button, 1, 2, 0, 1);
	gtk_widget_show(spin_button);
	spin_button = gtk_spin_button_new(GTK_ADJUSTMENT(app->bumper_drag_adjustment),
	                                  0.2, 2);
	gtk_table_attach_defaults(GTK_TABLE(table), spin_button, 1, 2, 1, 2);
	gtk_widget_show(spin_button);
	spin_button = gtk_spin_button_new(GTK_ADJUSTMENT(app->collide_drag_adjustment),
	                                  0.2, 2);
	gtk_table_attach_defaults(GTK_TABLE(table), spin_button, 1, 2, 2, 3);
	gtk_widget_show(spin_button);
	
	button = gtk_check_button_new_with_label("Can hit moving balls");
	gtk_signal_connect(GTK_OBJECT(button), "toggled",
	                   GTK_SIGNAL_FUNC(moving_toggled_event), app);
	gtk_table_attach_defaults(GTK_TABLE(table), button, 0, 2, 3, 4);
	gtk_widget_show(button);

	button = gtk_check_button_new_with_label("Superhuman shots");
	gtk_signal_connect(GTK_OBJECT(button), "toggled",
	                   GTK_SIGNAL_FUNC(superhuman_toggled_event), app);
	gtk_table_attach_defaults(GTK_TABLE(table), button, 0, 2, 4, 5);
	gtk_widget_show(button);
	
	//setup the frame with button box that goes in the table in the vbox
	//in the dialog :)
	frame = gtk_frame_new("Game");
	btn_box = gtk_vbutton_box_new();
	
	button = gtk_radio_button_new_with_label(NULL, "8-Ball");
	gtk_signal_connect(GTK_OBJECT(button), "toggled",
	                   GTK_SIGNAL_FUNC(eb_toggled_event), app);
	gtk_container_add(GTK_CONTAINER(btn_box), button);
	gtk_widget_show(button);
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(button));
/*	button = gtk_radio_button_new_with_label(group, "14.1 Continuous");
	gtk_container_add(GTK_CONTAINER(btn_box), button);
	gtk_widget_show(button);
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(button));*/
	button = gtk_radio_button_new_with_label(group, "9-Ball");
	gtk_signal_connect(GTK_OBJECT(button), "toggled",
	                   GTK_SIGNAL_FUNC(nb_toggled_event), app);
	gtk_container_add(GTK_CONTAINER(btn_box), button);
	gtk_widget_show(button);
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(button));
/*	button = gtk_radio_button_new_with_label(group, "Snooker");
	gtk_container_add(GTK_CONTAINER(btn_box), button);
	gtk_widget_show(button);
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(button));*/
	
	gtk_widget_show(btn_box);

	gtk_container_add(GTK_CONTAINER(frame), btn_box);

	gtk_table_attach_defaults(GTK_TABLE(table), frame, 2, 3, 0, 4);
	gtk_widget_show(frame);

	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(opt_dlg)->vbox), table, TRUE, TRUE, 0);

	gtk_widget_show(table);
	
	


	button = gtk_button_new_with_label("Close");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
	                   GTK_SIGNAL_FUNC(od_close_event), opt_dlg);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(opt_dlg)->action_area), button,
	                   TRUE, TRUE, 0);
	gtk_widget_show(button);
	
//	gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);
//	gtk_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(destroy_event), NULL);
//	gtk_signal_connect(GTK_OBJECT(window), "delete_event", GTK_SIGNAL_FUNC(delete_event), NULL);
	
	gtk_widget_show(opt_dlg);
	return opt_dlg;
}

void od_close_event(GtkWidget *widget, gpointer data)
{
	gtk_widget_hide(GTK_WIDGET(data));
}

void moving_toggled_event(GtkWidget *widget, gpointer data)
{
	Application *app = (Application *)data;
	if(GTK_TOGGLE_BUTTON(widget)->active)
		app->hit_moving = true;
	else
		app->hit_moving = false;
}

void superhuman_toggled_event(GtkWidget *widget, gpointer data)
{
	Application *app = (Application *)data;
	if(GTK_TOGGLE_BUTTON(widget)->active)
		app->superhuman = true;
	else
		app->superhuman = false;
}

void eb_toggled_event(GtkWidget *widget, Application *app)
{
	if(GTK_TOGGLE_BUTTON(widget)->active)
		app->game_name = eight_ball;
}

void nb_toggled_event(GtkWidget *widget, Application *app)
{
	if(GTK_TOGGLE_BUTTON(widget)->active)
		app->game_name = nine_ball;
}
