#include "pool.hh"
#include <vector>

typedef enum { hit, collide, bounce, sink } event;
typedef enum { do_break, place_cueball, shoot, place_ball, victory1, victory2 } state;

class Event
{
	event code;
	int bn1, bn2;
	double x1, x2, y1, y2;
	double dx, dy;
	Event(int b, double px, double py, event c, double pdx = 0, double pdy = 0)
	{
		code = c;
		bn1 = b;
		x1 = px; y1 = py;
		dx = pdx; dy = pdy;
	}
	Event(int b1, double px1, double py1, event c, int b2, double px2, double py2,
	      double pdx = 0, double pdy = 0)
	{
		code = c;
		bn1 = b1;
		x1 = px1; y1 = py1;
		bn2 = b2;
		x2 = px2; y2 = py2;
		dx = pdx; dy = pdy;
	}
	bool operator>(Event &)
	{
		return true;
	}
	bool operator==(Event &)
	{
		return (*this == *e);
	}
};


class Game
{
	vector<Event> events;
	int sunk_balls;
	vector<int> player1_balls;
	vector<int> player2_balls;
	int cur_player;
	state prog_state;
	public:
	
	Game()
	{
		sunk_balls = 0;
	}
	
	void collide(const Ball *b1, const Ball *b2)
	{
		events.push_back(event(b1->ball_num, b1->x, b1->y, collide, b2->ball_num, b2->x, b2->y));
	}
	void hit(const Ball *b, const double dx, const double dy)
	{
		events.push_back(event(b->ball_num, b->x, b->y, hit));
	}
	void bounce(const Ball *b)
	{
	 	events.push_back(event(b->ball_num, b->x, b->y, bounce));
	}
	void sink(const Ball *b)
	{
		events.push_back(event(b->ball_num, b->x, b->y, sink));
	}
	virtual int finish() = 0;
};