/*************************************************************************\
*    gtkpool -- a so far not-so-great pool game                           *
*    Copyright (C) 1999 Jacques Fortier                                   *
*                                                                         *
*    This program is free software; you can redistribute it and/or modify *
*    it under the terms of the GNU General Public License as published by *
*    the Free Software Foundation; either version 2 of the License, or    *
*    (at your option) any later version.                                  *
*                                                                         *
*    This program is distributed in the hope that it will be useful,      *
*    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
*    GNU General Public License for more details.                         *
*                                                                         *
*    You should have received a copy of the GNU General Public License    *
*    along with this program; if not, write to the Free Software          *
*    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
\*************************************************************************/
#ifndef __APPLICATION_HH
#define __APPLICATION_HH
#include <gtk/gtk.h>
#include <vector>
#include "pool.hh"

extern int udl, udr, udt, udb;
enum game_types { eight_ball, nine_ball, snooker, continuous14_1 };

class ConnectDialog
{
	public:
	GtkWidget *dialog;
	GtkWidget *host_entry, *port_entry, *handle_entry;
	GtkWidget *server_check, *client_check;
	GtkWidget *cancel_button, *connect_button;
	ConnectDialog()
	{
	}
};

class Application {
	public:
	vector<Ball> balls;
	vector<int> sunk_balls1;
	vector<int> sunk_balls2;
	Ball *selected;
	int width, height, gap;
	bool running, placing_cue, hit_moving, superhuman;
	bool sunk_tf, collide_tf, bounce_tf;
	bool sound;
	bool connected;
	
	int sunk_balls;
	
	char coll_snd[1025];
	int coll_sndc;
	char bnc_snd[1025];
	int bnc_sndc;
	char pock_snd[2049];
	int pock_sndc;
	
	int game_name;
	
	double FRICTION;
	double BUMPER_DRAG;
	double COLLIDE_DRAG;
	
	GdkRectangle table;
	GdkPoint shoot;
	GdkVisual *visual;
	GdkColormap *colormap;
	GdkGC *gc;
	GdkPixmap *buf_pixmap;
	GdkPixmap **balls_pixmaps;
	GdkPixmap **balls_pixmap_masks;
	GdkPixmap **balls_big_pixmaps;
	GdkPixmap **balls_big_pixmap_masks;
	GdkPixmap *rack_pixmap;
	GdkPixmap *rack_mask;
	GdkPixmap *table_pixmap;
	GdkColor *black;
	GdkColor *table_color;
	GdkColor *message_colours[15];
	GtkWidget *rack_area;
	GtkWidget *drawing_area;
	GtkWidget *opt_dlg;
	GtkWidget *chat_text;
	GtkObject *friction_adjustment;
	GtkObject *collide_drag_adjustment;
	GtkObject *bumper_drag_adjustment;
	
	ConnectDialog *connect_dialog;
	
	guint button_press_handler_id, qbp_hndlr;

	Application()
	{
		gap = 30; // was 700 x 450
		width = 640 + gap * 2; height = 407 + gap * 2;
		table.width = width - (gap * 2);
		table.height = height - (gap * 2);
		table.x = 0 + gap;
		table.y = 0 + gap;

		FRICTION = .06;
		BUMPER_DRAG = .8;
		COLLIDE_DRAG = .95;

		selected = NULL;

		black  = new GdkColor;
		table_color = new GdkColor;
		message_colours[1] = new GdkColor;
		message_colours[2] = new GdkColor;
		message_colours[3] = new GdkColor;
		message_colours[4] = new GdkColor;
		message_colours[14] = new GdkColor;

		buf_pixmap = NULL;
		balls_pixmaps = new (GdkPixmap *)[NUM_BALLS];
		balls_pixmap_masks = new (GdkBitmap *)[NUM_BALLS];
		balls_big_pixmaps = new (GdkPixmap *)[NUM_BALLS];
		balls_big_pixmap_masks = new (GdkBitmap *)[NUM_BALLS];
		running = true; placing_cue = false;
		sunk_tf = collide_tf = bounce_tf = false;
		connected = false;		
		connect_dialog = NULL;
		game_name = eight_ball;
	}
	~Application()
	{
		delete black;
		delete table_color;
		delete[] balls_pixmaps;
		delete[] balls_pixmap_masks;
		delete[] balls_big_pixmaps;
		delete[] balls_big_pixmap_masks;
	}

	void init();
	void destroy();
	void updateBalls ();
	void resetTable ();
	void paint (GdkDrawable *pixmap, GdkGC *gc);
	void mouse_down (int x, int y);
	void mouse_up (int x, int y);
	void mouse_drag (int x, int y);
	void update_rack();
	void new_cue_ball();
	GdkPixmap *load_pixmap(GdkPixmap **mask, char *file, char *path = NULL);
	void load_ball_xpms();
	void load_sounds();
	void init_sound();
	static gint cue_ball_placed(GtkWidget *widget, GdkEventButton *event,
	                              Application *app);
	void print_message(const char *, int = 0);
							
	float friction()
	{
		return GTK_ADJUSTMENT(friction_adjustment)->value;
	}
	float collide_drag()
	{
		return GTK_ADJUSTMENT(collide_drag_adjustment)->value;
	}
	float bumper_drag()
	{
		return GTK_ADJUSTMENT(bumper_drag_adjustment)->value;
	}
	void new_ball(double x, double y , int bn, bool isc = false, bool ise = false)
	{
		balls.push_back(Ball(x, y, BALL_SIZE, bn, balls_pixmaps[bn],
		                     balls_pixmap_masks[bn], balls_big_pixmaps[bn],
		                     balls_big_pixmap_masks[bn], isc, ise));
	}
};


#endif
