/* GtkBalls
 * Copyright (C) 1998-1999 Eugene V. Morozov
 * Modifyed in 2001 by drF_ckoff
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __SCOREBOARD_H
#define __SCOREBOARD_H

struct score_board {
    gchar name[15];
    gint  score;
    gchar date[30];
};

/* number of elements in struct score_board_full keep it in sync! =) */
#define SBFNUM 8
struct score_board_full {
    gchar name[15];
    gint  score;
    gchar date[30];
    GtkbGameRules rules;
};

/* "for feature reference" =)
gboolean sb_init_score(void);
*/

gint write_score(struct score_board *, struct score_board_full *, gint);
gint read_score(struct score_board *, struct score_board_full **, gint *);
gint insert_entry_in_score_board(struct score_board *board,
				 struct score_board entry);

#endif
