/* GtkBalls
 * Copyright (C) 1998-1999 Eugene V. Morozov
 * Modifyed in 2001 by drF_ckoff
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <gtk/gtk.h>

#include "gtkballs.h"
#include "interface.h"
#include "license.h"

void gnu_license_dialog(gpointer data) {
  	GtkWidget *window;
  	GtkWidget *vbox,*hbox,*button_box;
  	GtkWidget *license;
  	GtkWidget *vscrollbar;
  	GtkWidget *separator;
  	GtkWidget *ok_button;
  	struct stat buf;
  	int fd;
  	gchar *license_buf;
        gchar *license_file=DATADIR "/gtkballs/COPYING";

  	if(stat(license_file, &buf)<0) {
      		simple_message_box(_("Can't stat license file"), _("OK"));
      		return;
  	}
  
  	license_buf=(gchar *)g_malloc(buf.st_size);
  	if((fd=open(license_file, O_RDONLY))<0) {
      		simple_message_box(_("Can't open license file"), _("OK"));
      		g_free(license_buf);
      		return;
    	}
  	read(fd, license_buf, buf.st_size);
  	close(fd);

  	window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
        gtk_widget_set_usize(window, 602, 460);
  	gtk_window_set_title(GTK_WINDOW(window), _("GNU Public License"));
        gtk_window_set_wmclass(GTK_WINDOW(window), "GtkBalls_License", "GtkBalls");
  	gtk_signal_connect(GTK_OBJECT(window), "key_press_event", GTK_SIGNAL_FUNC(key_pressed), NULL);
  	gtk_container_border_width(GTK_CONTAINER(window), 5);

  	vbox=gtk_vbox_new(FALSE, 0);
  	gtk_container_border_width(GTK_CONTAINER(vbox), 5);
  	gtk_container_add(GTK_CONTAINER(window), vbox);

  	hbox=gtk_hbox_new(FALSE, 0);
  	gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);
  	gtk_widget_show(hbox);

  	license=gtk_text_new(NULL, NULL);
  	gtk_text_set_editable(GTK_TEXT(license), FALSE);
  	gtk_box_pack_start(GTK_BOX(hbox), license, TRUE, TRUE, 0);
  	gtk_widget_show(license);

  	vscrollbar=gtk_vscrollbar_new(GTK_TEXT(license)->vadj);
  	gtk_box_pack_start(GTK_BOX(hbox), vscrollbar, FALSE, FALSE, 0);

  	separator=gtk_hseparator_new();
  	gtk_box_pack_start(GTK_BOX(vbox), separator, FALSE, FALSE, 5);
  
	button_box=gtk_hbox_new(TRUE, 0);
  	gtk_box_pack_start(GTK_BOX(vbox), button_box, FALSE, TRUE, 0);

  	ok_button=gtk_button_new_with_label(_("OK"));
        GTK_WIDGET_SET_FLAGS(ok_button, GTK_CAN_DEFAULT | GTK_CAN_FOCUS);
  	gtk_signal_connect_object(GTK_OBJECT(ok_button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT (window));
  	gtk_box_pack_start(GTK_BOX(button_box), ok_button, TRUE, TRUE, 0);

  	/* make about window non-modal and license window modal */
  	gtk_grab_remove(GTK_WIDGET(data));
  	gtk_grab_add(window);
  	gtk_text_insert(GTK_TEXT(license), NULL, NULL, NULL, license_buf, -1);
	gtk_widget_show_all(window);
        gtk_widget_grab_default(ok_button);

  	g_free(license_buf);
}
