#include <config.h>
#include <gtk/gtk.h>

GtkWidget *ut_check_button_new(gchar *label, gboolean active, GtkWidget *parent) {
  	GtkWidget *button;

	button = gtk_check_button_new_with_label(label);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), active);
  	gtk_box_pack_start(GTK_BOX(parent), button, FALSE, FALSE, 0);

        return button;
}

GtkWidget *ut_button_new(gchar *label, GtkSignalFunc func, gpointer func_data, GtkWidget *parent) {
  	GtkWidget *button;

        button = gtk_button_new_with_label(label);
  	gtk_signal_connect(GTK_OBJECT(button), "clicked", func, func_data);
  	gtk_box_pack_start(GTK_BOX(parent), button, TRUE, TRUE, 0);
        GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT | GTK_CAN_FOCUS);

        return button;
}

GtkWidget *ut_spin_button_new(gchar *label, gint min, gint max, gint val, GtkWidget *parent) {
        GtkObject *adj;
	GtkWidget *button, *hbox, *labelw;

  	hbox = gtk_hbox_new(FALSE, 0);
  	gtk_box_pack_start(GTK_BOX(parent), hbox, TRUE, TRUE, 2);

  	labelw = gtk_label_new(label);
  	gtk_box_pack_start(GTK_BOX(hbox), labelw, FALSE, FALSE, 5);

        adj = gtk_adjustment_new(val, min, max, 1, 10, 10);
        button = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 1, 0);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(button), TRUE);
  	gtk_box_pack_end(GTK_BOX(hbox), button, FALSE, FALSE, 5);

        return button;
}
