/* GtkBalls
 * Copyright (C) 1998 Eugene V. Morozov
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include "preferences.h"

static GtkWidget *dialog;
static GtkWidget *show_hints_button, *show_path_button, *show_footprints_button;

void preferences_ok (GtkWidget *widget, gpointer data);
void preferences_apply (GtkWidget *widget, gpointer data);

void
process_properties (char *property, char *value)
{
  value[strlen(value)-1] = '\0'; /* strip trailing '\n' */
  if (strncmp (property, "show_hints", 64) == 0)
      {
	if (strncmp (value, "yes", 64) == 0)
	  show_next_colors = TRUE;
	else
	  {
	    if (strncmp (value, "no", 64) == 0)
	      show_next_colors = FALSE;
	    else /* default */
	      show_next_colors = TRUE;
	  }
      }

  if (strncmp (property, "show_path", 64) == 0)
      {
	if (strncmp (value, "yes", 64) == 0)
	  show_path = TRUE;
	else
	  {
	    if (strncmp (value, "no", 64) == 0)
	      show_path = FALSE;
	    else /* default */
	      show_path = TRUE;
	  }
      }

  if (strncmp (property, "show_footprints", 64) == 0)
      {
	if (strncmp (value, "yes", 64) == 0)
	  show_footprints = TRUE;
	else
	  {
	    if (strncmp (value, "no", 64) == 0)
	      show_footprints = FALSE;
	    else /* default */
	      show_footprints = TRUE;
	  }
      }
}

void 
load_preferences ()
{
  FILE *fp;
  char rc_file[256];
  char buffer[128];
  char *token;
  char property[64], value[64];
  
  if (!((getenv ("HOME") == NULL) || (strlen (getenv ("HOME")) > 200)))
    {
      strcpy (rc_file, getenv ("HOME"));
      if (rc_file[strlen(rc_file)-1] != '/')
	strcat (rc_file, "/");
      strcat (rc_file, ".gtkballsrc");
    }
  else /* unable to read $HOME, assuming current directory */
    strcpy (rc_file, ".gtkballsrc");

  fp = fopen (rc_file, "r");
  if (fp != NULL)
    {
      while (!feof (fp))
	{
	  fgets (buffer, 128, fp);
	  token = strtok (buffer, " ");
	  if (token == NULL)
	    continue;
	  strncpy (property, token, 64);
	  token = strtok (NULL, " ");
	  if (token == NULL)
	    continue;
	  strncpy (value, token, 64);
	  process_properties (property, value);
	}
      fclose (fp);
    }
  else
    {
      show_next_colors = TRUE;
      show_path = TRUE;
    }
}

void
save_preferences ()
{
  FILE *fp;
  char rc_file[256];
  
  if (!((getenv ("HOME") == NULL) || (strlen (getenv ("HOME")) > 200)))
    {
      strcpy (rc_file, getenv ("HOME"));
      if (rc_file[strlen(rc_file)-1] != '/')
	strcat (rc_file, "/");
      strcat (rc_file, ".gtkballsrc");
    }
  else /* unable to read $HOME, assuming current directory */
    strcpy (rc_file, ".gtkballsrc");

  fp = fopen (rc_file, "w");
  if (fp != NULL)
    {
      if (show_next_colors)
	fputs ("show_hints yes\n", fp);
      else
	fputs ("show_hints no\n", fp);
      if (show_path)
	fputs ("show_path yes\n", fp);
      else
	fputs ("show_path no\n", fp);
      if (show_footprints)
	fputs ("show_footprints yes\n", fp);
      else
	fputs ("show_footprints no\n", fp);
      fclose (fp);
    }
  else
    {
      g_print ("Can't write to ");
      perror (rc_file);
    }
}

void
preferences_dialog ()
{
  GtkWidget *frame;
  GtkWidget *big_vbox, *vbox, *buttons_box;
  GtkWidget *separator;
  GtkWidget *ok_button, *cancel_button, *apply_button;
  
  dialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (dialog), "Preferences");
  gtk_widget_set_usize (dialog, 400, 140);
  gtk_container_border_width (GTK_CONTAINER (dialog), 5);

  big_vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (dialog), big_vbox);
  gtk_widget_show (big_vbox);

  frame = gtk_frame_new ("Preferences");
  gtk_box_pack_start (GTK_BOX (big_vbox), frame, FALSE, FALSE, 0);
  gtk_widget_show (frame);

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox);
  gtk_widget_show (vbox);
		    
  show_hints_button = gtk_check_button_new_with_label ("Show colors that will appear on next turn");
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (show_hints_button), show_next_colors);
  gtk_box_pack_start (GTK_BOX (vbox), show_hints_button, FALSE, FALSE, 0);
  gtk_widget_show (show_hints_button);

  show_path_button = gtk_check_button_new_with_label ("Show path of the ball");
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (show_path_button), show_path);
  gtk_box_pack_start (GTK_BOX (vbox), show_path_button, FALSE, FALSE, 0);
  gtk_widget_show (show_path_button);
  
  show_footprints_button = gtk_check_button_new_with_label ("Show footprints of the ball");
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (show_footprints_button), show_footprints);
  gtk_box_pack_start (GTK_BOX (vbox), show_footprints_button, FALSE, FALSE, 0);
  gtk_widget_show (show_footprints_button);

  separator = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (big_vbox), separator, FALSE, FALSE, 5);
  gtk_widget_show (separator);

  buttons_box = gtk_hbutton_box_new ();
  gtk_hbutton_box_set_layout_default (GTK_BUTTONBOX_END);
  gtk_box_pack_start (GTK_BOX (big_vbox), buttons_box, TRUE, TRUE, 0);
  gtk_widget_show (buttons_box);

  ok_button = gtk_button_new_with_label ("OK");
  gtk_signal_connect (GTK_OBJECT (ok_button), "clicked",
		      GTK_SIGNAL_FUNC (preferences_ok), NULL);
  gtk_box_pack_start (GTK_BOX (buttons_box), ok_button, TRUE, TRUE, 0);
  gtk_widget_show (ok_button);

  cancel_button = gtk_button_new_with_label ("Cancel");
  gtk_signal_connect_object (GTK_OBJECT (cancel_button), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (dialog));
  gtk_box_pack_start (GTK_BOX (buttons_box), cancel_button, TRUE, TRUE, 0);
  gtk_widget_show (cancel_button);

  apply_button = gtk_button_new_with_label ("Apply");
  gtk_signal_connect (GTK_OBJECT (apply_button), "clicked",
		      GTK_SIGNAL_FUNC (preferences_apply), NULL);
  gtk_box_pack_start (GTK_BOX (buttons_box), apply_button, TRUE, TRUE, 0);
  gtk_widget_show (apply_button);

  gtk_widget_show (dialog);
}

void
preferences_ok (GtkWidget *widget, gpointer data)
{
  preferences_apply (NULL, NULL);
  gtk_widget_destroy (dialog);
}

void
preferences_apply (GtkWidget *widget, gpointer data)
{
  if (GTK_TOGGLE_BUTTON (show_hints_button)->active)
    {
      gtk_widget_show (ball1);
      gtk_widget_show (ball2);
      gtk_widget_show (ball3);
      show_next_colors = TRUE;
    }
  else
    {
      gtk_widget_hide (ball1);
      gtk_widget_hide (ball2);
      gtk_widget_hide (ball3);
      show_next_colors = FALSE;
    }
  if (GTK_TOGGLE_BUTTON (show_path_button)->active)
    show_path = TRUE;
  else
    show_path = FALSE;
  if (GTK_TOGGLE_BUTTON (show_footprints_button)->active)
    show_footprints = TRUE;
  else
    show_footprints = FALSE;
  save_preferences ();
}
