/* GtkBalls
 * Copyright (C) 1998 Eugene V. Morozov
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __GTKBALLS_INTERFACE_H
#define __GTKBALLS_INTERFACE_H

#include <gtk/gtk.h>

#define NUMBER_OF_CELLS 9
#define NUMBER_OF_BALLS 7
#define NUMBER_OF_PHASES 5

#define BLUE_BALL   1
#define BROWN_BALL  2
#define GREEN_BALL  3
#define RED_BALL    4
#define YELLOW_BALL 5
#define PINK_BALL   6
#define CYAN_BALL   7

extern int board[NUMBER_OF_CELLS][NUMBER_OF_CELLS];
extern int jumping_ball;
extern int jumping_ball_color;
extern int score;
extern int hi_score;
extern GtkWidget *hi_score_label, *user_score_label;

void show_hall_of_fame (GtkWidget * widget, gpointer data);
void about (GtkWidget * widget, gpointer data);
void simple_message_box (char *message, char *label);
gint delete_event (GtkWidget * widget, gpointer data);
void destroy (GtkWidget * widget, gpointer data);
int calculate_board_coord (int window_coord);
void update_rectangle (GtkWidget * widget, int x, int y, int w, int h);
void draw_ball (GtkWidget * widget, GdkPixmap * ball, GdkPixmap * pixmap, 
		int x, int y, int yoffset);
void draw_paw (GtkWidget * widget, GdkPixmap * paw, GdkPixmap * pixmap, 
	       int x, int y);
void set_hi_score_label (void);
void set_user_score_label (void);
int destroy_lines (GtkWidget * widget, GdkPixmap * pixmap);
void draw_board (GtkWidget * widget, GdkPixmap * pixmap);
char *input_name_dialog (void);

#endif
