/* GtkamlXmlAttribute.vala
 * 
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define GTKAML_TYPE_XML_ATTRIBUTE (gtkaml_xml_attribute_get_type ())
#define GTKAML_XML_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_XML_ATTRIBUTE, GtkamlXmlAttribute))
#define GTKAML_XML_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_XML_ATTRIBUTE, GtkamlXmlAttributeClass))
#define GTKAML_IS_XML_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_XML_ATTRIBUTE))
#define GTKAML_IS_XML_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_XML_ATTRIBUTE))
#define GTKAML_XML_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_XML_ATTRIBUTE, GtkamlXmlAttributeClass))

typedef struct _GtkamlXmlAttribute GtkamlXmlAttribute;
typedef struct _GtkamlXmlAttributeClass GtkamlXmlAttributeClass;
typedef struct _GtkamlXmlAttributePrivate GtkamlXmlAttributePrivate;

/**
 * an attribute as presented by libxml2
 */
struct _GtkamlXmlAttribute {
	GObject parent_instance;
	GtkamlXmlAttributePrivate * priv;
	char* localname;
	char* prefix;
	char* URI;
	char* value;
};

struct _GtkamlXmlAttributeClass {
	GObjectClass parent_class;
};



GType gtkaml_xml_attribute_get_type (void);
enum  {
	GTKAML_XML_ATTRIBUTE_DUMMY_PROPERTY
};
GtkamlXmlAttribute* gtkaml_xml_attribute_new (void);
GtkamlXmlAttribute* gtkaml_xml_attribute_construct (GType object_type);
GtkamlXmlAttribute* gtkaml_xml_attribute_new (void);
static gpointer gtkaml_xml_attribute_parent_class = NULL;
static void gtkaml_xml_attribute_finalize (GObject* obj);



/**
 * an attribute as presented by libxml2
 */
GtkamlXmlAttribute* gtkaml_xml_attribute_construct (GType object_type) {
	GtkamlXmlAttribute * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


GtkamlXmlAttribute* gtkaml_xml_attribute_new (void) {
	return gtkaml_xml_attribute_construct (GTKAML_TYPE_XML_ATTRIBUTE);
}


static void gtkaml_xml_attribute_class_init (GtkamlXmlAttributeClass * klass) {
	gtkaml_xml_attribute_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = gtkaml_xml_attribute_finalize;
}


static void gtkaml_xml_attribute_instance_init (GtkamlXmlAttribute * self) {
}


static void gtkaml_xml_attribute_finalize (GObject* obj) {
	GtkamlXmlAttribute * self;
	self = GTKAML_XML_ATTRIBUTE (obj);
	self->localname = (g_free (self->localname), NULL);
	self->prefix = (g_free (self->prefix), NULL);
	self->URI = (g_free (self->URI), NULL);
	self->value = (g_free (self->value), NULL);
	G_OBJECT_CLASS (gtkaml_xml_attribute_parent_class)->finalize (obj);
}


GType gtkaml_xml_attribute_get_type (void) {
	static GType gtkaml_xml_attribute_type_id = 0;
	if (gtkaml_xml_attribute_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkamlXmlAttributeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkaml_xml_attribute_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkamlXmlAttribute), 0, (GInstanceInitFunc) gtkaml_xml_attribute_instance_init, NULL };
		gtkaml_xml_attribute_type_id = g_type_register_static (G_TYPE_OBJECT, "GtkamlXmlAttribute", &g_define_type_info, 0);
	}
	return gtkaml_xml_attribute_type_id;
}




