/* GtkamlReferenceClassDefinition.vala
 * 
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define GTKAML_TYPE_CLASS_DEFINITION (gtkaml_class_definition_get_type ())
#define GTKAML_CLASS_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_CLASS_DEFINITION, GtkamlClassDefinition))
#define GTKAML_CLASS_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_CLASS_DEFINITION, GtkamlClassDefinitionClass))
#define GTKAML_IS_CLASS_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_CLASS_DEFINITION))
#define GTKAML_IS_CLASS_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_CLASS_DEFINITION))
#define GTKAML_CLASS_DEFINITION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_CLASS_DEFINITION, GtkamlClassDefinitionClass))

typedef struct _GtkamlClassDefinition GtkamlClassDefinition;
typedef struct _GtkamlClassDefinitionClass GtkamlClassDefinitionClass;
typedef struct _GtkamlClassDefinitionPrivate GtkamlClassDefinitionPrivate;

#define GTKAML_TYPE_REFERENCE_CLASS_DEFINITION (gtkaml_reference_class_definition_get_type ())
#define GTKAML_REFERENCE_CLASS_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_REFERENCE_CLASS_DEFINITION, GtkamlReferenceClassDefinition))
#define GTKAML_REFERENCE_CLASS_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_REFERENCE_CLASS_DEFINITION, GtkamlReferenceClassDefinitionClass))
#define GTKAML_IS_REFERENCE_CLASS_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_REFERENCE_CLASS_DEFINITION))
#define GTKAML_IS_REFERENCE_CLASS_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_REFERENCE_CLASS_DEFINITION))
#define GTKAML_REFERENCE_CLASS_DEFINITION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_REFERENCE_CLASS_DEFINITION, GtkamlReferenceClassDefinitionClass))

typedef struct _GtkamlReferenceClassDefinition GtkamlReferenceClassDefinition;
typedef struct _GtkamlReferenceClassDefinitionClass GtkamlReferenceClassDefinitionClass;
typedef struct _GtkamlReferenceClassDefinitionPrivate GtkamlReferenceClassDefinitionPrivate;

#define TYPE_DEFINITION_SCOPE (definition_scope_get_type ())

#define GTKAML_TYPE_ATTRIBUTE (gtkaml_attribute_get_type ())
#define GTKAML_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_ATTRIBUTE, GtkamlAttribute))
#define GTKAML_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_ATTRIBUTE, GtkamlAttributeClass))
#define GTKAML_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_ATTRIBUTE))
#define GTKAML_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_ATTRIBUTE))
#define GTKAML_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_ATTRIBUTE, GtkamlAttributeClass))

typedef struct _GtkamlAttribute GtkamlAttribute;
typedef struct _GtkamlAttributeClass GtkamlAttributeClass;

#define GTKAML_TYPE_METHOD (gtkaml_method_get_type ())
#define GTKAML_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_METHOD, GtkamlMethod))
#define GTKAML_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_METHOD, GtkamlMethodClass))
#define GTKAML_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_METHOD))
#define GTKAML_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_METHOD))
#define GTKAML_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_METHOD, GtkamlMethodClass))

typedef struct _GtkamlMethod GtkamlMethod;
typedef struct _GtkamlMethodClass GtkamlMethodClass;

#define GTKAML_TYPE_CONSTRUCT_METHOD (gtkaml_construct_method_get_type ())
#define GTKAML_CONSTRUCT_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_CONSTRUCT_METHOD, GtkamlConstructMethod))
#define GTKAML_CONSTRUCT_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_CONSTRUCT_METHOD, GtkamlConstructMethodClass))
#define GTKAML_IS_CONSTRUCT_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_CONSTRUCT_METHOD))
#define GTKAML_IS_CONSTRUCT_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_CONSTRUCT_METHOD))
#define GTKAML_CONSTRUCT_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_CONSTRUCT_METHOD, GtkamlConstructMethodClass))

typedef struct _GtkamlConstructMethod GtkamlConstructMethod;
typedef struct _GtkamlConstructMethodClass GtkamlConstructMethodClass;

/** represents a gtkaml tag */
struct _GtkamlClassDefinition {
	GObject parent_instance;
	GtkamlClassDefinitionPrivate * priv;
};

struct _GtkamlClassDefinitionClass {
	GObjectClass parent_class;
};

/** represents a tag with gtkaml:existing */
struct _GtkamlReferenceClassDefinition {
	GtkamlClassDefinition parent_instance;
	GtkamlReferenceClassDefinitionPrivate * priv;
};

struct _GtkamlReferenceClassDefinitionClass {
	GtkamlClassDefinitionClass parent_class;
};

typedef enum  {
	DEFINITION_SCOPE_MAIN_CLASS = 0,
	DEFINITION_SCOPE_PUBLIC,
	DEFINITION_SCOPE_PRIVATE,
	DEFINITION_SCOPE_CONSTRUCTOR
} DefinitionScope;



GType gtkaml_class_definition_get_type (void);
GType gtkaml_reference_class_definition_get_type (void);
enum  {
	GTKAML_REFERENCE_CLASS_DEFINITION_DUMMY_PROPERTY
};
void gtkaml_class_definition_set_source_reference (GtkamlClassDefinition* self, ValaSourceReference* value);
void gtkaml_class_definition_set_base_ns (GtkamlClassDefinition* self, const char* value);
void gtkaml_class_definition_set_identifier (GtkamlClassDefinition* self, const char* value);
void gtkaml_class_definition_set_base_type (GtkamlClassDefinition* self, ValaClass* value);
GType definition_scope_get_type (void);
void gtkaml_class_definition_set_definition_scope (GtkamlClassDefinition* self, DefinitionScope value);
void gtkaml_class_definition_set_parent_container (GtkamlClassDefinition* self, GtkamlClassDefinition* value);
GType gtkaml_attribute_get_type (void);
void gtkaml_class_definition_set_attrs (GtkamlClassDefinition* self, GeeList* value);
GType gtkaml_method_get_type (void);
GType gtkaml_construct_method_get_type (void);
void gtkaml_class_definition_set_construct_method (GtkamlClassDefinition* self, GtkamlConstructMethod* value);
void gtkaml_class_definition_set_children (GtkamlClassDefinition* self, GeeList* value);
void gtkaml_class_definition_set_construct_code (GtkamlClassDefinition* self, const char* value);
void gtkaml_class_definition_set_preconstruct_code (GtkamlClassDefinition* self, const char* value);
GtkamlReferenceClassDefinition* gtkaml_reference_class_definition_new (ValaSourceReference* source_reference, const char* reference, const char* base_ns, ValaClass* base_type, GtkamlClassDefinition* parent_container);
GtkamlReferenceClassDefinition* gtkaml_reference_class_definition_construct (GType object_type, ValaSourceReference* source_reference, const char* reference, const char* base_ns, ValaClass* base_type, GtkamlClassDefinition* parent_container);
GtkamlReferenceClassDefinition* gtkaml_reference_class_definition_new (ValaSourceReference* source_reference, const char* reference, const char* base_ns, ValaClass* base_type, GtkamlClassDefinition* parent_container);
static gpointer gtkaml_reference_class_definition_parent_class = NULL;



GtkamlReferenceClassDefinition* gtkaml_reference_class_definition_construct (GType object_type, ValaSourceReference* source_reference, const char* reference, const char* base_ns, ValaClass* base_type, GtkamlClassDefinition* parent_container) {
	GtkamlReferenceClassDefinition * self;
	GeeArrayList* _tmp0;
	GeeArrayList* _tmp1;
	g_return_val_if_fail (source_reference != NULL, NULL);
	g_return_val_if_fail (reference != NULL, NULL);
	g_return_val_if_fail (base_ns != NULL, NULL);
	g_return_val_if_fail (base_type != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	gtkaml_class_definition_set_source_reference ((GtkamlClassDefinition*) self, source_reference);
	gtkaml_class_definition_set_base_ns ((GtkamlClassDefinition*) self, base_ns);
	gtkaml_class_definition_set_identifier ((GtkamlClassDefinition*) self, reference);
	gtkaml_class_definition_set_base_type ((GtkamlClassDefinition*) self, base_type);
	gtkaml_class_definition_set_definition_scope ((GtkamlClassDefinition*) self, 0);
	gtkaml_class_definition_set_parent_container ((GtkamlClassDefinition*) self, parent_container);
	_tmp0 = NULL;
	gtkaml_class_definition_set_attrs ((GtkamlClassDefinition*) self, (GeeList*) (_tmp0 = gee_array_list_new (GTKAML_TYPE_ATTRIBUTE, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal)));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL));
	gtkaml_class_definition_set_construct_method ((GtkamlClassDefinition*) self, NULL);
	_tmp1 = NULL;
	gtkaml_class_definition_set_children ((GtkamlClassDefinition*) self, (GeeList*) (_tmp1 = gee_array_list_new (GTKAML_TYPE_CLASS_DEFINITION, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal)));
	(_tmp1 == NULL) ? NULL : (_tmp1 = (gee_collection_object_unref (_tmp1), NULL));
	gtkaml_class_definition_set_construct_code ((GtkamlClassDefinition*) self, NULL);
	gtkaml_class_definition_set_preconstruct_code ((GtkamlClassDefinition*) self, NULL);
	return self;
}


GtkamlReferenceClassDefinition* gtkaml_reference_class_definition_new (ValaSourceReference* source_reference, const char* reference, const char* base_ns, ValaClass* base_type, GtkamlClassDefinition* parent_container) {
	return gtkaml_reference_class_definition_construct (GTKAML_TYPE_REFERENCE_CLASS_DEFINITION, source_reference, reference, base_ns, base_type, parent_container);
}


static void gtkaml_reference_class_definition_class_init (GtkamlReferenceClassDefinitionClass * klass) {
	gtkaml_reference_class_definition_parent_class = g_type_class_peek_parent (klass);
}


static void gtkaml_reference_class_definition_instance_init (GtkamlReferenceClassDefinition * self) {
}


GType gtkaml_reference_class_definition_get_type (void) {
	static GType gtkaml_reference_class_definition_type_id = 0;
	if (gtkaml_reference_class_definition_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkamlReferenceClassDefinitionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkaml_reference_class_definition_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkamlReferenceClassDefinition), 0, (GInstanceInitFunc) gtkaml_reference_class_definition_instance_init, NULL };
		gtkaml_reference_class_definition_type_id = g_type_register_static (GTKAML_TYPE_CLASS_DEFINITION, "GtkamlReferenceClassDefinition", &g_define_type_info, 0);
	}
	return gtkaml_reference_class_definition_type_id;
}




