/* GtkamlParser.vala
 * 
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>


#define GTKAML_TYPE_PARSER (gtkaml_parser_get_type ())
#define GTKAML_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_PARSER, GtkamlParser))
#define GTKAML_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_PARSER, GtkamlParserClass))
#define GTKAML_IS_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_PARSER))
#define GTKAML_IS_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_PARSER))
#define GTKAML_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_PARSER, GtkamlParserClass))

typedef struct _GtkamlParser GtkamlParser;
typedef struct _GtkamlParserClass GtkamlParserClass;
typedef struct _GtkamlParserPrivate GtkamlParserPrivate;

#define GTKAML_TYPE_IMPLICITS_STORE (gtkaml_implicits_store_get_type ())
#define GTKAML_IMPLICITS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_IMPLICITS_STORE, GtkamlImplicitsStore))
#define GTKAML_IMPLICITS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_IMPLICITS_STORE, GtkamlImplicitsStoreClass))
#define GTKAML_IS_IMPLICITS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_IMPLICITS_STORE))
#define GTKAML_IS_IMPLICITS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_IMPLICITS_STORE))
#define GTKAML_IMPLICITS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_IMPLICITS_STORE, GtkamlImplicitsStoreClass))

typedef struct _GtkamlImplicitsStore GtkamlImplicitsStore;
typedef struct _GtkamlImplicitsStoreClass GtkamlImplicitsStoreClass;

#define GTKAML_TYPE_SAX_PARSER (gtkaml_sax_parser_get_type ())
#define GTKAML_SAX_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_SAX_PARSER, GtkamlSAXParser))
#define GTKAML_SAX_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_SAX_PARSER, GtkamlSAXParserClass))
#define GTKAML_IS_SAX_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_SAX_PARSER))
#define GTKAML_IS_SAX_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_SAX_PARSER))
#define GTKAML_SAX_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_SAX_PARSER, GtkamlSAXParserClass))

typedef struct _GtkamlSAXParser GtkamlSAXParser;
typedef struct _GtkamlSAXParserClass GtkamlSAXParserClass;

#define GTKAML_TYPE_CLASS_DEFINITION (gtkaml_class_definition_get_type ())
#define GTKAML_CLASS_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_CLASS_DEFINITION, GtkamlClassDefinition))
#define GTKAML_CLASS_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_CLASS_DEFINITION, GtkamlClassDefinitionClass))
#define GTKAML_IS_CLASS_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_CLASS_DEFINITION))
#define GTKAML_IS_CLASS_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_CLASS_DEFINITION))
#define GTKAML_CLASS_DEFINITION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_CLASS_DEFINITION, GtkamlClassDefinitionClass))

typedef struct _GtkamlClassDefinition GtkamlClassDefinition;
typedef struct _GtkamlClassDefinitionClass GtkamlClassDefinitionClass;

#define GTKAML_TYPE_ROOT_CLASS_DEFINITION (gtkaml_root_class_definition_get_type ())
#define GTKAML_ROOT_CLASS_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_ROOT_CLASS_DEFINITION, GtkamlRootClassDefinition))
#define GTKAML_ROOT_CLASS_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_ROOT_CLASS_DEFINITION, GtkamlRootClassDefinitionClass))
#define GTKAML_IS_ROOT_CLASS_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_ROOT_CLASS_DEFINITION))
#define GTKAML_IS_ROOT_CLASS_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_ROOT_CLASS_DEFINITION))
#define GTKAML_ROOT_CLASS_DEFINITION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_ROOT_CLASS_DEFINITION, GtkamlRootClassDefinitionClass))

typedef struct _GtkamlRootClassDefinition GtkamlRootClassDefinition;
typedef struct _GtkamlRootClassDefinitionClass GtkamlRootClassDefinitionClass;

#define GTKAML_TYPE_IMPLICITS_RESOLVER (gtkaml_implicits_resolver_get_type ())
#define GTKAML_IMPLICITS_RESOLVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_IMPLICITS_RESOLVER, GtkamlImplicitsResolver))
#define GTKAML_IMPLICITS_RESOLVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_IMPLICITS_RESOLVER, GtkamlImplicitsResolverClass))
#define GTKAML_IS_IMPLICITS_RESOLVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_IMPLICITS_RESOLVER))
#define GTKAML_IS_IMPLICITS_RESOLVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_IMPLICITS_RESOLVER))
#define GTKAML_IMPLICITS_RESOLVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_IMPLICITS_RESOLVER, GtkamlImplicitsResolverClass))

typedef struct _GtkamlImplicitsResolver GtkamlImplicitsResolver;
typedef struct _GtkamlImplicitsResolverClass GtkamlImplicitsResolverClass;

#define GTKAML_TYPE_CODE_GENERATOR (gtkaml_code_generator_get_type ())
#define GTKAML_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_CODE_GENERATOR, GtkamlCodeGenerator))
#define GTKAML_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_CODE_GENERATOR, GtkamlCodeGeneratorClass))
#define GTKAML_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_CODE_GENERATOR))
#define GTKAML_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_CODE_GENERATOR))
#define GTKAML_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_CODE_GENERATOR, GtkamlCodeGeneratorClass))

typedef struct _GtkamlCodeGenerator GtkamlCodeGenerator;
typedef struct _GtkamlCodeGeneratorClass GtkamlCodeGeneratorClass;

/**
 * gtkaml entry point
 */
struct _GtkamlParser {
	ValaParser parent_instance;
	GtkamlParserPrivate * priv;
};

struct _GtkamlParserClass {
	ValaParserClass parent_class;
	void (*parse_gtkaml_file) (GtkamlParser* self, ValaSourceFile* gtkaml_source_file);
};

struct _GtkamlParserPrivate {
	ValaCodeContext* context;
	GtkamlImplicitsStore* implicits_store;
};



GType gtkaml_parser_get_type (void);
GType gtkaml_implicits_store_get_type (void);
#define GTKAML_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GTKAML_TYPE_PARSER, GtkamlParserPrivate))
enum  {
	GTKAML_PARSER_DUMMY_PROPERTY
};
GtkamlImplicitsStore* gtkaml_implicits_store_new (void);
GtkamlImplicitsStore* gtkaml_implicits_store_construct (GType object_type);
GtkamlParser* gtkaml_parser_new (void);
GtkamlParser* gtkaml_parser_construct (GType object_type);
GtkamlParser* gtkaml_parser_new (void);
void gtkaml_implicits_store_add_implicits_dir (GtkamlImplicitsStore* self, const char* directory);
void gtkaml_parser_parse (GtkamlParser* self, ValaCodeContext* context, char** implicits_directories, int implicits_directories_length1);
void gtkaml_parser_parse_gtkaml_file (GtkamlParser* self, ValaSourceFile* gtkaml_source_file);
static void gtkaml_parser_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file);
GtkamlSAXParser* gtkaml_sax_parser_new (ValaCodeContext* context, ValaSourceFile* source_file);
GtkamlSAXParser* gtkaml_sax_parser_construct (GType object_type, ValaCodeContext* context, ValaSourceFile* source_file);
GType gtkaml_sax_parser_get_type (void);
GType gtkaml_class_definition_get_type (void);
GType gtkaml_root_class_definition_get_type (void);
GtkamlRootClassDefinition* gtkaml_sax_parser_parse (GtkamlSAXParser* self);
GtkamlImplicitsResolver* gtkaml_implicits_resolver_new (ValaCodeContext* context, GtkamlImplicitsStore* implicits_store);
GtkamlImplicitsResolver* gtkaml_implicits_resolver_construct (GType object_type, ValaCodeContext* context, GtkamlImplicitsStore* implicits_store);
GType gtkaml_implicits_resolver_get_type (void);
void gtkaml_implicits_resolver_resolve (GtkamlImplicitsResolver* self, GtkamlClassDefinition* class_definition);
GtkamlCodeGenerator* gtkaml_code_generator_new (ValaCodeContext* context);
GtkamlCodeGenerator* gtkaml_code_generator_construct (GType object_type, ValaCodeContext* context);
GType gtkaml_code_generator_get_type (void);
void gtkaml_code_generator_generate (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition);
char* gtkaml_code_generator_yield (GtkamlCodeGenerator* self);
static void gtkaml_parser_real_parse_gtkaml_file (GtkamlParser* self, ValaSourceFile* gtkaml_source_file);
static gpointer gtkaml_parser_parent_class = NULL;
static void gtkaml_parser_finalize (ValaCodeVisitor* obj);
static gint _vala_array_length (gpointer array);



GtkamlParser* gtkaml_parser_construct (GType object_type) {
	GtkamlParser* self;
	self = (GtkamlParser*) vala_parser_construct (object_type);
	return self;
}


GtkamlParser* gtkaml_parser_new (void) {
	return gtkaml_parser_construct (GTKAML_TYPE_PARSER);
}


void gtkaml_parser_parse (GtkamlParser* self, ValaCodeContext* context, char** implicits_directories, int implicits_directories_length1) {
	ValaCodeContext* _tmp4;
	ValaCodeContext* _tmp3;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	if (implicits_directories != NULL) {
		{
			char** implicits_dirs_collection;
			int implicits_dirs_collection_length1;
			int implicits_dirs_it;
			implicits_dirs_collection = implicits_directories;
			implicits_dirs_collection_length1 = implicits_directories_length1;
			for (implicits_dirs_it = 0; implicits_dirs_it < implicits_directories_length1; implicits_dirs_it = implicits_dirs_it + 1) {
				const char* _tmp0;
				char* implicits_dirs;
				_tmp0 = NULL;
				implicits_dirs = (_tmp0 = implicits_dirs_collection[implicits_dirs_it], (_tmp0 == NULL) ? NULL : g_strdup (_tmp0));
				{
					gtkaml_implicits_store_add_implicits_dir (self->priv->implicits_store, implicits_dirs);
					implicits_dirs = (g_free (implicits_dirs), NULL);
				}
			}
		}
	}
	{
		char** _tmp1;
		char** datadir_collection;
		int datadir_collection_length1;
		int datadir_it;
		_tmp1 = NULL;
		datadir_collection = _tmp1 = g_get_system_data_dirs ();
		datadir_collection_length1 = _vala_array_length (_tmp1);
		for (datadir_it = 0; datadir_it < _vala_array_length (_tmp1); datadir_it = datadir_it + 1) {
			const char* _tmp2;
			char* datadir;
			_tmp2 = NULL;
			datadir = (_tmp2 = datadir_collection[datadir_it], (_tmp2 == NULL) ? NULL : g_strdup (_tmp2));
			{
				char* filename;
				filename = g_build_filename (datadir, "gtkaml", "implicits", NULL);
				if (g_file_test (filename, G_FILE_TEST_EXISTS)) {
					gtkaml_implicits_store_add_implicits_dir (self->priv->implicits_store, filename);
				}
				datadir = (g_free (datadir), NULL);
				filename = (g_free (filename), NULL);
			}
		}
	}
	_tmp4 = NULL;
	_tmp3 = NULL;
	self->priv->context = (_tmp4 = (_tmp3 = context, (_tmp3 == NULL) ? NULL : vala_code_context_ref (_tmp3)), (self->priv->context == NULL) ? NULL : (self->priv->context = (vala_code_context_unref (self->priv->context), NULL)), _tmp4);
	vala_parser_parse (VALA_PARSER (self), context);
}


static void gtkaml_parser_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file) {
	GtkamlParser * self;
	gboolean _tmp0;
	self = (GtkamlParser*) base;
	g_return_if_fail (source_file != NULL);
	_tmp0 = FALSE;
	if (g_str_has_suffix (vala_source_file_get_filename (source_file), ".vala")) {
		_tmp0 = TRUE;
	} else {
		_tmp0 = g_str_has_suffix (vala_source_file_get_filename (source_file), ".vapi");
	}
	if (_tmp0) {
		VALA_CODE_VISITOR_CLASS (gtkaml_parser_parent_class)->visit_source_file ((ValaCodeVisitor*) VALA_PARSER (self), source_file);
	} else {
		if (g_str_has_suffix (vala_source_file_get_filename (source_file), ".gtkaml")) {
			gtkaml_parser_parse_gtkaml_file (self, source_file);
		}
	}
}


static void gtkaml_parser_real_parse_gtkaml_file (GtkamlParser* self, ValaSourceFile* gtkaml_source_file) {
	GError * inner_error;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gtkaml_source_file != NULL);
	inner_error = NULL;
	if (g_file_test (vala_source_file_get_filename (gtkaml_source_file), G_FILE_TEST_EXISTS)) {
		{
			ValaSourceFile* dummy_file;
			GtkamlSAXParser* sax_parser;
			GtkamlRootClassDefinition* root_class_definition;
			GtkamlImplicitsResolver* implicitsResolver;
			GtkamlCodeGenerator* code_generator;
			char* vala_contents;
			dummy_file = vala_source_file_new (self->priv->context, vala_source_file_get_filename (gtkaml_source_file), FALSE, NULL);
			sax_parser = gtkaml_sax_parser_new (self->priv->context, dummy_file);
			root_class_definition = gtkaml_sax_parser_parse (sax_parser);
			implicitsResolver = gtkaml_implicits_resolver_new (self->priv->context, self->priv->implicits_store);
			gtkaml_implicits_resolver_resolve (implicitsResolver, (GtkamlClassDefinition*) root_class_definition);
			code_generator = gtkaml_code_generator_new (self->priv->context);
			gtkaml_code_generator_generate (code_generator, (GtkamlClassDefinition*) root_class_definition);
			vala_contents = gtkaml_code_generator_yield (code_generator);
			if (vala_contents != NULL) {
				char* _tmp0;
				char* _tmp1;
				char* vala_filename;
				_tmp0 = NULL;
				_tmp1 = NULL;
				vala_filename = (_tmp1 = g_strconcat (_tmp0 = g_strndup (vala_source_file_get_filename (gtkaml_source_file), (gsize) (g_utf8_strlen (vala_source_file_get_filename (gtkaml_source_file), -1) - g_utf8_strlen (".gtkaml", -1))), ".vala", NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
				g_file_set_contents (vala_filename, vala_contents, -1, &inner_error);
				if (inner_error != NULL) {
					vala_filename = (g_free (vala_filename), NULL);
					(dummy_file == NULL) ? NULL : (dummy_file = (vala_source_file_unref (dummy_file), NULL));
					(sax_parser == NULL) ? NULL : (sax_parser = (g_object_unref (sax_parser), NULL));
					(root_class_definition == NULL) ? NULL : (root_class_definition = (g_object_unref (root_class_definition), NULL));
					(implicitsResolver == NULL) ? NULL : (implicitsResolver = (g_object_unref (implicitsResolver), NULL));
					(code_generator == NULL) ? NULL : (code_generator = (g_object_unref (code_generator), NULL));
					vala_contents = (g_free (vala_contents), NULL);
					if (inner_error->domain == G_FILE_ERROR) {
						goto __catch3_g_file_error;
					}
					goto __finally3;
				}
				vala_source_file_set_filename (gtkaml_source_file, vala_filename);
				VALA_CODE_VISITOR_CLASS (gtkaml_parser_parent_class)->visit_source_file ((ValaCodeVisitor*) VALA_PARSER (self), gtkaml_source_file);
				if (!vala_code_context_get_save_temps (self->priv->context)) {
					g_unlink (vala_filename);
				}
				vala_filename = (g_free (vala_filename), NULL);
			}
			(dummy_file == NULL) ? NULL : (dummy_file = (vala_source_file_unref (dummy_file), NULL));
			(sax_parser == NULL) ? NULL : (sax_parser = (g_object_unref (sax_parser), NULL));
			(root_class_definition == NULL) ? NULL : (root_class_definition = (g_object_unref (root_class_definition), NULL));
			(implicitsResolver == NULL) ? NULL : (implicitsResolver = (g_object_unref (implicitsResolver), NULL));
			(code_generator == NULL) ? NULL : (code_generator = (g_object_unref (code_generator), NULL));
			vala_contents = (g_free (vala_contents), NULL);
		}
		goto __finally3;
		__catch3_g_file_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				vala_report_error (NULL, e->message);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			}
		}
		__finally3:
		if (inner_error != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return;
		}
	} else {
		char* _tmp2;
		_tmp2 = NULL;
		vala_report_error (NULL, _tmp2 = g_strdup_printf ("%s not found", vala_source_file_get_filename (gtkaml_source_file)));
		_tmp2 = (g_free (_tmp2), NULL);
	}
}


void gtkaml_parser_parse_gtkaml_file (GtkamlParser* self, ValaSourceFile* gtkaml_source_file) {
	GTKAML_PARSER_GET_CLASS (self)->parse_gtkaml_file (self, gtkaml_source_file);
}


static void gtkaml_parser_class_init (GtkamlParserClass * klass) {
	gtkaml_parser_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_VISITOR_CLASS (klass)->finalize = gtkaml_parser_finalize;
	g_type_class_add_private (klass, sizeof (GtkamlParserPrivate));
	VALA_CODE_VISITOR_CLASS (klass)->visit_source_file = gtkaml_parser_real_visit_source_file;
	GTKAML_PARSER_CLASS (klass)->parse_gtkaml_file = gtkaml_parser_real_parse_gtkaml_file;
}


static void gtkaml_parser_instance_init (GtkamlParser * self) {
	self->priv = GTKAML_PARSER_GET_PRIVATE (self);
	self->priv->implicits_store = gtkaml_implicits_store_new ();
}


static void gtkaml_parser_finalize (ValaCodeVisitor* obj) {
	GtkamlParser * self;
	self = GTKAML_PARSER (obj);
	(self->priv->context == NULL) ? NULL : (self->priv->context = (vala_code_context_unref (self->priv->context), NULL));
	(self->priv->implicits_store == NULL) ? NULL : (self->priv->implicits_store = (g_object_unref (self->priv->implicits_store), NULL));
	VALA_CODE_VISITOR_CLASS (gtkaml_parser_parent_class)->finalize (obj);
}


GType gtkaml_parser_get_type (void) {
	static GType gtkaml_parser_type_id = 0;
	if (gtkaml_parser_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkamlParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkaml_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkamlParser), 0, (GInstanceInitFunc) gtkaml_parser_instance_init, NULL };
		gtkaml_parser_type_id = g_type_register_static (VALA_TYPE_PARSER, "GtkamlParser", &g_define_type_info, 0);
	}
	return gtkaml_parser_type_id;
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}




